﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="AutoNumberType.ascx.cs" Inherits="PowerEasy.Module.General.WebSite.Controls.FieldControl.AutoNumberType" %>
<asp:TextBox ID="TxtAutoNumber" runat="server" CssClass="inputxt"></asp:TextBox>
<input id="ChkDisableAuto" type="checkbox" value="手动填写" /><label for="ChkDisableAuto" style="width: 120px; float: none; margin-left: 0px;">手动填写</label>
<pe:RequiredFieldValidator ID="ReqTxtAutoNumber" runat="server" ControlToValidate="TxtAutoNumber" SetFocusOnError="true" ErrorMessage="<%$ Res :Controls_FieldControl_TextType_ReqTextSingleLine  , 必填项不能为空 %>" Display="Dynamic" Visible="false"></pe:RequiredFieldValidator>
<span style="color: Green">
    <%= Description %>
</span>
<script type="text/javascript">
    $(document).ready(function () {
        var isAutoNumber = '<%= IsAutoNumber.ToString() %>';
        if (isAutoNumber) {
            $("#<%= TxtAutoNumber.ClientID %>").attr("readonly", true);
            $("#ChkDisableAuto").click(function () {
                if ($("#ChkDisableAuto").prop("checked") == false) {
                    $("#<%= TxtAutoNumber.ClientID %>").attr("readonly", true);
                }
                else {
                    $("#<%= TxtAutoNumber.ClientID %>").attr("readonly", false);
                }
            });
            AutoNumber();
        }
    });

    function AutoNumber() {
        var rule = "<%= Settings[2] %>";
        var nowDate = new Date();
        var year = padLeft(nowDate.getFullYear().toString(), 4);
        var month = padLeft(nowDate.getMonth(), 2);
        var day = padLeft(nowDate.getDay(), 2);
        var hour = padLeft(nowDate.getHours(), 2);

        rule = rule.replace("{Year}", year);
        rule = rule.replace("{Month}", month);
        rule = rule.replace("{Day}", day);
        rule = rule.replace("{Hour}", hour);


        var regRandom = /\{Random:(.*)\}/;
        var resultRandom = regRandom.exec(rule);
        if (resultRandom) {
            rule = rule.replace(regRandom, RndNum(parseInt(resultRandom[1])));
        }

        var reg = /\{Ref:(.*)\}/;
        var result = reg.exec(rule);

        var temp = rule;
        if (result) {
            var val = "";
            var refid = 'input[id$="' + result[1] + '"]';
            if ($(refid).val()) {
                val = $(refid).val();
            }
            temp = rule.replace(reg, val);

            $(refid).change(function () {
                if ($("#ChkDisableAuto").prop("checked") != true) {
                    $("#<%= TxtAutoNumber.ClientID %>").val(rule.replace(reg, $(this).val()));
                }
            }).blur(function () {
                if ($("#ChkDisableAuto").prop("checked") != true) {
                    $("#<%= TxtAutoNumber.ClientID %>").val(rule.replace(reg, $(this).val()));
                }
            });
        }
        if ($("#ChkDisableAuto").prop("checked") != true) {
                $("#<%= TxtAutoNumber.ClientID %>").val(temp);
        }
    }

    function RndNum(n) {
        var rnd = "";
        for (var i = 0; i < n; i++)
            rnd += Math.floor(Math.random() * 10);
        return rnd;
    }

    function padLeft(str, lenght) {
        if (str.length >= lenght)
            return str;
        else
            return padLeft("0" + str, lenght);
    }
</script>
