﻿<%@ Application Language="C#" %>
<%@ Import Namespace="PowerEasy.Module.Crm.BusinessLogic" %>
<%@ Import Namespace="PowerEasy.Framework.Components" %>
<%@ Import Namespace="PowerEasy.Framework.ExceptionHandling" %>
<%@ Import Namespace="PowerEasy.Foundation.Web.UI" %>

<script RunAt="server">

    bool orderUpdataStatus = true;

    void Application_Start(object sender, EventArgs e)
    {
        // 在应用程序启动时运行的代码
        if (PowerEasy.Foundation.VersionHelper.IsBizIdea)
        {
            System.Timers.Timer aTimer = new System.Timers.Timer(120000);
            aTimer.Elapsed += new System.Timers.ElapsedEventHandler(OnTimedEvent);
            aTimer.Enabled = true;
            aTimer.AutoReset = true;
            GC.KeepAlive(aTimer);
        }

        // 在程序启动的时候恢复上次未生成HTML未完成的任务
        PowerEasy.Module.General.BusinessLogic.StaticHtml.HtmlBak.LoadBak();

        // 程序启动时启动自动建立索引
        PowerEasy.Module.Search.BusinessLogic.AutoIndexHelper.StartAutoIndex();

        // 程序启动时启动自动生成静态页
        PowerEasy.Module.General.BusinessLogic.StaticHtml.AutoCreateHtmlHelper.StartAutoIndex();

        // 程序启动时启动自动释放客户
        AutoReleaseClientHelper.StartAutoReleaseClient();

        // 程序启动时绑定SiteMap事件
        SiteMap.SiteMapResolve += new SiteMapResolveEventHandler(PowerEasy.Module.General.BusinessLogic.Templates.Template.SiteMap_SiteMapResolve);

        //程序启动标记
        AdminPageHelper.FirstStartup = true;
    }

    void Application_PreSendRequestHeaders(object sender, EventArgs e)
    {
        HttpApplication app = sender as HttpApplication;
        if (app != null &&
            app.Context != null)
        {
            app.Context.Response.Headers.Remove("Server");
        }
    }

    void OnTimedEvent(object source, System.Timers.ElapsedEventArgs e)
    {
        RemindItem.SendInfo();
        if (orderUpdataStatus && PowerEasy.Foundation.SiteConfig.ShopConfig.OrderOverdueDate > 0 && DateTime.Now.Hour == 0)
        {
            orderUpdataStatus = false;
            PowerEasy.Module.Shop.BusinessLogic.Order.UpdateStatus(3, 1, PowerEasy.Foundation.SiteConfig.ShopConfig.OrderOverdueDate.ToString());
        }
        else if (!orderUpdataStatus && DateTime.Now.Hour > 0)
        {
            orderUpdataStatus = true;
        }
    }

    void Session_Start(object sender, EventArgs e)
    {
        //保证应用程序整个会话使用一个静态会话ID
        if (Session != null)
        {
            Session.Add(Guid.NewGuid().ToString(), "");
        }
    }

    void Application_End(object sender, EventArgs e)
    {
        //在程序关闭的时候保存正在生成HTML的任务
        PowerEasy.Module.General.BusinessLogic.StaticHtml.HtmlBak.SaveBak(Application);

        //程序关闭时关闭任务
        PowerEasy.Module.Search.BusinessLogic.AutoIndexHelper.Shutdown();

        //程序关闭时关闭任务
        PowerEasy.Module.General.BusinessLogic.StaticHtml.AutoCreateHtmlHelper.Shutdown();
    }



    void Application_Error(object sender, EventArgs e)
    {
        HttpApplication application = (HttpApplication)sender;
        HttpContext context = application.Context;
        ExceptionHandle.ProcessException(context, PowerEasy.Foundation.SiteConfig.SiteOption.ManageDir);
    }

    void Session_End(object sender, EventArgs e)
    {
        // 在会话结束时运行的代码。 
        // 注意：只有在 Web.config 文件中的 sessionstate 模式设置为 InProc 时，才会引发 Session_End 事件。
        // 如果会话模式设置为 StateServer 或 SQLServer，则不会引发该事件。
    }

    void Application_BeginRequest(object sender, EventArgs e)
    {
        /* Fix for the Flash Player Cookie bug in Non-IE browsers.
         * Since Flash Player always sends the IE cookies even in FireFox
         * we have to bypass the cookies by sending the values as part of the POST or GET
         * and overwrite the cookies with the passed in values.
         * 
         * The theory is that at this point (BeginRequest) the cookies have not been read by
         * the Session and Authentication logic and if we update the cookies here we'll get our
         * Session and Authentication restored correctly
         */
        string visitPage = System.IO.Path.GetFileName(this.Request.FilePath);
        if (!string.Equals(visitPage,"SWFFileUpload.ashx",StringComparison.CurrentCultureIgnoreCase))
        {
            return;
        }

        try
        {
            string session_param_name = "ASPSESSID";
            string session_cookie_name = "ASP.NET_SESSIONID";
            if (HttpContext.Current.Request.Form[session_param_name] != null)
            {
                UpdateCookie(session_cookie_name, HttpContext.Current.Request.Form[session_param_name]);
            }
            else if (HttpContext.Current.Request.QueryString[session_param_name] != null)
            {
                UpdateCookie(session_cookie_name, HttpContext.Current.Request.QueryString[session_param_name]);
            }
        }
        catch (Exception)
        {
            Response.StatusCode = 500;
            Response.Write("Error Initializing Session");
        }

        try
        {
            string auth_param_name = "AUTHID";
            string adminCookieName = "AdminCookie";
            string userCookieName = "UserCookie";
            //string auth_cookie_name = PowerEasy.Foundation.ManageCookies.AdminCookieName;

            if (HttpContext.Current.Request.Form[auth_param_name] != null)
            {
                UpdateCookie(PowerEasy.Foundation.ManageCookies.AdminCookieName, HttpContext.Current.Request.Form[adminCookieName]);
                UpdateCookie(PowerEasy.Foundation.ManageCookies.UserCookieName, HttpContext.Current.Request.Form[userCookieName]);
            }
        }
        catch (Exception)
        {
            Response.StatusCode = 500;
            Response.Write("Error Initializing Forms Authentication");
        }
    }

    void UpdateCookie(string cookie_name, string cookie_value)
    {
        HttpCookie cookie = HttpContext.Current.Request.Cookies.Get(cookie_name);
        if (cookie == null)
        {
            cookie = new HttpCookie(cookie_name);
            HttpContext.Current.Request.Cookies.Add(cookie);
        }

        cookie.Value = cookie_value;
        HttpContext.Current.Request.Cookies.Set(cookie);
    }
</script>

