﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Install.Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>安装向导</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link rev="stylesheet" media="all" href="images/styles.css" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" href="lightbox/jquery.lightbox-0.5.css" media="screen" />
    <script type="text/javascript" src="../JS/jquery.pack.js"></script>
    <script type="text/javascript" src="lightbox/jquery.lightbox-0.5.min.js"></script>
    <script type="text/javascript">
        function CallWebServices() {
            var pwd = $("#<%=this.TxtAdminPassword.ClientID%>").val();
            $.post("/install/checkpwd.ashx", { pwd: pwd },
            function (data) {
                if (data == 0) {
                    $("#<%=this.ValrAdminPassword.ClientID%>").text("管理员密码必须是强密码，不少于8位，包含大小写字母、数字，不能含有空格、不能是容易猜到的常用密码如Admin888等");
                    $("#<%=this.NextButtonStep6.ClientID%>").attr('disabled', "true");
                    $("#<%=this.ValrAdminPassword.ClientID%>").attr('style', "color: Red;");
                }
                else {
                    $('#<%=this.NextButtonStep6.ClientID%>').removeAttr("disabled");
                    $("#<%=this.ValrAdminPassword.ClientID%>").text("*");
                    $("#<%=this.ValrAdminPassword.ClientID%>").attr('style', "color: Red; visibility: hidden;");
                }
            });
        }
    </script>
</head>
<body>
    <div id="content">
        <div id="mainContent" runat="server">
            <h1>
                <asp:Localize ID="Localize4" Text="欢迎安装" runat="server" />
                <asp:Label ID="LblProductName1" runat="server" Text="Label"></asp:Label>
            </h1>
            <form id="form1" runat="server">
                <asp:Wizard ID="WzdInstall" OnNextButtonClick="WzdInstall_NextButtonClick" OnFinishButtonClick="WzdInstall_FinishButtonClick"
                    OnPreviousButtonClick="WzdInstall_PreviousButtonClick" runat="server" ActiveStepIndex="0"
                    DisplaySideBar="False" Width="100%" OnActiveStepChanged="OnActiveStepChanged">
                    <WizardSteps>
                        <asp:WizardStep ID="WizardStep1" runat="server" Title="Step 1">
                            <div id="DivDefault" runat="server" class="infoText">
                                <p>
                                    <asp:Localize ID="Localize5" Text="欢迎您选择安装" runat="server" />
                                    <asp:Label ID="LblProductName2" runat="server" Text="Label"></asp:Label>
                                    ！
                                </p>
                                <p>
                                    <asp:Localize ID="Localize6" Text="本向导将协助您一步步的安装此软件。" runat="server" />
                                </p>
                                <p>
                                    <asp:Localize ID="Localize7" Text="建议您在运行本向导前仔细阅读程序包中的《安装说明》文档，如果您已经阅读过，请点击下一步。"
                                        runat="server" />
                                </p>
                            </div>
                            <div id="licenseBox">
                                <h2>
                                    <asp:Localize ID="Localize8" Text="阅读许可协议" runat="server" /></h2>
                                <div id="license">
                                    <textarea id="TxtLicense" style="width: 98%; height: 240px; border: 0px;" cols="100"
                                        rows="12" runat="server" readonly="readonly">                                
                                                    </textarea>
                                </div>
                                <div class="signature">
                                    <asp:CheckBox ID="ChlkAgreeLicense" AutoPostBack="True" OnCheckedChanged="ChlkAgreeLicense_CheckedChanged"
                                        runat="server" CssClass="input_check" Text=" 我已经阅读并同意此协议" TextAlign="Right" />
                                </div>
                            </div>
                            <div class="return">
                                <asp:Button ID="StartNextButton" runat="server" Enabled="False" CssClass="input_bt"
                                    onmouseover="this.className='input_bt_Over'" onmouseout="this.className='input_bt'"
                                    CommandName="MoveNext" Text="下一步" />
                            </div>
                        </asp:WizardStep>
                        <asp:WizardStep ID="WizardStep2" runat="server" Title="Step 2">
                            <div id="DivInstall1" runat="server" class="infoText">
                                <p>
                                    <img alt="" src="Images/ico01.gif" style="text-align: center" />
                                    <asp:Localize ID="Localize10" Text="现在对您的运行环境进行检测，以确认您的环境符合要求。" runat="server" />
                                </p>
                                <br />
                                <asp:Table ID="TblInstallFileCheck" CellSpacing="0" CssClass="table_date" runat="server">
                                </asp:Table>
                            </div>
                            <div class="return">
                                <asp:Button ID="PreviousButtonStep2" runat="server" CausesValidation="False" CssClass="input_bt"
                                    CommandName="MovePrevious" Text="上一步" onmouseover="this.className='input_bt_Over'"
                                    onmouseout="this.className='input_bt'" />
                                <asp:Button ID="NextButtonStep2" runat="server" CssClass="input_bt" CommandName="MoveNext"
                                    Text="下一步" onmouseover="this.className='input_bt_Over'" onmouseout="this.className='input_bt'" />
                            </div>
                        </asp:WizardStep>
                        <asp:WizardStep ID="WizardStep3" runat="server" Title="Step 3">
                            <div id="DivInstall2" runat="server" class="infoText">
                                <p>
                                    <img alt="" src="Images/ico01.gif" style="text-align: center" /><asp:Localize ID="Localize11"
                                        Text="下面进行数据库连接设置" runat="server" />
                                </p>
                                <p>
                                    <label>
                                        <asp:Localize ID="Localize12" Text="在进入下一步之前，请先设置好数据库的登录帐号并建好数据库，并根据建好的帐号和数据库名填写表单中的项。虚拟主机用户该部分信息会由主机供应商提供。<br/>请确保设置好的数据库中没有旧的数据表和存储过程。"
                                            runat="server" />
                                        <br />
                                        <span style="color: Red;">注意：“支持SQL2005及以上版本创建数据库！创建数据库”功能需要服务器角色“dbcreator”或“sysadmin”权限才能使用，是给高级数据库管理员使用的功能，为了您系统的安全，一般不建议您使用过大权限帐号作为系统数据库账户。</span>
                                    </label>
                                </p>
                                <br />
                                <table cellspacing="0" cellpadding="0" class="table_date">
                                    <tr>
                                        <td style="width: 40%;">
                                            <asp:Localize ID="Localize14" Text="数据源：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtDataSource" runat="server" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrDataSource" runat="server" ControlToValidate="TxtDataSource"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 40%;">
                                            <asp:Localize ID="Localize16" Text="数据库用户名称：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtUserID" runat="server" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrUserID" runat="server" ControlToValidate="TxtUserID"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 40%;">
                                            <asp:Localize ID="Localize17" Text=" 数据库用户口令：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtPassword" runat="server" TextMode="Password" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrPassword" runat="server" ControlToValidate="TxtPassWord"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 40%;">
                                            <asp:Localize ID="Localize15" Text="数据库名称：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtDataBase" runat="server" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrDataBase" runat="server" ControlToValidate="TxtDataBase"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                            <asp:Button ID="CreateDatabase" runat="server" Text="创建数据库" OnClick="CreateDatabase_OnClick" />
                                        </td>
                                    </tr>
                                    <tr runat="server" id="IsHasDemo" visible="false">
                                        <td style="width: 40%;">是否安装演示数据：
                                        </td>
                                        <td>
                                            <asp:RadioButtonList ID="RadInstallDemo" runat="server" RepeatLayout="Flow" RepeatColumns="2"
                                                Width="100">
                                                <asp:ListItem Text="是" Value="1"></asp:ListItem>
                                                <asp:ListItem Text="否" Value="0" Selected="True"></asp:ListItem>
                                            </asp:RadioButtonList>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25" align="center">
                                            <asp:Label ID="LblCheckConnectString" Visible="False" Text="请检查数据库连接字符串设置是否正确或数据库服务器身份验证模式是否SQL Server和Windows混合模式！"
                                                runat="server" ForeColor="Red"></asp:Label><br />
                                            <asp:Label ID="LblSqlException" Visible="False" Text="" runat="server" ForeColor="Red"></asp:Label>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="left140">
                                <div class="return">
                                    <asp:Button ID="PreviousButtonStep3" runat="server" CausesValidation="False" CssClass="input_bt"
                                        CommandName="MovePrevious" Text="上一步" OnClick="PreviousButtonStep3_Click" onmouseover="this.className='input_bt_Over'"
                                        onmouseout="this.className='input_bt'" />
                                    <asp:Button ID="NextButtonStep3" runat="server" CssClass="input_bt" CommandName="MoveNext"
                                        Text="下一步" onmouseover="this.className='input_bt_Over'" onmouseout="this.className='input_bt'" />
                                </div>
                            </div>
                        </asp:WizardStep>
                        <asp:WizardStep ID="WizardStep4" runat="server" Title="Step 4">
                            <div id="Div1" runat="server" class="infoText">
                                <p>
                                    <img alt="" src="Images/ico01.gif" style="text-align: center" /><asp:Localize ID="Localize1"
                                        Text="请选择模板方案" runat="server" />
                                    <p>
                                        <div id="templatetip" style="display: none; top: 103.8px; filter: alpha(opacity=90); opacity: 1; left: 70px; position: absolute;"
                                            class="tip-yellowsimple">
                                            <div class="tip-inner tip-bg-image">
                                                双击可以显示大图
                                            </div>
                                            <div style="visibility: inherit;" class="tip-arrow tip-arrow-bottom">
                                            </div>
                                        </div>
                                        <div id="templateRListdiv" class="templateRListdiv" style="overflow-x: hidden;">
                                            <asp:RadioButtonList runat="server" ID="templateRList" RepeatLayout="Table" RepeatColumns="4">
                                            </asp:RadioButtonList>
                                        </div>
                                        <br />
                            </div>
                            <div class="return">
                                <asp:Button ID="PreviousButtonStep4" runat="server" CausesValidation="False" CssClass="input_bt"
                                    CommandName="MovePrevious" Text="上一步" onmouseover="this.className='input_bt_Over'"
                                    onmouseout="this.className='input_bt'" />
                                <asp:Button ID="NextButtonStep4" runat="server" CommandName="MoveNext" CssClass="input_bt"
                                    Text="下一步" onmouseover="this.className='input_bt_Over'" onmouseout="this.className='input_bt'" />
                            </div>
                            <script type="text/javascript">
                                $(function () {
                                    if ($("#templateRListdiv").height() > 400) {
                                        $("#templateRListdiv").css("height", "400px");
                                        $("#templateRListdiv").css("overflow-y", "scroll");
                                    }
                                    $('#templateRListdiv input:radio[name="WzdInstall$templateRList"]:checked').parent().addClass("templateRListcurrent");
                                    $('#templateRListdiv input').hide();
                                    $("#templateRListdiv input").change(function () {
                                        $('#templateRListdiv td').removeClass("templateRListcurrent");
                                        $('#templateRListdiv input:radio[name="WzdInstall$templateRList"]:checked').parent().addClass("templateRListcurrent");
                                    });

                                    $('.tpic').mouseenter(function () {
                                        $(this).parent().addClass("templateRListcurrent");
                                    }).mouseleave(function () {
                                        $(this).parent().removeClass("templateRListcurrent");
                                    });

                                    $('#templateRListdiv td img').each(function () {
                                        $(this).lightBox();
                                    });

                                    if ($.browser.msie) {
                                        $('#templateRListdiv td').each(function () {
                                            $(this).click(function () {
                                                $(this).find("input[type='radio']").prop("checked", true);
                                                $('#templateRListdiv td').removeClass("templateRListcurrent");
                                                $('#templateRListdiv input:radio[name="WzdInstall$templateRList"]:checked').parent().addClass("templateRListcurrent");
                                            });
                                        });
                                    }

                                    $("#templatetip").fadeIn("slow", function () { window.setTimeout(function () { $("#templatetip").fadeOut("slow"); }, "15000"); });

                                });
                            </script>
                        </asp:WizardStep>
                        <asp:WizardStep ID="WizardStep5" runat="server" Title="Step 5">
                            <script type="text/javascript">
                                function ShowProgress(ele) {
                                    //ele.disabled = true;
                                    var labelDoingID = document.getElementById("<%= LblCreateDataProgress.ClientID %>");
                                    var labelBeforeID = document.getElementById("<%= LblCreateDataBaseBefore.ClientID %>");

                                    if (labelDoingID != null) {
                                        labelDoingID.style.visibility = "visible";
                                    }
                                    if (labelBeforeID != null) {
                                        labelBeforeID.innerHTML = "正在初始化数据库。";
                                    }
                                    return true;
                                }
                            </script>
                            <div id="DivInstall3" runat="server" class="infoText">
                                <p>
                                    <img alt="" src="Images/ico01.gif" style="text-align: center" /><asp:Localize ID="Localize18"
                                        Text="下面将初始化数据库，大约需要1～2分钟。" runat="server" />
                                </p>
                                <p>
                                    <label id="LblCreateDataBaseMessage" runat="server" style="visibility: visible;">
                                        <asp:Localize ID="Localize35" Text="点击" runat="server" />：<strong><asp:Localize ID="Localize36"
                                            Text="开始初始化" runat="server" /></strong><asp:Localize ID="Localize37" Text="按钮开始后，请耐心等候。"
                                                runat="server" />
                                </p>
                                <br />
                                <span style="color: Red">
                                    <asp:Localize ID="Localize38" Text="注意：如果指定的数据库中原来有表与数据，将会删除原来同名对象的数据，请谨慎操作。" runat="server" /></span>
                                </label>
                            <br />
                                <br />
                                <table cellspacing="0" cellpadding="0" class="table_date">
                                    <tr>
                                        <td style="height: 33px;">
                                            <label id="LblCreateDataBaseBefore" runat="server" style="visibility: visible;">
                                                <asp:Localize ID="Localize19" Text="准备初始化数据库。" runat="server" /></label>
                                        </td>
                                        <td style="width: 20%;">
                                            <div class="center">
                                                <label id="LblCreateDataProgress" runat="server" style="visibility: hidden;">
                                                    <img src="../Images/indicator.gif" style="width: 20px; height: 20px; vertical-align: middle;" />
                                                    <asp:Localize ID="Localize20" Text="初始化中。。。" runat="server" /></label>
                                                <img id="ImgCreateDataBaseOK" visible="False" runat="server" src="images/ok.gif"
                                                    width="16" height="16" />
                                                <img id="ImgCreateDataBaseFail" visible="False" runat="server" src="images/error.gif"
                                                    width="16" height="16" />
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                                <br />
                                <asp:CheckBox ID="ChlkIsCreateDataBase" runat="server" AutoPostBack="True" OnCheckedChanged="ChlkIsCreateDataBase_CheckedChanged"
                                    Text=" 如果数据库里初始化好表、存储过程等，可跳过这一步。" />
                                <br />
                                <asp:Label ID="LabelCreateDataBase" Visible="False" Text="" runat="server" ForeColor="Red"></asp:Label>
                            </div>
                            <div class="return">
                                <asp:Button ID="PreviousButtonStep5" runat="server" CausesValidation="False" CssClass="input_bt"
                                    CommandName="MovePrevious" Text="上一步" onmouseover="this.className='input_bt_Over'"
                                    onmouseout="this.className='input_bt'" />
                                <asp:Button ID="NextButtonStep5" runat="server" CommandName="MoveNext" CssClass="input_bt"
                                    Text="下一步" Enabled="False" onmouseover="this.className='input_bt_Over'" onmouseout="this.className='input_bt'" />
                                <asp:Button ID="BtnCreateDateBase" CssClass="input_bt" runat="server" OnClientClick="ShowProgress(this);"
                                    Text="开始初始化" OnClick="BtnCreateDateBase_Click" onmouseover="this.className='input_bt_Over'"
                                    onmouseout="this.className='input_bt'" />
                            </div>
                        </asp:WizardStep>
                        <asp:WizardStep ID="WizardStep6" runat="server" Title="Step 6">
                            <div id="DivInstall4" runat="server" class="infoText">
                                <p>
                                    <img alt="" src="Images/ico01.gif" style="text-align: center" /><asp:Localize ID="Localize22"
                                        Text="下面进行配置文件设置。" runat="server" />
                                </p>
                                <br />
                                <table cellspacing="0" cellpadding="0" class="table_date">
                                    <tr>
                                        <td style="width: 30%">
                                            <asp:Localize ID="Localize23" Text="网站标题：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtSiteTitle" runat="server" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrSiteTitle" runat="server" ControlToValidate="TxtSiteTitle"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Localize ID="Localize24" Text="网站地址：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtSiteUrl" runat="server" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrSiteUrl" runat="server" ControlToValidate="TxtSiteUrl"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="height: 16px">
                                            <asp:Localize ID="Localize25" Text="后台管理目录：" runat="server" /><br />
                                            <span style="color: #FF0000">注意：目录名只能以字母、数字及下划线组成，
                                                目录名不能设置为常用值如Admin、PowerEasy等以免被猜出。</span>
                                        </td>
                                        <td style="height: 16px">
                                            <asp:TextBox ID="TxtManageDir" runat="server" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrManageDir" runat="server" ControlToValidate="TxtManageDir"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Localize ID="Localize26" Text="后台管理认证码：" runat="server" /><br />
                                            <span style="color: #FF0000">注意：后台管理认证码不能设置为常用值如8888、9999等以免被猜出。</span>
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtSiteManageCode" runat="server" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrSiteManageCode" runat="server" ControlToValidate="TxtSiteManageCode"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="height: 15px" colspan="2"></td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Localize ID="Localize27" Text="管理员名称：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtAdminName" Text="Admin" runat="server" Width="150px"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrAdminName" runat="server" ControlToValidate="TxtAdminName"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Localize ID="Localize28" Text="管理员密码：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtAdminPassword" runat="server" Width="150px" TextMode="Password" onblur="CallWebServices();"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrAdminPassword" runat="server" ControlToValidate="TxtAdminPassword"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Localize ID="Localize29" Text="确认密码：" runat="server" />
                                        </td>
                                        <td>
                                            <asp:TextBox ID="TxtAdminPasswordAgain" runat="server" Width="150px" TextMode="Password"></asp:TextBox>
                                            <asp:RequiredFieldValidator ID="ValrAdminPasswordAgain" runat="server" ControlToValidate="TxtAdminPasswordAgain"
                                                ErrorMessage="*"></asp:RequiredFieldValidator>
                                            <asp:CompareValidator ID="ValcAdminPasswordAgain" runat="server" ErrorMessage="两次密码不相同"
                                                ControlToCompare="TxtAdminPassword" ControlToValidate="TxtAdminPasswordAgain"></asp:CompareValidator>
                                        </td>
                                    </tr>
                                    <asp:PlaceHolder ID="PlhSerialNumber" Visible="false" runat="server">
                                        <tr>
                                            <td style="height: 15px" colspan="2"></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:Localize ID="Localize50" Text="产品序列号：" runat="server" />
                                            </td>
                                            <td>
                                                <asp:TextBox ID="TxtSerialNumber" runat="server" Columns="70" onblur="CheckSerialNumber();"></asp:TextBox>
                                                <asp:RequiredFieldValidator ID="ReqTxtSerialNumber" runat="server" ControlToValidate="TxtSerialNumber"
                                                    ErrorMessage="*"></asp:RequiredFieldValidator>
                                                <span id="checkloadding" style="display: none">
                                                    <img src="../Images/indicator.gif" style="width: 15px; height: 15px" /></span>
                                            </td>
                                        </tr>
                                        <tr id="mWorkflowLimit" style="display: none;">
                                            <td>工作流限制用户数：
                                            </td>
                                            <td>
                                                <asp:DropDownList ID="DropWorkflowLimit" runat="server">
                                                    <asp:ListItem Value="50" Selected="True">50用户</asp:ListItem>
                                                    <asp:ListItem Value="100">100用户</asp:ListItem>
                                                    <asp:ListItem Value="200">200用户</asp:ListItem>
                                                    <asp:ListItem Value="500">500用户</asp:ListItem>
                                                    <asp:ListItem Value="999">无限制</asp:ListItem>
                                                </asp:DropDownList>
                                            </td>
                                        </tr>
                                        <script language="javascript">
                                            window.onload = function () {
                                                CheckSerialNumber();
                                            }

                                            function CheckSerialNumber() {
                                                var SerialNumber = document.getElementById("<%=TxtSerialNumber.ClientID%>");
                                                if (SerialNumber.value != "") {
                                                    document.getElementById("checkloadding").style.display = "";
                                                    CallTheServer(SerialNumber.value, "");
                                                }
                                            }

                                            function CallTheServer(arg, context) {
                                        <%=clientCallBackScript%>
                                            }

                                            function ReceiveServerData(data) {
                                                document.getElementById("checkloadding").style.display = "none";
                                                if (data == "true") {
                                                    document.getElementById("mWorkflowLimit").style.display = "";
                                                }
                                                else {
                                                    document.getElementById("mWorkflowLimit").style.display = "none";
                                                }
                                            }
                                        </script>
                                    </asp:PlaceHolder>
                                    <tr>
                                        <td colspan="2" height="25" align="center">
                                            <pe:ExtendedLabel ID="LblErrorMessage" HtmlEncode="false" Enabled="false" ForeColor="Red"
                                                runat="server"></pe:ExtendedLabel>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="return">
                                <asp:Button ID="PreviousButtonStep6" runat="server" CssClass="input_bt" CausesValidation="False"
                                    CommandName="MovePrevious" Text="上一步" onmouseover="this.className='input_bt_Over'"
                                    onmouseout="this.className='input_bt'" />
                                <asp:Button ID="NextButtonStep6" runat="server" CssClass="input_bt" CommandName="MoveNext"
                                    Text="下一步" onmouseover="this.className='input_bt_Over'" onmouseout="this.className='input_bt'" />
                            </div>
                        </asp:WizardStep>
                        <asp:WizardStep ID="WizardStep7" runat="server" Title="Step 7">
                            <div id="DivIntallComplete" runat="server" class="infoText">
                                <p>
                                    <img alt="" src="Images/ico01.gif" style="text-align: center" /><asp:Localize ID="Localize30"
                                        Text="安装完成。" runat="server" />
                                </p>
                                <br />
                                <p>
                                    <asp:Localize ID="Localize31" Text="已经成功安装！" runat="server" /><br />
                                    <asp:Localize ID="Localize32" Text="请点击" runat="server" />“<strong><asp:Localize
                                        ID="Localize33" Text="完成" runat="server" /></strong>”<asp:Localize ID="Localize34"
                                            Text="按钮跳转到首页。" runat="server" />
                                </p>
                                <input id="HdnPassword" type="hidden" visible="False" runat="server" />
                                <div class="clearbox">
                                </div>
                                <br />
                            </div>
                        </asp:WizardStep>
                    </WizardSteps>
                    <StepNavigationTemplate>
                        <center>
                        </center>
                    </StepNavigationTemplate>
                    <StartNavigationTemplate>
                        <center>
                        </center>
                    </StartNavigationTemplate>
                    <FinishNavigationTemplate>
                        <div class="return">
                            <asp:Button ID="PreviousButtonFinish" runat="server" CausesValidation="False" CssClass="input_bt"
                                CommandName="MovePrevious" Text="上一步" onmouseover="this.className='input_bt_Over'"
                                onmouseout="this.className='input_bt'" />
                            <asp:Button ID="FinishButton" runat="server" CssClass="input_bt" CommandName="MoveComplete"
                                Text="完成" onmouseover="this.className='input_bt_Over'" onmouseout="this.className='input_bt'" />
                        </div>
                    </FinishNavigationTemplate>
                </asp:Wizard>
            </form>
        </div>
        <div id="sideBar">
            <ol id="stepList">
                <li id="step1" runat="server" class="current">许可协议</li>
                <li id="step2" runat="server">运行环境检测</li>
                <li id="step3" runat="server">数据库连接设置</li>
                <li id="step4" runat="server">模板方案配置</li>
                <li id="step5" runat="server">初始化数据库</li>
                <li id="step6" runat="server">配置文件设置</li>
                <li id="step7" runat="server">安装完成</li>
            </ol>
            <div id="linkBox">
                <a href="http://www.powereasy.net/" target="_blank" title="访问动易官方网站">官方主站</a>|<a
                    href="http://tech.powereasy.net/" target="_blank" title="动易官方网站技术中心">
                    <asp:Localize ID="Localize2" Text="技术中心" runat="server" /></a> | <a href="http://bbs.powereasy.net/"
                        target="_blank" title="今天您上动易论坛了吗？">
                        <asp:Localize ID="Localize3" Text="动易论坛" runat="server" /></a>
            </div>
            <div id="searchBox">
                <input id="wd" name="wd" class="input_text" type="text" /><input class="input_bt"
                    type="button" value="搜 索" onclick="GoSearch();" />
            </div>
        </div>
    </div>
    <div id="footer">
        <p>
            Powered by <a href="http://www.powereasy.net" target="_blank">
                <asp:Label ID="LblProductName3" runat="server" Text="Label"></asp:Label>
            </a>
        </p>
        <p>
            <a href="http://www.powereasy.net" target="_blank">
                <asp:Label ID="LblProductCopyright" runat="server" Text="Label"></asp:Label>
            </a>
        </p>
    </div>
</body>
<script type="text/javascript">
    function GoSearch() {
        window.open("http://s.powereasy.net/s.aspx?c=3&f=0&wd=" + encodeURI(document.getElementById("wd").value));
    }
</script>
</html>
