﻿<%@ Page Language="C#" StylesheetTheme="" EnableTheming="false" Inherits="PowerEasy.Foundation.Web.UI.DynamicPage"%>
<%@ Import Namespace="PowerEasy.Module.Shop.BusinessLogic" %>
<%@ Import Namespace="PowerEasy.Framework.Common" %>
<%@ Import Namespace="PowerEasy.Foundation" %>
<%@ Import Namespace="PowerEasy.Module.Shop.BusinessLogic" %>
<%@ Import Namespace="PowerEasy.Module.Shop.Model" %>
<script runat="server">
protected void Page_Load(object sender, EventArgs e)
{
    string v_mid, v_oid, v_amount, md5string;

    int payPlatformId = 11;  //快钱神州行支付
    PowerEasy.Module.General.Model.Accessories.PayPlatformInfo payPlatform = PowerEasy.Module.General.BusinessLogic.Accessories.PayPlatform.GetPayPlatformById(payPlatformId);
    if (payPlatform.IsDisabled || payPlatform.MD5 == "3056" || string.IsNullOrEmpty(payPlatform.MD5))
    {
        LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResult99bill_ToPayNo;
        return;
    }
    v_mid = payPlatform.AccountsId;

    string merchantAcctId = StringHelper.Trim(Request["merchantAcctId"]); //获取人民币网关账户号
    string key = payPlatform.MD5; //设置人民币网关密钥
    string version = StringHelper.Trim(Request["version"]);        //获取网关版本
    string language = StringHelper.Trim(Request["language"]);      //获取语言种类,1代表中文；2代表英文
    string payType = StringHelper.Trim(Request["payType"]); //获取支付方式,00：组合支付,10：银行卡支付,11：电话银行支付,12：快钱账户支付,13：线下支付,14：B2B支付
    string cardNumber = StringHelper.Trim(Request["cardNumber"]);  //神州行卡序号,如果通过神州行卡直接支付时返回
    string cardPwd = StringHelper.Trim(Request["cardPwd"]);             //获取神州行卡密码,如果通过神州行卡直接支付时返回
    string orderId = StringHelper.Trim(Request["orderId"]);      //获取商户订单号
    string orderAmount = StringHelper.Trim(Request["orderAmount"]);    //获取原始订单金额
    string dealId = StringHelper.Trim(Request["dealId"]);      //获取快钱交易号
    string orderTime = StringHelper.Trim(Request["orderTime"]); //获取订单提交时间
    string ext1 = StringHelper.Trim(Request["ext1"]);   //获取扩展字段1
    string ext2 = StringHelper.Trim(Request["ext2"]);     //获取扩展字段2
    string payAmount = StringHelper.Trim(Request["payAmount"]);    //获取实际支付金额,单位为分
    string billOrderTime = StringHelper.Trim(Request["billOrderTime"]);    //获取快钱处理时间

    string payResult = StringHelper.Trim(Request["payResult"]);    //10代表 成功11代表 失败
    string signType = StringHelper.Trim(Request["signType"]);   //签名类型,1代表MD5签名
    string signMsg = StringHelper.Trim(Request["signMsg"]);       //获取加密签名串

    //生成加密串。必须保持如下顺序。
    string merchantSignMsgVal = "";
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "merchantAcctId", merchantAcctId);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "version", version);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "language", language);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "payType", payType);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "cardNumber", cardNumber);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "cardPwd", cardPwd);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "orderId", orderId);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "orderAmount", orderAmount);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "dealId", dealId);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "orderTime", orderTime);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "ext1", ext1);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "ext2", ext2);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "payAmount", payAmount);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "billOrderTime", billOrderTime);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "payResult", payResult);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "signType", signType);
    merchantSignMsgVal = PayOnline.AppendParam(merchantSignMsgVal, "key", key);
    md5string = DataCrypto.MD5(merchantSignMsgVal);

    v_oid = orderId;
    v_amount = orderAmount;
    //首先进行签名字符串验证
    StringBuilder message = new StringBuilder();
    bool paySuccess = false;
    if (signMsg.ToUpper() == md5string.ToUpper() && payResult == "10")
    {
        paySuccess = true;
        message.Append(Resources.DynamicPageResources.PayOnline_PayResult99billSzx_ToPayYes);
    }
    else
    {
        message.Append(Resources.DynamicPageResources.PayOnline_PayResult99billSzx_ToPayNo);
    }
    if (paySuccess)
    {
        PayOnline payOnline = new PayOnline();
        PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState payOnlineState = payOnline.UpdateOrder(v_oid, DataConverter.ToDecimal(v_amount) / 100, "", 3, "", true, true);
        if (payOnlineState == PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState.Ok)
        {
            message.Append(payOnline.Message);
        }
        else
        {
            message.Append(PowerEasy.Module.Shop.BusinessLogic.PayOnline.GetStateDescription(payOnlineState));
        }
    }
    LblMsg.Text = message.ToString();
    PayOnline.TestLog(false, Resources.DynamicPageResources.PayOnline_PayResult99billSzx_FastToPay, payResult, signMsg.ToUpper(), md5string.ToUpper());

}

protected void BtnShowOrder_Click(object sender, EventArgs e)
{
    int orderId = Convert.ToInt32(PEContext.Current.Context.Session["OrderID"]);
    if (orderId > 0)
    {
        if (PEContext.Current.User.Identity.IsAuthenticated)
        {
            DynamicResponseRedirect("../User/Shop/ShowOrder.aspx?OrderId=" + orderId.ToString());
        }
        else
        {
            OrderInfo orderInfo = Order.GetOrderById(orderId);
            DynamicResponseRedirect("OrderForm.aspx?OrderNum=" + orderInfo.OrderNum + "&Name=" + orderInfo.ContacterName);
        }
    }

}

protected void BtnReturn_Click(object sender, EventArgs e)
{
    ShopConfig shopConfig = SiteConfig.ShopConfig;
    string returnUrl = shopConfig.AgainBuyUrl;
    if (string.IsNullOrEmpty(returnUrl))
    {
        returnUrl = "~/Category.aspx?id=4";
    }
    DynamicResponseRedirect(returnUrl);
}

protected void BtnGotoUserCenter_Click(object sender, EventArgs e)
{
    DynamicResponseRedirect("~/User/Default.aspx");
}

protected void BtnShowPayRecord_Click(object sender, EventArgs e)
{
    DynamicResponseRedirect("~/User/Info/PaymentLog.aspx");
}
</script>
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title><asp:Localize ID="Localize1" Text="<%$ Res: PayOnline_PayResult99billSzx_Page , 快钱神州行支付 %>" runat="server" /></title>
</head>
<body>
    <form id="form1" runat="server">
    <!--支付成功消息-->
    <div class="ebuycar_order">
        <div class="orderinfo_show">
            <ul class="ebuy_complete">
                <li><span class="p_orderform_mess">
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblMsg" runat="server" ></pe:ExtendedLabel>
                </span></li>
            </ul>
        </div>
        <div class="orderinfo_button">
            <asp:Button ID="BtnReturn" runat="server" OnClick="BtnReturn_Click" CssClass="inputbutton"
                Text="<%$ Res: Shop_OrderSuccess_BtnReturn,返回商店首页 %>" />
            <asp:Button ID="BtnShowOrder" runat="server" OnClick="BtnShowOrder_Click" CssClass="inputbutton"
                Text="<%$ Res: Shop_OrderSuccess_BtnShowOrder,查看订单明细 %>" />
            <asp:Button ID="BtnShowPayRecord" runat="server" OnClick="BtnShowPayRecord_Click" CssClass="inputbutton"
            Text="查看支付明细" />
            <asp:Button ID="BtnGotoUserCenter" runat="server" OnClick="BtnGotoUserCenter_Click"
                CssClass="inputbutton" Text="<%$ Res: Shop_OrderSuccess_BtnGotoUserCenter,进入会员中心 %>" />
            <asp:HiddenField ID="HdnContacterName" runat="server" />
            <asp:HiddenField ID="HdnOrderNum" runat="server" />
        </div>
    </div>    
    </form>
</body>
</html>
         