﻿<%@ Page Language="C#" StylesheetTheme="" EnableTheming="false" Inherits="PowerEasy.Foundation.Web.UI.DynamicPage" %>
<%@ Import Namespace="PowerEasy.Foundation" %>
<%@ Import Namespace="PowerEasy.Module.Shop.BusinessLogic" %>
<%@ Import Namespace="PowerEasy.Module.Shop.Model" %>
<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        string EncodeMsg = Request["EncodeMsg"].Trim();
        string SignMsg = Request["SignMsg"].Trim();

        if (string.IsNullOrEmpty(EncodeMsg) || string.IsNullOrEmpty(SignMsg))
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResultChinaPay_Empty;
            return;
        }

        int payPlatformId = 1000;  //银联网付通
        PowerEasy.Module.General.Model.Accessories.PayPlatformInfo payplatformInfo = PowerEasy.Module.General.BusinessLogic.Accessories.PayPlatform.GetPayPlatformById(payPlatformId);
        if (payplatformInfo.IsDisabled || payplatformInfo.MD5 == "3069" || string.IsNullOrEmpty(payplatformInfo.MD5))
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResult99bill_ToPayNo;
            return;
        }       
        OpenVendorV34.NetTranClass netTran = new OpenVendorV34.NetTranClass();
        
        string SendCertPath = Server.MapPath("~/PayOnline/ChinaPay/GNETEWEB-TEST.cer");   //发送方证书路径(银联证书)
        string RcvCertPath = Server.MapPath("~/PayOnline/ChinaPay/MERCHANT.pfx");         //接收方证书路径(商户证书)
        string RcvCertPWD = payplatformInfo.MD5;                                          //发接收方证书密码(商户证书)
        string decryptedMsg = string.Empty;
        if (netTran.DecryptMsg(EncodeMsg, RcvCertPath, RcvCertPWD) == 0)
        {
            decryptedMsg = netTran.LastResult;
        }
        else
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResultChinaPay_EncryptError;
            return;

        }

        if (netTran.VerifyMsg(SignMsg, decryptedMsg, SendCertPath) != 0)
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResultChinaPay_SignError; 
            return;
        }

        string[] keyValueArray = decryptedMsg.Split(new char[] { '&' }, StringSplitOptions.RemoveEmptyEntries);

        string orderNo = GetValue(keyValueArray, "OrderNo");
        string payNo = GetValue(keyValueArray, "PayNo");
        string payAmount = GetValue(keyValueArray, "PayAmount");
        string currCode = GetValue(keyValueArray, "CurrCode");
        string systemSSN = GetValue(keyValueArray, "SystemSSN");
        string respCode = GetValue(keyValueArray, "RespCode");
        string settDate = GetValue(keyValueArray, "SettDate");
        string reserved01 = GetValue(keyValueArray, "Reserved01");
        string reserved02 = GetValue(keyValueArray, "Reserved02");

        if (respCode == "00")
        {
            //交易成功，更新订单
            PowerEasy.Module.Shop.BusinessLogic.PayOnline payOnline = new PowerEasy.Module.Shop.BusinessLogic.PayOnline();
            payOnline.UpdateOrder(orderNo, PowerEasy.Framework.Common.DataConverter.ToDecimal(payAmount), "", 3, "", true, true);
            LblMsg.Text =Resources.DynamicPageResources.PayOnline_PayResult99bill_ToPayYes;
            return;

        }
        else
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResult99bill_ToPayNo; 
            return;
        }

    }
    private string GetValue(string[] keyValueArray, string fieldName)
    {
        string keyValue = Array.Find(keyValueArray, delegate(string s){ return s.StartsWith(fieldName, StringComparison.CurrentCultureIgnoreCase); });
        return keyValue.Substring(keyValue.IndexOf('=') + 1);
    }


    protected void BtnShowOrder_Click(object sender, EventArgs e)
    {
        int orderId = Convert.ToInt32(PEContext.Current.Context.Session["OrderID"]);
        if (orderId > 0)
        {
            if (PEContext.Current.User.Identity.IsAuthenticated)
            {
                DynamicResponseRedirect("../User/Shop/ShowOrder.aspx?OrderId=" + orderId.ToString());
            }
            else
            {
                OrderInfo orderInfo = Order.GetOrderById(orderId);
                DynamicResponseRedirect("OrderForm.aspx?OrderNum=" + orderInfo.OrderNum + "&Name=" + orderInfo.ContacterName);
            }
        }

    }

    protected void BtnReturn_Click(object sender, EventArgs e)
    {
        ShopConfig shopConfig = SiteConfig.ShopConfig;
        string returnUrl = shopConfig.AgainBuyUrl;
        if (string.IsNullOrEmpty(returnUrl))
        {
            returnUrl = "~/Category.aspx?id=4";
        }
        DynamicResponseRedirect(returnUrl);
    }

    protected void BtnGotoUserCenter_Click(object sender, EventArgs e)
    {
        DynamicResponseRedirect("~/User/Default.aspx");
    }

    protected void BtnShowPayRecord_Click(object sender, EventArgs e)
    {
        DynamicResponseRedirect("~/User/Info/PaymentLog.aspx");
    }
    
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title><asp:Localize ID="Localize1" Text="<%$ Res: PayOnline_PayResultChinaPay_Title , 银联网付通支付 %>" runat="server" /></title>
</head>
<body>
    <form id="form1" runat="server">
    <!--支付成功消息-->
    <div class="ebuycar_order">
        <div class="orderinfo_show">
            <ul class="ebuy_complete">
                <li><span class="p_orderform_mess">
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblMsg" runat="server" ></pe:ExtendedLabel>
                </span></li>
            </ul>
        </div>
        <div class="orderinfo_button">
            <asp:Button ID="BtnReturn" runat="server" OnClick="BtnReturn_Click" CssClass="inputbutton"
                Text="<%$ Res: Shop_OrderSuccess_BtnReturn,返回商店首页 %>" />
            <asp:Button ID="BtnShowOrder" runat="server" OnClick="BtnShowOrder_Click" CssClass="inputbutton"
                Text="<%$ Res: Shop_OrderSuccess_BtnShowOrder,查看订单明细 %>" />
            <asp:Button ID="BtnShowPayRecord" runat="server" OnClick="BtnShowPayRecord_Click" CssClass="inputbutton"
            Text="查看支付明细" />
            <asp:Button ID="BtnGotoUserCenter" runat="server" OnClick="BtnGotoUserCenter_Click"
                CssClass="inputbutton" Text="<%$ Res: Shop_OrderSuccess_BtnGotoUserCenter,进入会员中心 %>" />
            <asp:HiddenField ID="HdnContacterName" runat="server" />
            <asp:HiddenField ID="HdnOrderNum" runat="server" />
        </div>
    </div>    
    </form>
</body>
</html>