﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PayPassword.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.User.Info.PayPassword" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <asp:ScriptManager ID="ScriptManagePayPassword" runat="server" />
    <div class="model_info_one">
                <asp:Localize ID="Localize1" Text="<%$ Res: User_Info_PayPassword_Localize1,修改预付款支付密码 %>"
                    runat="server" />
    </div>
    <div class="model_info_content">
        <table width="100%" border="0" cellspacing="1" cellpadding="0" class="table_style"
            id="TblPayPassword" runat="server">
            <tr class="first">
                <td class="ok_tab" style="width: 50%">
                    <asp:Localize ID="Localize2" Text="<%$ Res: User_Info_PayPassword_Localize2,用 户 名： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:Label ID="LblUserName" runat="server" Text="" />
                </td>
            </tr>
            <tr id="trOldPassword" runat="server">
                <td class="ok_tab" style="width: 50%">
                    <asp:Localize ID="Localize3" Text="<%$ Res: User_Info_PayPassword_Localize3,旧 密 码： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:TextBox ID="TxtOldPassword" runat="server" TextMode="Password"  CssClass="inputxt" AutoComplete="off"/>
                    <pe:RequiredFieldValidator ID="ValrReason" ControlToValidate="TxtOldPassword" runat="server"
                        ErrorMessage="<%$ Res: User_Info_PayPassword_ValrReason,旧密码不能为空！ %>" />
                </td>
            </tr>
            <tr>
                <td class="ok_tab">
                    <asp:Localize ID="Localize4" Text="<%$ Res: User_Info_PayPassword_Localize4,新 密 码： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:TextBox ID="TxtPasswords" runat="server" TextMode="Password" MaxLength="20" AutoComplete="off"
                        onkeyup="isSecurity(this.value);" onblur="Bardisplaynone();" onfocus="Bardisplayshow();" CssClass="inputxt"/>
                    <pe:RequiredFieldValidator ID="ValrPassword" ControlToValidate="TxtPasswords" runat="server"
                        ErrorMessage="<%$ Res: User_Info_PayPassword_ValrPassword,新密码不能为空！ %>" Display="Dynamic" />
                    <asp:RegularExpressionValidator ID="RegularExpressionPassword" runat="server" ControlToValidate="TxtPasswords"
                        ErrorMessage="<%$ Res: User_Info_PayPassword_RegularExpressionPassword,请输入新密码(至少6位)！ %>"
                        ValidationExpression="^.{6,}$" Display="Dynamic" />
                    <span id="BarBorder_TxtUserPassword"></span>
                </td>
            </tr>
            <tr>
                <td class="ok_tab">
                    <asp:Localize ID="Localize5" Text="<%$ Res: User_Info_PayPassword_Localize5,确认密码： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:TextBox ID="TxtConfirmPassword" runat="server" TextMode="Password" MaxLength="20" CssClass="inputxt"/>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorTxtConfirmPassword" ControlToValidate="TxtConfirmPassword"
                        runat="server" ErrorMessage="<%$ Res: User_Info_PayPassword_RequiredFieldValidatorTxtConfirmPassword,确认密码不能为空！ %>" />
                        <asp:CompareValidator ID="CompareValPassword" runat="server" ErrorMessage="<%$ Res: User_Info_Password_ErrMsgPwd,确认密码与新密码不一致！ %>"
                            ControlToValidate="TxtConfirmPassword" ControlToCompare="TxtPasswords" Display="Dynamic"
                            Type="String"></asp:CompareValidator>
                </td>
            </tr>
        </table>
        <div class="ok_bottom">
                    <pe:ExtendedButton ID="EBtnSubmit" Text="<%$ Res: User_Info_PayPassword_EBtnSubmit,修改 %>"
                        IsChecked="false" OnClick="EBtnSubmit_Click" runat="server" CssClass="submit_button"
                         OnClientClick="return BeginClick();" />
        </div>
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table_coulmn">
            <tr>
                <td class="tip">
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblMessage" runat="server"></pe:ExtendedLabel>
                </td>
            </tr>
        </table>
    </div>
        <script type="text/javascript" src="../../JS/Encrypt/BigInt.js"></script>
        <script type="text/javascript" src="../../JS/Encrypt/Encrypt.js"></script>
        <script type="text/javascript" src="../../JS/Encrypt/Barrett.js"></script>
        <script type="text/javascript" src="../../JS/Encrypt/Common.js"></script>
        <script type="text/javascript">
            var BeginClick = function () {
                if (Page_ClientValidate()) {
                    GetRsaEncrypt(2);
                    $("#TxtPasswords").attr("maxlength", "300");
                    $("#TxtConfirmPassword").attr("maxlength", "300");
                    if ($("#TxtOldPassword").length > 0) {
                        $("#TxtOldPassword").val(rsaEncrypt($("#TxtOldPassword").val()));
                    }
                    $("#TxtPasswords").val(rsaEncrypt($("#TxtPasswords").val()));
                    $("#TxtConfirmPassword").val(rsaEncrypt($("#TxtConfirmPassword").val()));
                    return true;
                } else {
                    return false;
                }
            }
        </script>
    </form>
</body>
</html>
