﻿<%@ page language="C#" autoeventwireup="true" inherits="sys_Main, 25175_ALL" %>

<%@ Register Src="~/sys/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/sys/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>江门市新会梁启超纪念中学食堂报餐系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/sys/css/style.css?v=201721" rel="stylesheet" />
    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/locales/bootstrap-datepicker.zh-CN.js"></script>
    <link href="/control/plugin/bootstrap-datepicker/css/datepicker3.css" rel="stylesheet" />

</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class="container-fluid">
        <ul class="nav nav-tabs" role="tablist">
            <li id="mc1" role="presentation"><a href="Main.aspx?mclass=1&date=<%=Request["date"] %>">早餐订餐</a></li>
            <li id="mc2" role="presentation"><a href="Main.aspx?mclass=2&date=<%=Request["date"] %>">午餐订餐</a></li>
            <li id="mc3" role="presentation"><a href="Main.aspx?mclass=3&date=<%=Request["date"] %>">晚餐订餐</a></li>
        </ul>
        <script type="text/javascript">
            $("#mc<%=mclass %>").addClass("active");
        </script>
        <br />
        <div class="row">
            <div class="col-lg-12">
                <div class="panel">
                    <div class="panel-body">
                        <div class="row" style="font-size: 18px;">
                            <div class="col-xs-5 text-danger">
                                距离订餐结束还有：
                                <span id="t_d">00天</span>
                                <span id="t_h">00时</span>
                                <span id="t_m">00分</span>
                                <span id="t_s">00秒</span>

                                <script type="text/javascript">
                                    var EndTime = new Date('<%=OrderEndDate.ToString("yyyy/MM/dd HH:mm:ss") %>');

                                    function GetRTime() {
                                        var NowTime = new Date();
                                        var t = EndTime.getTime() - NowTime.getTime();
                                        var d = 0;
                                        var h = 0;
                                        var m = 0;
                                        var s = 0;
                                        if (t >= 0) {
                                            d = Math.floor(t / 1000 / 60 / 60 / 24);
                                            h = Math.floor(t / 1000 / 60 / 60 % 24);
                                            m = Math.floor(t / 1000 / 60 % 60);
                                            s = Math.floor(t / 1000 % 60);
                                        }
                                        $("#t_d").html(d + " 天");
                                        $("#t_h").html((h < 10 ? "0" : '') + h + " 时");
                                        $("#t_m").html((m < 10 ? "0" : '') + m + " 分");
                                        $("#t_s").html((s < 10 ? "0" : '') + s + " 秒");

                                        if (m == 0 && s == 0 && h == 0 && d == 0) {
                                            clearInterval(djs);
                                        }
                                    }
                                    var djs = setInterval(GetRTime, 0);
                                </script>



                            </div>
                            <div class="col-xs-7 text-success text-right">
                                截至：<%=DateTime.Now.ToString("yyyy年MM月dd日 HH点mm分ss秒 ") %>已有【<span style="color: black"><asp:Literal ID="litCount" runat="server"></asp:Literal></span>】人订餐
                            </div>

                        </div>

                    </div>
                </div>
                <div class="panel">
                    <div class="panel-body">
                        <table id="dataView" class="table table-hover table-striped ">
                            <caption>
                                <asp:Literal ID="litSDate" runat="server"></asp:Literal>订餐名单</caption>
                            <thead>
                                <tr class='table-heading'>
                                    <th>就餐日期</th>
                                    <th>订餐教师</th>
                                    <th>职工号</th>
                                    <th>订餐类型</th>
                                    <th>订餐日期</th>
                                </tr>
                            </thead>
                            <tbody>
                                <asp:Repeater ID="rptData" runat="server">

                                    <ItemTemplate>
                                        <tr>
                                            <td>
                                                <%#((DateTime)Eval("om_mdate")).ToString("ddd yyyy年MM月dd日") %>
                                            </td>
                                            <td>
                                                <%#Eval("t_name")%>
                                            </td>
                                            <td>
                                                <%#Eval("t_jobNumber")%>
                                            </td>
                                            <td>
                                                <%#GetMClassName((int)Eval("om_mclass"))%>
                                            </td>
                                            <td><%#Eval("om_cdate") %></td>
                                        </tr>
                                    </ItemTemplate>

                                </asp:Repeater>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <uc1:MyFooter runat="server" ID="MyFooter" />

</body>
</html>
