﻿<%@ page language="C#" autoeventwireup="true" inherits="sys_Teacher_Teacher, 25175_ALL" %>

<%@ Register Src="~/sys/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/sys/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>江门市新会梁启超纪念中学食堂报餐系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/sys/css/style.css?v=201721" rel="stylesheet" />
    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <script src="/control/plugin/My97DatePicker/WdatePicker.js"></script>
    <link href="/control/css/msgbox.css" rel="stylesheet" />
    <script src="/control/js/msgbox.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/locales/bootstrap-datepicker.zh-CN.js"></script>
    <link href="/control/plugin/bootstrap-datepicker/css/datepicker3.css" rel="stylesheet" />
</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class=" container-fluid">
        <div class="row">
            <div class="col-xs-12 ">
                <h3 class="page-header">教师设置<small> 设置学校教师</small></h3>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="well">
                    <form class="form-inline" method="get">

                        <div class="form-group">
                            <label for="txtstart">姓名:</label>
                            <input type="text" class="form-control" id="txtName" name="name" value="<%=Request["name"] %>" />
                        </div>

                        <button type="submit" class="btn btn-default">查询</button>
                        <button type="button" class="btn btn-default" onclick="add()">
                            <i class="glyphicon glyphicon-plus"></i>添加教师
                        </button>

                    </form>
                </div>
                <div class="panel panel-default">
                    <div class="panel-body">
                        <asp:Repeater ID="rptData" runat="server">
                            <HeaderTemplate>
                                <table id="dataView" class="table table-hover table-striped  ">
                                    <thead>
                                        <tr class='table-heading'>
                                            <th>序号</th>
                                            <th>教师名称</th>
                                            <th>职工号</th>
                                            <th>备注</th>
                                            <th>禁止登录</th>
                                            <th>创建日期</th>
                                            <th>修改日期</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr>

                                    <td>
                                        <%#Eval("rowNum") %>
                                    </td>

                                    <td>
                                        <%#Eval("t_name")%>
                                    </td>
                                    <td>
                                        <%#Eval("t_jobNumber")%>
                                    </td>

                                    <td>
                                        <%#Eval("t_note")%>
                                    </td>
                                    <td>
                                        <%#(bool)Eval("t_login")?"<span class='label label-danger'>禁止登录</label>":String.Empty%>
                                    </td>
                                    <td>
                                        <%#Eval("t_cdate")%>
                                    </td>
                                    <td>
                                        <%#Eval("t_udate")%>
                                    </td>
                                    <td>
                                        <button onclick="edit('<%#Eval("id") %>')" class="btn btn-default btn-xs" type="button">
                                            编辑
                                        </button>
                                        <button class="btn btn-default btn-xs" type="button" onclick="rd('<%#Eval("id") %>')">
                                            删除
                                        </button>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                </tbody> </table>
                            </FooterTemplate>
                        </asp:Repeater>
                    </div>

                    <%-- <div class="panel-footer">--%>
                    <%--</div>--%>
                </div>
                <asp:Literal ID="litPage" runat="server"></asp:Literal>
            </div>
        </div>
    </div>
    <uc1:MyFooter runat="server" ID="MyFooter" />

    <script type="text/javascript">

        function add() {
            $("#iframeContent").hide();
            $("#iframeContent").attr("src", "/sys/Teacher/Teacher_Add.aspx");
            $("#OperDialog").modal({ backdrop :false});
            $("#operTitle").text("添加");
        }
        function edit(id) {

            $("#iframeContent").hide();
            $("#iframeContent").attr("src", "/sys/Teacher/Teacher_Edit.aspx?id=" + id);
            $("#OperDialog").modal({ backdrop: false });
            $("#operTitle").text("编辑");
        }
        function reload() {
            window.location.reload();
        }
        function ShowDialog() {
            $("#iframeContent").show();
        }
        function rd(key) {
            if (confirm('确定删除该项！')) {
                ZENG.msgbox.show('删除中...', 6);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    data: { "did": key },
                    success: function (result) {
                        ZENG.msgbox._hide();
                        if (result.state == 1) {
                            location.reload();
                        } else {
                            alert(result.data);
                        }
                    }
                });
            }
        }
    </script>
    <div class="modal" id="OperDialog" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" >
        <div class="modal-dialog  " role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="operTitle"></h4>
                </div>
                <div class="modal-body">
                    <div style="height: 595px">
                        <iframe id="iframeContent" width="100%" height="590" frameborder="0" style="display: none"></iframe>
                    </div>
                    <!-- Table -->
                </div>
            </div>
        </div>
    </div>

</body>
</html>
