// pages/search/index.js
var app = getApp()
var utils = require('../../utils/util.js')

Page({

  /**
   * 页面的初始数据
   */
  data: {
    list: [
      //   { id: "1", proname: "可调节全支撑腰垫 365sleep", price: 50, pronum: 1, proimg: "https://7esy.z01.com/uploadfiles/qtend/jpg/2017/9/kigdxk.jpg", check: false }
    ],
    totalMoney: 0,
    allCheck: true,
  },
  onLoad: function (options) {
    var that = this;
    //--------------------------------
    utils.APIHelper.cartList(function (list) {
      for (var i = 0; i < list.length; i++) {
        list[i].check = true;
      }
      that.updateTotal(list);
      that.setData({ "list": list });
    });
  },
  getById: function (list, id) {
    var name = "id";
    for (var i = 0; i < list.length; i++) {
      if (list[i][name] == id) { return list[i]; }
    }
    return null;
  },
  //实时显示总金额
  updateTotal: function (list) {
    var totalMoney = 0;
    for (var i = 0; i < list.length; i++) {
      if (list[i].check != true) { continue; }
      var total = (list[i].price * list[i].pronum);
      list[i].total = total.toFixed(2);
      totalMoney += total;
    }
    totalMoney = totalMoney.toFixed(2);
    this.setData({ "totalMoney": totalMoney });
  },
  chkChange: function (e) {
    var list = this.data.list;
    var dataset = e.currentTarget.dataset;
    var model = this.getById(list, dataset.id);
    model.check = !model.check;
    this.updateTotal(list);
    this.setData({ "list": list });
  },
  chkAllChange: function (e) {
    var list = this.data.list;
    var check = !this.data.allCheck;
    for (var i = 0; i < list.length; i++) {
      list[i].check = check;
    }
    this.updateTotal(list);
    this.setData({ "list": list });
    this.setData({ "allCheck": check });
  },
  del: function (e) {
    var list = this.data.list;
    var dataset = e.currentTarget.dataset;
    var name = "id";
    var id = dataset.id;
    //-----------------
    for (var i = 0; i < list.length; i++) {
      if (list[i][name] == id) { list.splice(i, 1); break; }
    }
    this.updateTotal(list);
    this.setData({ "list": list });
    utils.APIHelper.post("cart_del",{"id":id},function(data){
      console.log("del success;");
    });
  },
  plus: function (e) {
    var list = this.data.list;
    var dataset = e.currentTarget.dataset;
    var model = this.getById(list, dataset.id);
    model.pronum++;
    this.updateTotal(list);
    this.setData({ "list": list });
  },
  minus: function (e) {
    var list = this.data.list;
    var dataset = e.currentTarget.dataset;
    var model = this.getById(list, dataset.id);
    if (model.pronum > 1) { model.pronum--; }
    this.updateTotal(list);
    this.setData({ "list": list });
  },
  checkOut: function () {
    var that = this;
    wx.login({
      success: function (res) {
        utils.APIHelper.post("cart_pay", { "code": res.code, "money": that.data.totalMoney }, function (data) {
          var retMod = utils.APIHelper.getResult(data);
          console.log(retMod);
          wx.requestPayment(retMod.result);
        })
      }
    })
  }//checkOut end;
})