var util = require("util");
var app = getApp();
var user = {};
//获取当前登录的用户信息
user.get = function (cfg, cb) {
  if (app.globalData.mu) {
    typeof cb == "function" && cb(app.globalData.mu)
  } else {
    //否则登录,获取code,用code提交至服务端换openid
    wx.login({
      success: function (loginRes) {
        //提交至服务端,换取openid,根据openid返回绑定的用户
        //用户不存在则新建后返回用户信息
        //----------------------------
        utils.APIHelper.getUser(loginRes.code, function (mu) {
          //为mu附加上当前的微信的用户名与头像(也可直接使用服务端昵称与头像)
          //如果是新用户的话,将昵称与头像传递至服务端
          wx.getUserInfo({
            success: function (res) {
              //res.userInfo
              mu.HoneyName = res.userInfo.nickName;
              mu.UserFace = res.userInfo.avatarUrl;
              that.globalData.userInfo = res.userInfo;
              that.globalData.mu = mu;
              typeof cb == "function" && cb(that.globalData.mu);
            }
          })//getUserInfo end;
        });
      }
    })
  }//else end;
}
//=====================================
//cfg={cpage:1,psize:10,nid:0}
//命名=list,get,add,del,update
var content = {};
content.list = function (cfg, cb) {
  util.APIHelper.post("content_list", cfg, function (data) {
    var retMod = util.APIHelper.getResult(data);
    cb(retMod);
  });
}
content.get = function (id, cb) {
  util.APIHelper.post("content_get", { "id": id }, function (data) {
    var retMod = util.APIHelper.getResult(data);
    cb(retMod.result);
  });
}
//=====================================
var product = {};
product.list = function (cfg, cb) {
  util.APIHelper.post("product_list", cfg, function (data) {
    var retMod = util.APIHelper.getResult(data);
    cb(retMod);
  });
}
product.get = function (id, cb) {
  util.APIHelper.post("product_get", { "id": id }, function (data) {
    var retMod = util.APIHelper.getResult(data);
    cb(retMod.result);
  });
}
var node = {};
node.list = function (cfg, cb) {
  util.APIHelper.post("node_list", cfg, function (data) {
    var retMod = util.APIHelper.getResult(data);
    cb(retMod);
  });
}
//=====================================
var cart = {};
//=====================================
var payment = {};
//获取支付参数,用于结账 {money:"",payno:""}
payment.checkOut = function (cfg, cb) {
  wx.showLoading({ title: '正在请求支付' });
  wx.login({
    success: function (res) {
      cfg.code = res.code;
      util.APIHelper.post("payment_checkout", cfg, function (data) {
        wx.hideLoading();
        var retMod = util.APIHelper.getResult(data);
        wx.requestPayment(retMod.result);
      })
    }
  })
}
module.exports = {
  user: user,
  content: content,
  product: product,
  node: node,
  payment: payment
}