using System;
using System.Collections;
using System.IO;
using System.Web.UI;

namespace flash
{
	/// <summary>
	/// FetchHtmlWriter ȡ aspx ҳֵ html 룬 streamWriter ָļ
	/// </summary>
	/// <example>
	/// public class Index : System.Web.UI.Page
	/// {
	///		// д Index  Render 
	///		protected override void Render(HtmlTextWriter writer)
	///		{
	///			// ı
	///			StreamWriter streamWriter=new StreamWriter(@"Index.html", false);
	///
	///			//  HTML Ļ豸ı
	///			base.Render(new FetchHtmlWriter(writer, streamWriter));
	///
	///			// ˢıд̬ĵ
	///			streamWriter.Flush();
	///			streamWriter.Close();
	///		}
	///	}
	/// </example>
	public class FetchHtmlWriter : HtmlTextWriter
	{
		// HTML 
		private HtmlTextWriter htmlTextWriter=null;
		// ı
		private StreamWriter streamWriter=null;
		// HTML ǩ
		private Hashtable attributes=new Hashtable();
		// HTML ʽ
		private Hashtable styles=new Hashtable();

		#region  CustomHtmlWriter 
		/// <summary>
		///  FetchHtmlWriter 
		/// </summary>
		/// <param name="htmlTextWriter">HTML </param>
		/// <param name="streamWriter">ı</param>
		public FetchHtmlWriter(HtmlTextWriter htmlTextWriter, StreamWriter streamWriter) : base(htmlTextWriter)
		{
			this.htmlTextWriter=htmlTextWriter;
			this.streamWriter=streamWriter;
		}
		#endregion

		#region д HtmlTextWriter Ա
		/// <summary>
		/// Ե
		/// </summary>
		/// <param name="name"></param>
		/// <param name="value">ֵ</param>
		public override void AddAttribute(string name, string value)
		{
			this.attributes.Add(name, value);
			this.htmlTextWriter.AddAttribute(name, value);
		}

		/// <summary>
		/// Ե
		/// </summary>
		/// <param name="name"></param>
		/// <param name="value">ֵ</param>
		/// <param name="fEncode">ǷΪ HTML </param>
		public override void AddAttribute(string name, string value, bool fEncode)
		{
			this.attributes.Add(name, this.EncodeAttributeValue(value, fEncode));
			this.htmlTextWriter.AddAttribute(name, value, fEncode);
		}

		/// <summary>
		/// Ե
		/// </summary>
		/// <param name="key">Լ</param>
		/// <param name="value">ֵ</param>
		public override void AddAttribute(HtmlTextWriterAttribute key, string value)
		{
			this.attributes.Add(key.ToString(), value);
			this.htmlTextWriter.AddAttribute(key, value);
		}

		/// <summary>
		/// Ե
		/// </summary>
		/// <param name="key">Լ</param>
		/// <param name="value">ֵ</param>
		/// <param name="fEncode">ǷΪ HTML </param>
		public override void AddAttribute(HtmlTextWriterAttribute key, string value, bool fEncode)
		{
			this.attributes.Add(key.ToString(), this.EncodeAttributeValue(value, fEncode));
			this.htmlTextWriter.AddAttribute(key, value, fEncode);
		}

		/// <summary>
		///  CSS Ե
		/// </summary>
		/// <param name="name"></param>
		/// <param name="value">ֵ</param>
		public override void AddStyleAttribute(string name, string value)
		{
			this.styles.Add(name, value);
			this.htmlTextWriter.AddAttribute(name, value);
		}

		/// <summary>
		///  CSS Ե
		/// </summary>
		/// <param name="key">Լ</param>
		/// <param name="value">ֵַ</param>
		public override void AddStyleAttribute(HtmlTextWriterStyle key, string value)
		{
			this.styles.Add(key.ToString(), value);
			this.htmlTextWriter.AddStyleAttribute(key, value);
		}

		/// <summary>
		/// ƿʼǣ磺<body bgcolor="#ffffff">
		/// </summary>
		/// <param name="tagName">ҪƵĿʼ</param>
		public override void RenderBeginTag(string tagName)
		{
			base.PushEndTag(tagName);

			this.htmlTextWriter.RenderBeginTag(tagName);
			this.streamWriter.Write("<"+tagName);

			this.RenderStyleAttribute();
		}

		/// <summary>
		/// ƿʼǣ磺<body bgcolor="#ffffff">
		/// </summary>
		/// <param name="tagKey">ҪƵĿʼǼ</param>
		public override void RenderBeginTag(HtmlTextWriterTag tagKey)
		{
			base.PushEndTag(tagKey.ToString());

			this.htmlTextWriter.RenderBeginTag(tagKey);
			this.streamWriter.Write("<"+tagKey.ToString());

			this.RenderStyleAttribute();
		}

		/// <summary>
		/// ƽǣ磺</html>
		/// </summary>
		public override void RenderEndTag()
		{
			this.htmlTextWriter.RenderEndTag();
			this.streamWriter.Write("</"+base.PopEndTag()+">");	
		}

		/// <summary>
		/// ֵ
		/// </summary>
		/// <param name="value">ҪĲֵ</param>
		public override void Write(bool value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// ַ
		/// </summary>
		/// <param name="value">Ҫֵַ</param>
		public override void Write(char value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// ַ
		/// </summary>
		/// <param name="buffer">Ҫַ</param>
		public override void Write(char[] buffer)
		{
			this.htmlTextWriter.Write(buffer);
			this.streamWriter.Write(buffer);
		}

		/// <summary>
		/// ַ
		/// </summary>
		/// <param name="buffer">Ҫַ</param>
		/// <param name="index">ʼλ</param>
		/// <param name="count"></param>
		public override void Write(char[] buffer, int index, int count)
		{
			this.htmlTextWriter.Write(buffer, index, count);
			this.streamWriter.Write(buffer, index, count);
		}

		/// <summary>
		/// ʮ
		/// </summary>
		/// <param name="value">Ҫʮֵ</param>
		public override void Write(decimal value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// ˫
		/// </summary>
		/// <param name="value">Ҫ˫ֵ</param>
		public override void Write(double value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value">Ҫĵֵ</param>
		public override void Write(float value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value">Ҫֵ</param>
		public override void Write(int value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value">Ҫĳֵ</param>
		public override void Write(long value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		///  Object
		/// </summary>
		/// <param name="value">Ҫ Object ֵ</param>
		public override void Write(object value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// ַ
		/// </summary>
		/// <param name="format">ַʽ</param>
		/// <param name="arg0">ʽ 0</param>
		public override void Write(string format, object arg0)
		{
			this.htmlTextWriter.Write(format, arg0);
			this.streamWriter.Write(format, arg0);
		}

		/// <summary>
		/// ַ
		/// </summary>
		/// <param name="format">ַʽ</param>
		/// <param name="arg0">ʽ 0</param>
		/// <param name="arg1">ʽ 1</param>
		public override void Write(string format, object arg0, object arg1)
		{
			this.htmlTextWriter.Write(format, arg0, arg1);
			this.streamWriter.Write(format, arg0, arg1);
		}

		/// <summary>
		/// ַ
		/// </summary>
		/// <param name="format">ַʽ</param>
		/// <param name="arg0">ʽ 0</param>
		/// <param name="arg1">ʽ 1</param>
		/// <param name="arg2">ʽ 2</param>
		public override void Write(string format, object arg0, object arg1, object arg2)
		{
			this.htmlTextWriter.Write(format, arg0, arg1, arg2);
			this.streamWriter.Write(format, arg0, arg1, arg2);
		}

		/// <summary>
		/// ַ
		/// </summary>
		/// <param name="format">ַʽ</param>
		/// <param name="arg">ʽ</param>
		public override void Write(string format, params object[] arg)
		{
			this.htmlTextWriter.Write(format, arg);
			this.streamWriter.Write(format, arg);
		}

		/// <summary>
		/// ַ
		/// </summary>
		/// <param name="value">Ҫֵַ</param>
		public override void Write(string value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// ޷
		/// </summary>
		/// <param name="value">Ҫ޷ֵ</param>
		public override void Write(uint value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// ޷ų
		/// </summary>
		/// <param name="value">Ҫ޷ųֵ</param>
		public override void Write(ulong value)
		{
			this.htmlTextWriter.Write(value);
			this.streamWriter.Write(value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="value">ֵ</param>
		public override void WriteAttribute(string name, string value)
		{
			this.htmlTextWriter.WriteAttribute(name, value);
			this.streamWriter.Write(" {0}=\"{1}\"", name, value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="value">ֵ</param>
		/// <param name="fEncode">ǷΪ HTML </param>
		public override void WriteAttribute(string name, string value, bool fEncode)
		{
			this.htmlTextWriter.WriteAttribute(name, value, fEncode);
			this.streamWriter.Write(" {0}=\"{1}\"", name, this.EncodeAttributeValue(value, fEncode));
		}

		/// <summary>
		/// ʼǣ磺<html
		/// </summary>
		/// <param name="tagName">ҪĿʼ</param>
		public override void WriteBeginTag(string tagName)
		{
			this.htmlTextWriter.WriteBeginTag(tagName);
			this.streamWriter.Write("<"+tagName);
		}

		/// <summary>
		/// ǣ磺</html>
		/// </summary>
		/// <param name="tagName">ҪĽ</param>
		public override void WriteEndTag(string tagName)
		{
			this.htmlTextWriter.WriteEndTag(tagName);
			this.streamWriter.Write("</"+tagName+">");
		}

		/// <summary>
		/// ʼǣ磺<body bgcolor="#ffffff">
		/// </summary>
		/// <param name="tagName">ҪĿʼ</param>
		public override void WriteFullBeginTag(string tagName)
		{
			this.htmlTextWriter.WriteFullBeginTag(tagName);
			this.streamWriter.Write("<"+tagName);

			this.RenderStyleAttribute();
		}

		/// <summary>
		/// һ
		/// </summary>
		public override void WriteLine()
		{
			this.htmlTextWriter.WriteLine();
			this.streamWriter.WriteLine();
		}

		/// <summary>
		/// һвֵ
		/// </summary>
		/// <param name="value">ҪĲֵ</param>
		public override void WriteLine(bool value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һַ
		/// </summary>
		/// <param name="value">Ҫַ</param>
		public override void WriteLine(char value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һַ
		/// </summary>
		/// <param name="buffer">Ҫַ</param>
		public override void WriteLine(char[] buffer)
		{
			this.htmlTextWriter.WriteLine(buffer);
			this.streamWriter.WriteLine(buffer);
		}

		/// <summary>
		/// һַ
		/// </summary>
		/// <param name="buffer">Ҫַ</param>
		/// <param name="index">ʼλ</param>
		/// <param name="count"></param>
		public override void WriteLine(char[] buffer, int index, int count)
		{
			this.htmlTextWriter.WriteLine(buffer, index, count);
			this.streamWriter.WriteLine(buffer, index, count);
		}

		/// <summary>
		/// һʮ
		/// </summary>
		/// <param name="value">Ҫʮֵ</param>
		public override void WriteLine(decimal value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һ˫
		/// </summary>
		/// <param name="value">Ҫ˫ֵ</param>
		public override void WriteLine(double value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һе
		/// </summary>
		/// <param name="value">Ҫĵֵ</param>
		public override void WriteLine(float value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һ
		/// </summary>
		/// <param name="value">Ҫֵ</param>
		public override void WriteLine(int value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һг
		/// </summary>
		/// <param name="value">Ҫĳֵ</param>
		public override void WriteLine(long value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һ Object
		/// </summary>
		/// <param name="value">Ҫ Object ֵ</param>
		public override void WriteLine(object value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һı
		/// </summary>
		/// <param name="format">ıʽ</param>
		/// <param name="arg0">ʽ 0</param>
		public override void WriteLine(string format, object arg0)
		{
			this.htmlTextWriter.WriteLine(format, arg0);
			this.streamWriter.WriteLine(format, arg0);
		}

		/// <summary>
		/// һı
		/// </summary>
		/// <param name="format">ıʽ</param>
		/// <param name="arg0">ʽ 0</param>
		/// <param name="arg1">ʽ 1</param>
		public override void WriteLine(string format, object arg0, object arg1)
		{
			this.htmlTextWriter.WriteLine(format, arg0, arg1);
			this.streamWriter.WriteLine(format, arg0, arg1);
		}

		/// <summary>
		/// һı
		/// </summary>
		/// <param name="format">ıʽ</param>
		/// <param name="arg0">ʽ 0</param>
		/// <param name="arg1">ʽ 1</param>
		/// <param name="arg2">ʽ 2</param>
		public override void WriteLine(string format, object arg0, object arg1, object arg2)
		{
			this.htmlTextWriter.WriteLine(format, arg0, arg1, arg2);
			this.streamWriter.WriteLine(format, arg0, arg1, arg2);
		}

		/// <summary>
		/// һı
		/// </summary>
		/// <param name="format">ıʽ</param>
		/// <param name="arg">ʽ</param>
		public override void WriteLine(string format, params object[] arg)
		{
			this.htmlTextWriter.WriteLine(format, arg);
			this.streamWriter.WriteLine(format, arg);
		}

		/// <summary>
		/// һ޷
		/// </summary>
		/// <param name="value">Ҫ޷ֵ</param>
		public override void WriteLine(uint value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һ޷ų
		/// </summary>
		/// <param name="value">Ҫ޷ųֵ</param>
		public override void WriteLine(ulong value)
		{
			this.htmlTextWriter.WriteLine(value);
			this.streamWriter.WriteLine(value);
		}

		/// <summary>
		/// һַ
		/// </summary>
		/// <param name="s">Ҫֵַ</param>
		public override void WriteLine(string s)
		{
			this.htmlTextWriter.WriteLine(s);
			this.streamWriter.WriteLine(s);
		}

		/// <summary>
		///  Style ʽ
		/// </summary>
		/// <param name="name">ʽ</param>
		/// <param name="value">ֵַ</param>
		public override void WriteStyleAttribute(string name, string value)
		{
			this.htmlTextWriter.WriteStyleAttribute(name, value);
			this.streamWriter.Write(" {0}=\"{1}\"", name, value);
		}

		/// <summary>
		///  Style ʽ
		/// </summary>
		/// <param name="name">ʽ</param>
		/// <param name="value">ֵַ</param>
		/// <param name="fEncode">ǷΪ HTML </param>
		public override void WriteStyleAttribute(string name, string value, bool fEncode)
		{
			this.htmlTextWriter.WriteStyleAttribute (name, value, fEncode);
			this.streamWriter.Write(" {0}=\"{1}\"", name, this.EncodeAttributeValue(value, fEncode));
		}
		#endregion

		/// <summary>
		/// дǩԺʽ
		/// </summary>
		private void RenderStyleAttribute()
		{
			// дǩ
			foreach(object key in this.attributes.Keys)
				this.streamWriter.Write(" {0}=\"{1}\"", key.ToString(), this.attributes[key].ToString());

			// дǩʽ
			if(this.styles.Count>0)
			{
				this.streamWriter.Write(" style=\"");

				foreach(object key in this.styles.Keys)
					this.streamWriter.Write("{0}: {1}; ", key.ToString(), this.styles[key].ToString());

				this.streamWriter.Write("\"");
			}

			// Ժʽ
			this.attributes.Clear();
			this.styles.Clear();

			// д
			this.streamWriter.Write(">");
		}
	}
}