using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;

namespace flash
{
	/// <summary>
	/// Pager ժҪ˵
	/// </summary>
	public class Pager : Control
	{
		private string _UrlFormat;
		private int _PageSize;
		private int _RecordCount;
		private int _PageCount = 5;

		/// <summary>
		/// Ӹʽ
		/// </summary>
		public string UrlFormat
		{
			get
			{
				return _UrlFormat;
			}
			set
			{
				_UrlFormat = value;
			}
		}

		/// <summary>
		/// ҳ
		/// </summary>
		public int PageSize
		{
			get
			{
				return _PageSize;
			}
			set
			{
				_PageSize = value;
			}
		}

		/// <summary>
		/// ǰҳ
		/// </summary>
		public int PageIndex
		{
			get
			{
				string Pageindex = HttpContext.Current.Request.QueryString["pc"];
				if ( Pageindex != null )
				{
					return int.Parse(Pageindex);
				}
				return 1;
			}
		}

		/// <summary>
		/// ܼ¼
		/// </summary>
		public int RecordCount
		{
			get
			{
				return _RecordCount;
			}
			set
			{
				_RecordCount = value;
			}
		}

		/// <summary>
		/// ʾ
		/// </summary>
		public int PageCount
		{
			get
			{
				return _PageCount;
			}
			set
			{
				_PageCount = value;
			}
		}

		protected override void Render(HtmlTextWriter writer)
		{
			int SumPage = (RecordCount + PageSize - 1)/PageSize;

			int start = PageIndex - PageCount;
			int end = PageIndex + PageCount;

			//PageIndexΪģǰʾPageҳ뵼
			if (SumPage>(PageCount*2+1))
			{
				if (start<1)
				{
					start = 1;
					end = start + 10;
				}
				else if (end>SumPage)
				{
					start = SumPage - 10;
					end = SumPage;
				}
			}
			else
			{
				start = 1;
				end = SumPage;
			}
   


			string tmp = "<a href=\"" + UrlFormat + "\">[{0}]</a>";
			StringBuilder sb = new StringBuilder();
			if (PageIndex > 1 && RecordCount > 0)
			{
				sb.Append(string.Format("<a href=\"" + UrlFormat + "\">ҳ</a>", 1));
				sb.Append(string.Format("&nbsp;<a href=\"" + UrlFormat + "\">һҳ</a>", PageIndex - 1));
			}
			for (int i = start; i <= end; i++)
			{
				sb.Append("&nbsp;");
				if (i==PageIndex)
				{
					sb.Append("[" + PageIndex.ToString() + "]");
				}
				else
				{
					sb.Append(string.Format(tmp, i));
				}
			}
			if (PageIndex < SumPage)
			{
				sb.Append(string.Format("&nbsp;<a href=\"" + UrlFormat + "\">һҳ</a>", PageIndex + 1));
				sb.Append(string.Format("&nbsp;<a href=\"" + UrlFormat + "\">βҳ</a>", SumPage));
			}
			writer.Write(sb.ToString());
		}

	}
}

