/**
 * imageZoom (Version 2.0)
 * @author lv ming (akm107@163.com)
 *
 * Create a ImageZoom
 * @example new ImageZoom(container, {url:['LARGE','BIG']});
 * on Jquery
 *
 */

function ImageZoom(container, options){
	this.zoom=$(container);
	this.zoomImg=$(container+' img:first');
	this.options=$.extend({
		xzoom:400,
		yzoom:380,
		offset:10,
		zoomW:800,
		zoomH:720,
		url:null
		},options);
	this.imgInfo={};
	this.init();
	}
ImageZoom.prototype={
	init:function(){
		var that=this;
		this.zoom.hover(function(){that._pretreat();},function(){that._removeZoom();});
		},
	_pretreat:function(){
		var that=this, zoomImg=this.zoomImg, imgInfo=this.imgInfo, op=this.options,
			smallSrc=zoomImg.attr('src'), newImg, largeSrc;
		var isInfo=smallSrc in imgInfo;
		if(!isInfo){
			imgInfo[smallSrc]={};
			largeSrc=smallSrc.replace(new RegExp(op.url[0], 'i'), op.url[1]);
			imgInfo[smallSrc].bigPic=1;
			imgInfo[smallSrc].largeSrc=largeSrc;
			newImg=new Image();
			$(newImg).error(function(){
				imgInfo[smallSrc].bigPic=0;
				});
			newImg.src=largeSrc;
			setTimeout(function(){selectImg(largeSrc)},250);
		}else{
			selectImg();
			}
		function selectImg(largeSrc){
			var bigPic=that.imgInfo[smallSrc].bigPic,
				preLargeSrc=that.imgInfo[smallSrc].largeSrc,
				largeSrc=largeSrc;
			if(bigPic===0){
				largeSrc = largeSrc? (that.imgInfo[smallSrc].largeSrc=largeSrc.replace(/(?:BIG)(\/\w+\/\w+)(?:B)(\d+\.JPG)/i, 'ORIGIN$1M$2')): preLargeSrc;
				return;//不显示大图
				//that._addZoom(largeSrc, 400, 520);
				}else{
				that._addZoom(preLargeSrc, 800, 720);
				}
			}
		},
	_addZoom:function(largeSrc, zoomW, zoomH){
		var zoom=this.zoom, zoomImg=this.zoomImg, op=this.options,
			largeWidth=zoomW, largeHeight=zoomH,
			smallSrc=zoomImg.attr('src'), largeSrc=largeSrc,
			small, large,
			imageLeft, imageTop, imageWidth, imageHeight,
			zoomDiv, zoomFocus,
			leftPos;
		imageLeft=zoom.offset().left;
		imageTop=zoom.offset().top;
		imageWidth=zoomImg[0].offsetWidth;
		imageHeight=zoomImg[0].offsetHeight;
		leftPos=imageLeft+imageWidth+op.offset;
		zoom.css({position:'relative'});
		this.alt=zoomImg.attr('alt');
		zoomImg.attr('alt','');
		if(zoom.next('.J_zoom_div').length===0){
			zoom.append('<div class="J_zoom_focus">&nbsp;</div>');
			zoom.after('<div class="J_zoom_div"><img src="'+smallSrc+'" class="J_zoom_small"><img src="'+largeSrc+'" class="J_zoom_large"></div>');
		}else{
			zoom.next('.J_zoom_div').remove();
			zoom.append('<div class="J_zoom_focus">&nbsp;</div>');
			zoom.after('<div class="J_zoom_div"><img src="'+smallSrc+'" class="J_zoom_small"><img src="'+largeSrc+'" class="J_zoom_large"></div>');
			}
		this.zoomDiv=zoomDiv=zoom.next('div.J_zoom_div');
		this.zoomFocus=zoomFocus=zoom.find('div.J_zoom_focus');
		zoomDiv.css({width:op.xzoom,height:op.yzoom,left:310,top:0,overflow:'hidden', position:'absolute',zIndex:100, border:'1px solid #333', opacity:1});
		zoomFocus.css({cursor:'move',position:'absolute',border:'1px solid #E4E4E4',zIndex:10,opacity:0.5, backgroundColor:'#FFF'});
		large=zoomDiv.find('.J_zoom_large');
		small=zoomDiv.find('.J_zoom_small');
		small.css({position:'absolute',top:0,left:0,zIndex:1,width:largeWidth,height:largeHeight});
		large.css({position:'absolute',top:0,left:0,zIndex:2,width:largeWidth,height:largeHeight});
		$('body').bind('mousemove', function(e){
			var x=e.pageX;
			var y=e.pageY;
			var scaleX=largeWidth/imageWidth;
			var scaleY=largeHeight/imageHeight;
			zoomFocus.css({width:(op.xzoom)/scaleX, height:(op.yzoom)/scaleY});
			var zFocusWidth=zoomFocus.width();
			var zFocusHeight=zoomFocus.height();
			var xPos=x-zFocusWidth/2-imageLeft;
			var yPos=y-zFocusHeight/2-imageTop;
			xPos=(x-zFocusWidth/2 < imageLeft)? 0: (x+zFocusWidth/2 > imageWidth+imageLeft)?(imageWidth-zFocusWidth-2):xPos;
			yPos=(y-zFocusHeight/2 < imageTop)? 0: (y+zFocusHeight/2 > imageHeight+imageTop)?(imageHeight-zFocusHeight-2):yPos;
			zoomFocus.css({top:yPos,left:xPos});
			zoomDiv[0].scrollTop=yPos*scaleY;
			zoomDiv[0].scrollLeft=xPos*scaleX;
			});
		},
	_removeZoom:function(){
		$('body').unbind('mousemove');
		if(this.zoomDiv){
			this.zoomDiv.fadeOut(400,function(){$(this).remove();})
			this.zoomFocus.remove();
			}
		this.zoomImg.attr('alt',this.alt);
		}
	};