using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Drawing;
using System.Text;


namespace SpeakIsDeom
{
    public class GoogleCode
    {
        /// <summary>
        /// ȫ
        /// </summary>
        private Random rndNumber;
        public static string mrChineseChars = String.Empty;
        /// <summary>
        /// Ӣִ
        /// </summary>
        // protected static readonly string mrEnglishOrNumChars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        protected static readonly string mrEnglishOrNumChars = "0123456789";

        public GoogleCode()
        {
            rndNumber = new Random(unchecked((int)DateTime.Now.Ticks));
        }
        // ֤볤(Ĭ6֤ĳ)
        int length = 5;
        public int Length
        {
            get { return length; }
            set { length = value; }
        }
        //֤С
        // int fontSize = 18;
        int fontSize = 18;
        public int FontSize
        {
            get { return fontSize; }
            set { fontSize = value; }
        }
        // ߿(Ĭ4)
        //int padding = 4;
        int padding = 4;
        public int Padding
        {
            get { return padding; }
            set { padding = value; }
        }
        // Ƿ(Ĭ)
        bool chaos = true;
        public bool Chaos
        {
            get { return chaos; }
            set { chaos = value; }
        }
        // ɫ(Ĭϻɫ)
        Color chaosColor = Color.LightGray;
        public Color ChaosColor
        {
            get { return chaosColor; }
            set { chaosColor = value; }
        }
        // Զ屳ɫ(Ĭϰɫ)
        Color backgroundColor = Color.White;
        public Color BackgroundColor
        {
            get { return backgroundColor; }
            set { backgroundColor = value; }
        }
        // Զɫ
        Color[] colors = { Color.Black, Color.Red, Color.DarkBlue, Color.Green, Color.Orange, Color.Brown, Color.DarkCyan, Color.Purple };
        public Color[] Colors
        {
            get { return colors; }
            set { colors = value; }
        }
        // Զ
        string[] fonts = { "Arial", "Georgia" };
        public string[] Fonts
        {
            get { return fonts; }
            set { fonts = value; }
        }
        #region ŤͼƬ
        private const double PI = 3.1415926535897932384626433832795;
        private const double PI2 = 6.283185307179586476925286766559;
        //private const double PI =0;
        //private const double PI2 =0;
        /// <summary>
        /// ÷ŤͼƬ
        /// </summary>
        /// <param name="srcBmp">ͼƬ·</param>
        /// <param name="bXDir">ŤѡΪTrue</param>
        /// <param name="nMultValue">εķȱԽŤĳ̶ԽߣһΪ3</param>
        /// <param name="dPhase">εʼλȡֵ[0-2*PI)</param>
        /// <returns></returns>
        public System.Drawing.Bitmap TwistImage(Bitmap srcBmp, bool bXDir, double dMultValue, double dPhase)
        {
            System.Drawing.Bitmap destBmp = new Bitmap(srcBmp.Width, srcBmp.Height);//Bitmap
            // λͼΪɫ
            System.Drawing.Graphics g = System.Drawing.Graphics.FromImage(destBmp);//Graphics
            g.FillRectangle(new SolidBrush(System.Drawing.Color.White), 0, 0, destBmp.Width, destBmp.Height);//λͼΪɫ
            g.Dispose();//ͷraphics
            double dBaseAxisLen = bXDir ? (double)destBmp.Height : (double)destBmp.Width;//жŤʽ
            for (int i = 0; i < destBmp.Width; i++)
            {
                for (int j = 0; j < destBmp.Height; j++)
                {
                    double dx = 0;
                    dx = bXDir ? (PI2 * (double)j) / dBaseAxisLen : (PI2 * (double)i) / dBaseAxisLen;
                    dx += dPhase;
                    double dy = Math.Sin(dx);
                    // ȡõǰɫ
                    int nOldX = 0, nOldY = 0;
                    nOldX = bXDir ? i + (int)(dy * dMultValue) : i;
                    nOldY = bXDir ? j : j + (int)(dy * dMultValue);
                    System.Drawing.Color color = srcBmp.GetPixel(i, j);
                    if (nOldX >= 0 && nOldX < destBmp.Width
                     && nOldY >= 0 && nOldY < destBmp.Height)
                    {
                        destBmp.SetPixel(nOldX, nOldY, color);
                    }
                }
            }
            return destBmp;
        }
        #endregion
        /// <summary>
        /// УͼƬ
        /// </summary>
        /// <param name="code">֤</param>
        /// <returns></returns>
        public Bitmap CreateImage(string code)
        {
            int fSize = FontSize;
            int fWidth = fSize + Padding;
            int imageWidth = (int)(code.Length * fWidth) + 4 + Padding * 2;
            int imageHeight = fSize * 2 + Padding * 2;
            System.Drawing.Bitmap image = new System.Drawing.Bitmap(imageWidth, imageHeight);
            Graphics g = Graphics.FromImage(image);
            g.Clear(BackgroundColor);
            //ɵ
            if (this.Chaos)
            {
                Pen pen = new Pen(ChaosColor, 0);
                int c = Length * 10;
                for (int i = 0; i < c; i++)
                {
                    int x = rndNumber.Next(image.Width);
                    int y = rndNumber.Next(image.Height);

                    g.DrawRectangle(pen, x, y, 1, 1);
                }
            }
            int left = 0, top = 0, top1 = 1, top2 = 1;
            int n1 = (imageHeight - FontSize - Padding * 2);
            int n2 = n1 / 4;
            top1 = n2;
            top2 = n2 * 2;
            Font f;
            Brush b;
            int cindex, findex;
            //ɫַ֤
            for (int i = 0; i < code.Length; i++)
            {
                cindex = rndNumber.Next(Colors.Length - 1);
                findex = rndNumber.Next(Fonts.Length - 1);
                f = new System.Drawing.Font(Fonts[findex], fSize, System.Drawing.FontStyle.Bold);
                b = new System.Drawing.SolidBrush(Colors[cindex]);
                if (i % 2 == 1)
                {
                    top = top2;
                }
                else
                {
                    top = top1;
                }
                left = i * fWidth;
                g.DrawString(code.Substring(i, 1), f, b, left, top);
            }
            //һ߿ ߿ɫΪColor.Gainsboro
            g.DrawRectangle(new Pen(Color.Gainsboro, 0), 0, 0, image.Width - 1, image.Height - 1);
            g.Dispose();
            //ΣAdd By 51aspx.com
            //image = TwistImage(image, true, 8, 4);
            image = TwistImage(image, false, 0, 0);
            return image;
        }
        /// <summary>
        /// ַ
        /// </summary>
        /// <param name="codeLen">ַ</param>
        /// <param name="zhCharsCount">ַ</param>
        /// <returns></returns>
        public string CreateVerifyCode(int codeLen, int zhCharsCount)
        {
            char[] chs = new char[codeLen];

            int index;
            for (int i = 0; i < zhCharsCount; i++)
            {
                index = rndNumber.Next(0, codeLen);
                if (chs[index] == '\0')
                    chs[index] = CreateZhChar();
                else
                    --i;
            }
            for (int i = 0; i < codeLen; i++)
            {
                if (chs[i] == '\0')
                    chs[i] = CreateEnOrNumChar();
            }

            return new string(chs, 0, chs.Length);
        }
        // Ĭϳ5ַ
        public string CreateVerifyCode()
        {
            return CreateVerifyCode(Length, 0);
        }
        // ӢĻַ
        protected char CreateEnOrNumChar()
        {
            return mrEnglishOrNumChars[rndNumber.Next(0, mrEnglishOrNumChars.Length)];
        }
        protected char CreateZhChar() // ɺַ
        {
            //ṩ˺ּѯּѡȡ
            if (mrChineseChars.Length > 0)
            {
                return mrChineseChars[rndNumber.Next(0, mrChineseChars.Length)];
            }
            //ûṩּݡGB2312ı캺
            else
            {
                byte[] bytes = new byte[2];

                //һֵֽ0xb0, 0xf7֮
                bytes[0] = (byte)rndNumber.Next(0xb0, 0xf8);
                //ڶֵֽ0xa1, 0xfe֮
                bytes[1] = (byte)rndNumber.Next(0xa1, 0xff);

                //ݺֱֽĺ
                string str1 = Encoding.GetEncoding("gb2312").GetString(bytes);

                return str1[0];
            }
        }


    }
}
