using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using XPTable;
using XPTable.Models;

namespace XPTableDemo.Styles
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class StylesDemoForm : System.Windows.Forms.Form
	{
		private Table table;
		private ColumnModel columnModel;
		private TableModel tableModel;
		private RowStyle rowStyle;
		private CellStyle cellStyle;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private PropertyGrid rowStylePropertyGrid;
		private PropertyGrid cellStylePropertyGrid;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// 
		/// </summary>
		public StylesDemoForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(StylesDemoForm));
			this.table = new XPTable.Models.Table();
			this.columnModel = new XPTable.Models.ColumnModel();
			this.tableModel = new XPTable.Models.TableModel();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.rowStylePropertyGrid = new System.Windows.Forms.PropertyGrid();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.cellStylePropertyGrid = new System.Windows.Forms.PropertyGrid();
			((System.ComponentModel.ISupportInitialize)(this.table)).BeginInit();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// table
			// 
			this.table.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("table.BackgroundImage")));
			this.table.ColumnModel = this.columnModel;
			this.table.EnableHeaderContextMenu = false;
			this.table.HeaderFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.table.Location = new System.Drawing.Point(16, 16);
			this.table.Name = "table";
			this.table.Size = new System.Drawing.Size(568, 254);
			this.table.TabIndex = 0;
			this.table.TableModel = this.tableModel;
			this.table.Text = "table1";
			// 
			// tableModel
			// 
			this.tableModel.RowHeight = 23;
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.rowStylePropertyGrid);
			this.groupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox1.Location = new System.Drawing.Point(16, 280);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(280, 192);
			this.groupBox1.TabIndex = 2;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Row Style Properties";
			// 
			// rowStylePropertyGrid
			// 
			this.rowStylePropertyGrid.CommandsVisibleIfAvailable = true;
			this.rowStylePropertyGrid.LargeButtons = false;
			this.rowStylePropertyGrid.LineColor = System.Drawing.SystemColors.ScrollBar;
			this.rowStylePropertyGrid.Location = new System.Drawing.Point(16, 24);
			this.rowStylePropertyGrid.Name = "rowStylePropertyGrid";
			this.rowStylePropertyGrid.Size = new System.Drawing.Size(248, 152);
			this.rowStylePropertyGrid.TabIndex = 0;
			this.rowStylePropertyGrid.Text = "PropertyGrid";
			this.rowStylePropertyGrid.ToolbarVisible = false;
			this.rowStylePropertyGrid.ViewBackColor = System.Drawing.SystemColors.Window;
			this.rowStylePropertyGrid.ViewForeColor = System.Drawing.SystemColors.WindowText;
			this.rowStylePropertyGrid.PropertyValueChanged += new System.Windows.Forms.PropertyValueChangedEventHandler(this.propertyGrid_PropertyValueChanged);
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.cellStylePropertyGrid);
			this.groupBox2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox2.Location = new System.Drawing.Point(304, 280);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(280, 192);
			this.groupBox2.TabIndex = 3;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Cell Style Properties";
			// 
			// cellStylePropertyGrid
			// 
			this.cellStylePropertyGrid.CommandsVisibleIfAvailable = true;
			this.cellStylePropertyGrid.Cursor = System.Windows.Forms.Cursors.HSplit;
			this.cellStylePropertyGrid.LargeButtons = false;
			this.cellStylePropertyGrid.LineColor = System.Drawing.SystemColors.ScrollBar;
			this.cellStylePropertyGrid.Location = new System.Drawing.Point(16, 24);
			this.cellStylePropertyGrid.Name = "cellStylePropertyGrid";
			this.cellStylePropertyGrid.Size = new System.Drawing.Size(248, 152);
			this.cellStylePropertyGrid.TabIndex = 0;
			this.cellStylePropertyGrid.Text = "PropertyGrid";
			this.cellStylePropertyGrid.ToolbarVisible = false;
			this.cellStylePropertyGrid.ViewBackColor = System.Drawing.SystemColors.Window;
			this.cellStylePropertyGrid.ViewForeColor = System.Drawing.SystemColors.WindowText;
			this.cellStylePropertyGrid.PropertyValueChanged += new System.Windows.Forms.PropertyValueChangedEventHandler(this.propertyGrid_PropertyValueChanged);
			// 
			// StylesDemoForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
			this.ClientSize = new System.Drawing.Size(600, 486);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.table);
			this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "StylesDemoForm";
			this.Text = "XPTable - Styles Demo";
			((System.ComponentModel.ISupportInitialize)(this.table)).EndInit();
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new StylesDemoForm());
		}


		/// <summary>
		/// 
		/// </summary>
		/// <param name="e"></param>
		protected override void OnLoad(EventArgs e)
		{
			base.OnLoad(e);

			this.table.BeginUpdate();

			TextColumn column1 = new TextColumn();
			column1.Editable = false;
			column1.Text = "Column 1";
			column1.Width = 100;

			TextColumn column2 = new TextColumn();
			column2.Editable = false;
			column2.Text = "Column 2";
			column2.Width = 100;

			TextColumn column3 = new TextColumn();
			column3.Editable = false;
			column3.Text = "Column 3";
			column3.Width = 100;

			CheckBoxColumn column4 = new CheckBoxColumn();
			column4.Text = "Column 4";
			column4.Width = 100;

			ButtonColumn column5 = new ButtonColumn();
			column5.Text = "Column 5";
			column5.Width = 100;

			this.columnModel.Columns.AddRange(new Column[] {column1, column2, column3, column4, column5});

			this.table.TableModel.Rows.AddRange(new Row[] {	new Row(new Cell[] {new Cell("Item 1"),
																				new Cell("Item 2"),
																				   new Cell("Item 3"),
																				   new Cell("Item 4", true),
																				   new Cell("Item 5")}),
															new Row(new Cell[] {new Cell("Item 6"),
																				new Cell("Item 7"),
																				   new Cell("Item 8"),
																				   new Cell("Item 9"),
																				   new Cell("Item 10")}),
															new Row(new Cell[] {new Cell("Item 11"),
																				new Cell("Item 12"),
																				   new Cell("Item 13"),
																				   new Cell("Item 14"),
																				   new Cell("Item 15")}),
															new Row(new Cell[] {new Cell("Item 16"),
																				new Cell("Item 17"),
																				   new Cell("Item 18"),
																				   new Cell("Item 19", true),
																				   new Cell("Item 20")}),
															new Row(new Cell[] {new Cell("Item 21"),
																				new Cell("Item 22"),
																				   new Cell("Item 23"),
																				   new Cell("Item 24", true),
																				   new Cell("Item 25")}),
															  new Row(new Cell[] {new Cell("Item 26"),
																					 new Cell("Item 27"),
																					 new Cell("Item 28"),
																					 new Cell("Item 29"),
																					 new Cell("Item 30")})});

			this.rowStyle = new RowStyle();
			this.rowStyle.BackColor = Color.FromArgb(192, Color.LightBlue);
			this.rowStyle.ForeColor = Color.Red;
			this.rowStyle.Font = new Font("Times New Roman", 9.25f, FontStyle.Italic);

			this.table.TableModel.Rows[1].RowStyle = this.rowStyle;
			this.table.TableModel.Rows[2].RowStyle = this.rowStyle;
			this.table.TableModel.Rows[3].RowStyle = this.rowStyle;

			this.cellStyle = new CellStyle();
			this.cellStyle.BackColor = Color.FromArgb(192, Color.Wheat);
			this.cellStyle.ForeColor = Color.Blue;
			this.cellStyle.Font = new Font("Courier New", 9.25f, FontStyle.Regular);

			this.table.TableModel[0, 0].CellStyle = this.cellStyle;
			this.table.TableModel[0, 2].CellStyle = this.cellStyle;
			this.table.TableModel[1, 4].CellStyle = this.cellStyle;
			this.table.TableModel[2, 1].CellStyle = this.cellStyle;
			this.table.TableModel[2, 3].CellStyle = this.cellStyle;
			this.table.TableModel[3, 4].CellStyle = this.cellStyle;
			this.table.TableModel[5, 0].CellStyle = this.cellStyle;
			this.table.TableModel[5, 2].CellStyle = this.cellStyle;

			this.table.FullRowSelect = true;
			this.table.SelectionBackColor = Color.FromArgb(160, this.table.SelectionBackColor);
			this.table.SortedColumnBackColor = Color.FromArgb(160, this.table.SortedColumnBackColor);

			this.table.EndUpdate();

			this.rowStylePropertyGrid.SelectedObject = this.rowStyle;
			this.cellStylePropertyGrid.SelectedObject = this.cellStyle;
		}

		private void propertyGrid_PropertyValueChanged(object s, System.Windows.Forms.PropertyValueChangedEventArgs e)
		{
			this.table.Invalidate(this.table.CellDataRect);
		}
	}
}
