﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TeachBookManagerModel;
using TeachBookManagerDAL;
using System.Data;

namespace TeachBookManagerBLL
{
   public  class BookStoreBLL
    {
       BookStoreDAL bookstoredal = new BookStoreDAL();

       /// <summary>
        /// 添加入库单
        /// </summary>
        /// <param name="bookout"></param>
        /// <returns></returns>
       public int AddBookStore(BookStore bookstore)
       {
          return  bookstoredal.AddBookStore(bookstore);
       }

       /// <summary>
        /// 更改入库单
        /// </summary>
        /// <param name="bookstore"></param>
        /// <returns></returns>
       public int UpdateBookStore(BookStore bookstore)
       {
           return bookstoredal.UpdateBookStore(bookstore);
       }

       /// <summary>
        /// 删除入库单
        /// </summary>
        /// <param name="id"></param>
       public void DeleteBookStore(int id)
       {
           bookstoredal.DeleteBookStore(id);
       }

       /// <summary>
        /// 获取入库表
        /// </summary>
        /// <param name="pagesize"></param>
        /// <param name="pageindex"></param>
        /// <returns></returns>
       public List<BookStore> GetBookStoreList(int pagesize, int pageindex,string keyword)
       {
           return bookstoredal.GetBookStoreList(pagesize, pageindex,keyword);
       }

       /// <summary>
        /// 获取入库单总数
        /// </summary>
        /// <returns></returns>
       public int GetBookStoreCount()
       {
           return bookstoredal.GetBookStoreCount();
       }

       /// <summary>
        /// 获取入库单信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
       public BookStore GetBookStoreInfo(int id)
       {
           return bookstoredal.GetBookStoreInfo(id);
       }

    }
}
