﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TeachBookManagerModel;
using System.Data;


namespace TeachBookManagerDAL
{
    public class BookOutDAL
    {

        /// <summary>
        /// 添加出库单
        /// </summary>
        /// <param name="bookout"></param>
        /// <returns></returns>
        public int AddBookOut(BookOut bookout)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                ef.BookOut.AddObject(bookout);
                return ef.SaveChanges();
            }
        }

        /// <summary>
        /// 更改出库单
        /// </summary>
        /// <param name="bookout"></param>
        /// <returns></returns>
        public int UpdateBookOut(BookOut bookout)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                ef.BookOut.Attach(bookout);
                ef.ObjectStateManager.ChangeObjectState(bookout, EntityState.Modified);

                return ef.SaveChanges();
            }
        }

        /// <summary>
        /// 删除出库单
        /// </summary>
        /// <param name="id"></param>
        public void DeleteBookOut(int id)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                BookOut bookout = ef.BookOut.Where(item => item.id == id).FirstOrDefault();

                ef.DeleteObject(bookout);

                ef.SaveChanges();
            }
        }

        /// <summary>
        /// 删除出库单通过bookid 
        /// </summary>
        /// <param name="id"></param>
        public void DeleteBookOutBy(int bookid)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                BookOut bookout = ef.BookOut.Where(item => item.bookid == bookid).FirstOrDefault();

                ef.DeleteObject(bookout);

                ef.SaveChanges();
            }
        }

        /// <summary>
        /// 获取出库表
        /// </summary>
        /// <param name="pagesize"></param>
        /// <param name="pageindex"></param>
        /// <returns></returns>
        public List<BookOutList> GetBookOutList(int pagesize, int pageindex, string keyword, int bookid)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                if (bookid > 0)
                {
                    return ef.BookOutList.Where(item => item.bookname.Contains(keyword)&&item.bookid==bookid).OrderByDescending(item => item.id).Skip((pageindex - 1) * pagesize).Take(pagesize).ToList();
                }
                else
                {
                    return ef.BookOutList.Where(item=>item.bookname.Contains(keyword)).OrderByDescending(item => item.id).Skip((pageindex - 1) * pagesize).Take(pagesize).ToList();
                }
            }
        }

        /// <summary>
        /// 获取出库单总数
        /// </summary>
        /// <returns></returns>
        public int GetBookOutCount(string keyword,int bookid)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                if (bookid > 0)
                {
                    return ef.BookOutList.Where(item=>item.bookname.Contains(keyword)&&item.bookid==bookid).Count();
                }
                else
                {
                    return ef.BookOutList.Where(item=>item.bookname.Contains(keyword)).Count();
                }
            }
        }

        /// <summary>
        /// 获取出库单信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public BookOut GetBookOutInfo(int id)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                return ef.BookOut.Where(item => item.id == id).FirstOrDefault();
            }
        }

    }
}
