﻿namespace PageTool
{
    using System;
    using System.Collections.Generic;
    using System.Web.UI.HtmlControls;

    internal static class ButtonService
    {
        public static List<HtmlAnchor> GetButtonListByParamSize(int paramSize, string keyword, string url)
        {
            List<HtmlAnchor> list = new List<HtmlAnchor>(paramSize);
            for (int i = 1; i <= paramSize; i++)
            {
                HtmlAnchor anchor2 = new HtmlAnchor {
                    ID = "hl:" + i,
                    HRef = url + "?keyword=" + keyword + "&page=" + i.ToString() + "&number=" + i.ToString(),
                    InnerHtml = "[" + i.ToString() + "]"
                };
                HtmlAnchor item = anchor2;
                list.Add(item);
            }
            return list;
        }

        public static List<HtmlAnchor> GetButtonListToPageList(List<int> page, string keyword, string url)
        {
            List<HtmlAnchor> list = new List<HtmlAnchor>();
            List<int> list2 = page;
            for (int i = 0; i < page.Count; i++)
            {
                HtmlAnchor anchor2 = new HtmlAnchor {
                    ID = "hl:" + list2[i]
                };
                HtmlAnchor item = anchor2;
                item.InnerHtml = "[" + list2[i].ToString() + "]";
                item.HRef = string.Concat(new object[] { url, "?keyword=", keyword, "&page=", list2[i], "&number=", i + 1 });
                list.Add(item);
            }
            return list;
        }
    }
}

