﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.IO;
using AspNet = System.Web.UI.WebControls;

namespace ExtAspNet.Examples.grid
{
    public partial class grid_edit_checkboxlist : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindGrid();
            }
        }

        #region BindGrid

        private void BindGrid()
        {
            DataTable table = GetDataTable();

            Grid1.DataSource = table;
            Grid1.DataBind();

        }



        #endregion

        #region Events

        protected void Grid1_RowDataBound(object sender, ExtAspNet.GridRowEventArgs e)
        {
            AspNet.CheckBoxList cblHobby = (AspNet.CheckBoxList)Grid1.Rows[e.RowIndex].FindControl("cblHobby");

            DataRowView row = e.DataItem as DataRowView;

            string hobby = row["Hobby"].ToString() + ",";
            foreach (AspNet.ListItem item in cblHobby.Items)
            {
                if (hobby.Contains(item.Value + ","))
                {
                    item.Selected = true;
                }
                else
                {
                    item.Selected = false;
                }
            }
        }


        protected void Button1_Click(object sender, EventArgs e)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("<table style=\"width:350px;\"><tr><th>No.</th><th>Name</th><th>User input hobbies</th></tr>");
            for (int i = 0, count = Grid1.Rows.Count; i < count; i++)
            {
                sb.Append("<tr>");
                object[] rowDataKeys = Grid1.DataKeys[i];
                sb.AppendFormat("<td>{0}</td>", rowDataKeys[0]);
                sb.AppendFormat("<td>{0}</td>", rowDataKeys[1]);

                GridRow row = Grid1.Rows[i];
                AspNet.CheckBoxList cblHobby = (AspNet.CheckBoxList)row.FindControl("cblHobby");
                sb.AppendFormat("<td>{0}</td>", GetHobbies(cblHobby));

                sb.Append("<tr>");
            }

            sb.Append("</table>");

            labResult.Text = sb.ToString();

        }

        private string GetHobbies(AspNet.CheckBoxList cblHobby)
        {
            StringBuilder sb = new StringBuilder();
            foreach (AspNet.ListItem item in cblHobby.Items)
            {
                if (item.Selected)
                {
                    switch (item.Value)
                    {
                        case "reading":
                            sb.Append("Reading,");
                            break;
                        case "basketball":
                            sb.Append("Basketball,");
                            break;
                        case "travel":
                            sb.Append("Travel,");
                            break;
                        case "movie":
                            sb.Append("Movie,");
                            break;
                        case "music":
                            sb.Append("Music,");
                            break;
                    }
                }
            }
            return sb.ToString().TrimEnd(',');
        }

        #endregion

    }
}
