﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;

namespace _7he7.DataBaseAccess.BLL.Extend
{
	public class Class_7he7_com
	{
		_7he7.DataBaseAccess.DAL.Class_7he7_com dal = new _7he7.DataBaseAccess.DAL.Class_7he7_com();

        /// <summary>
        /// 填充所有分类
        /// </summary>
        public static void fillDtAllClass()
        {
            _7he7.DataBaseAccess.DAL.Class_7he7_com dal = new _7he7.DataBaseAccess.DAL.Class_7he7_com();
            _7he7.Config.Variable.dtAllClass = dal.LoadAll();
        }

		/// <summary>
		/// 获得分类的级别
		/// </summary>
		/// <param name="classID">节点ID</param>
		/// <param name="dt"></param>
		/// <returns></returns>
		public int classNum(string parentID, DataTable dt, int indexNum)
		{
			DataView dv = dt.DefaultView;
			dv.RowFilter = "classID=" + parentID;
			if (dv.Count > 0)
			{
				indexNum++;
				indexNum = classNum(dv[0]["parentID"].ToString(), dt, indexNum);
			}
			return indexNum;
		}

		/// <summary>
		/// 获得跟节点某字段字符串直
		/// </summary>
		/// <param name="parentID">节点ID</param>
		/// <param name="fieldName">要取直的字段名</param>
		public string RootInfo(int parentID, string fieldName)
		{
			return rootModelRecursive(parentID,dal.LoadAll(), fieldName);
		}

		/// <summary>
		/// 获得跟节点某字段字符串直
		/// </summary>
		/// <param name="classID">当前分类ID</param>
		/// <param name="dt">源分类表</param>
		/// <param name="fieldName">要取的字段</param>
		/// <returns></returns>
		public string rootModelRecursive(int classID, DataTable dt, string fieldName)
		{
			string value = "0";

			DataView dv = dt.DefaultView;
			dv.RowFilter = "[classID]=" + classID;
			if (dv.Count > 0)
			{
				value = dv[0][fieldName].ToString();
				rootModelRecursive(int.Parse(dv[0]["parentID"].ToString()), dt, fieldName);
			}

			return value;
		}


        string arrClassID = string.Empty;
        /// <summary>
        /// 获取所有子目录ID和自己连接
        /// </summary>
        /// <returns></returns>
        public string getMeSubClassID(string classID, DataTable dtAllClass)
        {
            arrClassID = string.Empty;
            subAllClassID(classID,dtAllClass);
            return classID + arrClassID;
        }

		/// <summary>
		/// 获取所有子目录ID
		/// </summary>
		/// <param name="classID">节点</param>
		/// <param name="dt">数据源表</param>
		/// <returns></returns>
		public string getSubAllClassID(string classID, DataTable dt)
		{
            subAllClassID(classID, dt);
            return arrClassID;
		}

		/// <summary>
		/// 获取所有子目录ID
		/// </summary>
		/// <param name="parentID"></param>
		/// <param name="arrClassID"></param>
		/// <returns></returns>
		private void subAllClassID(string classID, DataTable dt)
		{
			DataView dv = dt.DefaultView;
			dv.RowFilter = "parentID=" + classID;
			foreach (DataRowView Row in dv)
			{
				arrClassID += "," + Row["classId"];
				subAllClassID(Row["classId"].ToString(), dt);
			}
		}
	}
}
