/* 
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Generated By:JavaCC: Do not edit this line. HTMLParserTokenManager.java */

using System;

namespace Lucene.Net.Demo.Html
{
	
	public class HTMLParserTokenManager : HTMLParserConstants
	{
		private void  InitBlock()
		{
			System.IO.StreamWriter temp_writer;
			temp_writer = new System.IO.StreamWriter(System.Console.OpenStandardOutput(), System.Console.Out.Encoding);
			temp_writer.AutoFlush = true;
			debugStream = temp_writer;
		}
		public System.IO.StreamWriter debugStream;
		public virtual void  SetDebugStream(System.IO.StreamWriter ds)
		{
			debugStream = ds;
		}
		private int JjStopStringLiteralDfa_0(int pos, long active0)
		{
			switch (pos)
			{
				
				case 0: 
					if ((active0 & 0x32L) != 0L)
						return 20;
					return - 1;
				
				case 1: 
					if ((active0 & 0x2L) != 0L)
					{
						if (jjmatchedPos != 1)
						{
							jjmatchedKind = 2;
							jjmatchedPos = 1;
						}
						return 22;
					}
					if ((active0 & 0x30L) != 0L)
						return 25;
					return - 1;
				
				case 2: 
					if ((active0 & 0x2L) != 0L)
					{
						jjmatchedKind = 2;
						jjmatchedPos = 2;
						return 23;
					}
					return - 1;
				
				case 3: 
					if ((active0 & 0x2L) != 0L)
					{
						jjmatchedKind = 2;
						jjmatchedPos = 3;
						return 23;
					}
					return - 1;
				
				case 4: 
					if ((active0 & 0x2L) != 0L)
					{
						jjmatchedKind = 2;
						jjmatchedPos = 4;
						return 23;
					}
					return - 1;
				
				case 5: 
					if ((active0 & 0x2L) != 0L)
					{
						jjmatchedKind = 2;
						jjmatchedPos = 5;
						return 23;
					}
					return - 1;
				
				default: 
					return - 1;
				
			}
		}
		private int JjStartNfa_0(int pos, long active0)
		{
			return JjMoveNfa_0(JjStopStringLiteralDfa_0(pos, active0), pos + 1);
		}
		private int JjStopAtPos(int pos, int kind)
		{
			jjmatchedKind = kind;
			jjmatchedPos = pos;
			return pos + 1;
		}
		private int JjStartNfaWithStates_0(int pos, int kind, int state)
		{
			jjmatchedKind = kind;
			jjmatchedPos = pos;
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				return pos + 1;
			}
			return JjMoveNfa_0(state, pos + 1);
		}
		private int JjMoveStringLiteralDfa0_0()
		{
			switch (curChar)
			{
				
				case (char) (60): 
					return JjMoveStringLiteralDfa1_0(0x32L);
				
				default: 
					return JjMoveNfa_0(11, 0);
				
			}
		}
		private int JjMoveStringLiteralDfa1_0(long active0)
		{
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				JjStopStringLiteralDfa_0(0, active0);
				return 1;
			}
			switch (curChar)
			{
				
				case (char) (33): 
					if ((active0 & 0x20L) != 0L)
					{
						jjmatchedKind = 5;
						jjmatchedPos = 1;
					}
					return JjMoveStringLiteralDfa2_0(active0, 0x10L);
				
				case (char) (115): 
					return JjMoveStringLiteralDfa2_0(active0, 0x2L);
				
				default: 
					break;
				
			}
			return JjStartNfa_0(0, active0);
		}
		private int JjMoveStringLiteralDfa2_0(long old0, long active0)
		{
			if (((active0 &= old0)) == 0L)
				return JjStartNfa_0(0, old0);
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				JjStopStringLiteralDfa_0(1, active0);
				return 2;
			}
			switch (curChar)
			{
				
				case (char) (45): 
					return JjMoveStringLiteralDfa3_0(active0, 0x10L);
				
				case (char) (99): 
					return JjMoveStringLiteralDfa3_0(active0, 0x2L);
				
				default: 
					break;
				
			}
			return JjStartNfa_0(1, active0);
		}
		private int JjMoveStringLiteralDfa3_0(long old0, long active0)
		{
			if (((active0 &= old0)) == 0L)
				return JjStartNfa_0(1, old0);
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				JjStopStringLiteralDfa_0(2, active0);
				return 3;
			}
			switch (curChar)
			{
				
				case (char) (45): 
					if ((active0 & 0x10L) != 0L)
						return JjStopAtPos(3, 4);
					break;
				
				case (char) (114): 
					return JjMoveStringLiteralDfa4_0(active0, 0x2L);
				
				default: 
					break;
				
			}
			return JjStartNfa_0(2, active0);
		}
		private int JjMoveStringLiteralDfa4_0(long old0, long active0)
		{
			if (((active0 &= old0)) == 0L)
				return JjStartNfa_0(2, old0);
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				JjStopStringLiteralDfa_0(3, active0);
				return 4;
			}
			switch (curChar)
			{
				
				case (char) (105): 
					return JjMoveStringLiteralDfa5_0(active0, 0x2L);
				
				default: 
					break;
				
			}
			return JjStartNfa_0(3, active0);
		}
		private int JjMoveStringLiteralDfa5_0(long old0, long active0)
		{
			if (((active0 &= old0)) == 0L)
				return JjStartNfa_0(3, old0);
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				JjStopStringLiteralDfa_0(4, active0);
				return 5;
			}
			switch (curChar)
			{
				
				case (char) (112): 
					return JjMoveStringLiteralDfa6_0(active0, 0x2L);
				
				default: 
					break;
				
			}
			return JjStartNfa_0(4, active0);
		}
		private int JjMoveStringLiteralDfa6_0(long old0, long active0)
		{
			if (((active0 &= old0)) == 0L)
				return JjStartNfa_0(4, old0);
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				JjStopStringLiteralDfa_0(5, active0);
				return 6;
			}
			switch (curChar)
			{
				
				case (char) (116): 
					if ((active0 & 0x2L) != 0L)
						return JjStartNfaWithStates_0(6, 1, 23);
					break;
				
				default: 
					break;
				
			}
			return JjStartNfa_0(5, active0);
		}
		private void  JjCheckNAdd(int state)
		{
			if (jjrounds[state] != jjround)
			{
				jjstateSet[jjnewStateCnt++] = state;
				jjrounds[state] = jjround;
			}
		}
		private void  JjAddStates(int start, int end)
		{
			do 
			{
				jjstateSet[jjnewStateCnt++] = jjnextStates[start];
			}
			while (start++ != end);
		}
		private void  JjCheckNAddTwoStates(int state1, int state2)
		{
			JjCheckNAdd(state1);
			JjCheckNAdd(state2);
		}
		private void  JjCheckNAddStates(int start, int end)
		{
			do 
			{
				JjCheckNAdd(jjnextStates[start]);
			}
			while (start++ != end);
		}
		private void  JjCheckNAddStates(int start)
		{
			JjCheckNAdd(jjnextStates[start]);
			JjCheckNAdd(jjnextStates[start + 1]);
		}
		internal static readonly ulong[] jjbitVec0 = new ulong[]{0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL};
		private int JjMoveNfa_0(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 28;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
					ulong l = ((ulong) 1L) << curChar;

MatchLoop: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 20: 
								if (curChar == 33)
									jjstateSet[jjnewStateCnt++] = 25;
								else if (curChar == 47)
									JjCheckNAdd(21);
								break;
							
							case 11: 
								if ((0x3ff000000000000L & l) != 0L)
									JjCheckNAddTwoStates(7, 2);
								else if ((0x100002600L & l) != 0L)
								{
									if (kind > 11)
										kind = 11;
									JjCheckNAdd(10);
								}
								else if (curChar == 60)
									JjCheckNAddStates(0, 2);
								else if (curChar == 38)
									JjAddStates(3, 5);
								else if (curChar == 36)
									jjstateSet[jjnewStateCnt++] = 1;
								if ((0x3ff000000000000L & l) != 0L)
								{
									if (kind > 6)
										kind = 6;
									JjCheckNAddStates(6, 10);
								}
								break;
							
							case 0: 
								if (curChar == 36)
									jjstateSet[jjnewStateCnt++] = 1;
								break;
							
							case 1: 
								if ((0x3ff000000000000L & l) != 0L)
									JjCheckNAdd(2);
								break;
							
							case 2: 
								if ((0x500000000000L & l) != 0L)
									jjstateSet[jjnewStateCnt++] = 3;
								break;
							
							case 3: 
							case 9: 
								if ((0x3ff000000000000L & l) == 0L)
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddStates(11, 13);
								break;
							
							case 4: 
								if ((0x3ff000000000000L & l) == 0L)
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddStates(6, 10);
								break;
							
							case 5: 
								if ((0x880000000000L & l) == 0L)
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddStates(14, 17);
								break;
							
							case 6: 
								if ((0x3ff000000000000L & l) != 0L)
									JjCheckNAddTwoStates(7, 2);
								break;
							
							case 7: 
								if (curChar != 34)
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddStates(11, 13);
								break;
							
							case 8: 
								if ((0x208000000000L & l) != 0L)
									jjstateSet[jjnewStateCnt++] = 9;
								break;
							
							case 10: 
								if ((0x100002600L & l) == 0L)
									break;
								kind = 11;
								JjCheckNAdd(10);
								break;
							
							case 13: 
								if (curChar == 59 && kind > 10)
									kind = 10;
								break;
							
							case 14: 
								if (curChar == 35)
									JjCheckNAdd(15);
								break;
							
							case 15: 
								if ((0x3ff000000000000L & l) == 0L)
									break;
								if (kind > 10)
									kind = 10;
								JjCheckNAddTwoStates(15, 13);
								break;
							
							case 16: 
								if (curChar == 35)
									jjstateSet[jjnewStateCnt++] = 17;
								break;
							
							case 18: 
								if ((0x3ff000000000000L & l) == 0L)
									break;
								if (kind > 10)
									kind = 10;
								JjCheckNAddTwoStates(18, 13);
								break;
							
							case 19: 
								if (curChar == 60)
									JjCheckNAddStates(0, 2);
								break;
							
							case 22: 
								if ((0x9fffff7affffd9ffL & l) == 0L)
									break;
								if (kind > 2)
									kind = 2;
								JjCheckNAdd(23);
								break;
							
							case 23: 
								if ((0x9ffffffeffffd9ffL & l) == 0L)
									break;
								if (kind > 2)
									kind = 2;
								JjCheckNAdd(23);
								break;
							
							case 24: 
								if (curChar == 33)
									jjstateSet[jjnewStateCnt++] = 25;
								break;
							
							case 26: 
								if ((0x9fffff7affffd9ffL & l) == 0L)
									break;
								if (kind > 3)
									kind = 3;
								JjCheckNAdd(27);
								break;
							
							case 27: 
								if ((0x9ffffffeffffd9ffL & l) == 0L)
									break;
								if (kind > 3)
									kind = 3;
								JjCheckNAdd(27);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 20: 
							case 21: 
								if ((0x7fffffe07fffffeL & l) == 0L)
									break;
								if (kind > 2)
									kind = 2;
								jjstateSet[jjnewStateCnt++] = 22;
								break;
							
							case 11: 
							case 4: 
								if ((0x7fffffe07fffffeL & l) == 0L)
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddStates(6, 10);
								break;
							
							case 9: 
								if ((0x7fffffe07fffffeL & l) == 0L)
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddStates(11, 13);
								break;
							
							case 12: 
								if ((0x7fffffe07fffffeL & l) == 0L)
									break;
								if (kind > 10)
									kind = 10;
								JjCheckNAddTwoStates(12, 13);
								break;
							
							case 17: 
								if ((0x100000001000000L & l) != 0L)
									JjCheckNAdd(18);
								break;
							
							case 18: 
								if ((0x7e0000007eL & l) == 0L)
									break;
								if (kind > 10)
									kind = 10;
								JjCheckNAddTwoStates(18, 13);
								break;
							
							case 22: 
							case 23: 
								if (kind > 2)
									kind = 2;
								JjCheckNAdd(23);
								break;
							
							case 25: 
								if ((0x7fffffe07fffffeL & l) == 0L)
									break;
								if (kind > 3)
									kind = 3;
								jjstateSet[jjnewStateCnt++] = 26;
								break;
							
							case 26: 
							case 27: 
								if (kind > 3)
									kind = 3;
								JjCheckNAdd(27);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 22: 
							case 23: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 2)
									kind = 2;
								JjCheckNAdd(23);
								break;
							
							case 26: 
							case 27: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 3)
									kind = 3;
								JjCheckNAdd(27);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 28 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException e)
				{
					return curPos;
				}
			}
		}
		private int JjMoveStringLiteralDfa0_5()
		{
			return JjMoveNfa_5(1, 0);
		}
		private int JjMoveNfa_5(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 2;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
					ulong l = ((ulong) 1L) << curChar;

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
								if ((0xfffffffbffffffffL & l) != 0L)
								{
									if (kind > 25)
										kind = 25;
									JjCheckNAdd(0);
								}
								else if (curChar == 34)
								{
									if (kind > 26)
										kind = 26;
								}
								break;
							
							case 0: 
								if ((0xfffffffbffffffffL & l) == 0L)
									break;
								kind = 25;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
							case 0: 
								kind = 25;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
							case 0: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 25)
									kind = 25;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 2 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException e)
				{
					return curPos;
				}
			}
		}
		private int JjStopStringLiteralDfa_7(int pos, long active0)
		{
			switch (pos)
			{
				
				default: 
					return - 1;
				
			}
		}
		private int JjStartNfa_7(int pos, long active0)
		{
			return JjMoveNfa_7(JjStopStringLiteralDfa_7(pos, active0), pos + 1);
		}
		private int JjStartNfaWithStates_7(int pos, int kind, int state)
		{
			jjmatchedKind = kind;
			jjmatchedPos = pos;
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				return pos + 1;
			}
			return JjMoveNfa_7(state, pos + 1);
		}
		private int JjMoveStringLiteralDfa0_7()
		{
			switch (curChar)
			{
				
				case (char) (62): 
					return JjStopAtPos(0, 30);
				
				default: 
					return JjMoveNfa_7(0, 0);
				
			}
		}
		private int JjMoveNfa_7(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 1;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
					ulong l = ((ulong) 1L) << curChar;

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
								if ((0xbfffffffffffffffL & l) == 0L)
									break;
								kind = 29;
								jjstateSet[jjnewStateCnt++] = 0;
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
								kind = 29;
								jjstateSet[jjnewStateCnt++] = 0;
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 29)
									kind = 29;
								jjstateSet[jjnewStateCnt++] = 0;
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 1 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException e)
				{
					return curPos;
				}
			}
		}
		private int JjMoveStringLiteralDfa0_4()
		{
			return JjMoveNfa_4(1, 0);
		}
		private int JjMoveNfa_4(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 2;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
					ulong l = ((ulong) 1L) << curChar;

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
								if ((0xffffff7fffffffffL & l) != 0L)
								{
									if (kind > 23)
										kind = 23;
									JjCheckNAdd(0);
								}
								else if (curChar == 39)
								{
									if (kind > 24)
										kind = 24;
								}
								break;
							
							case 0: 
								if ((0xffffff7fffffffffL & l) == 0L)
									break;
								kind = 23;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
							case 0: 
								kind = 23;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
							case 0: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 23)
									kind = 23;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 2 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException e)
				{
					return curPos;
				}
			}
		}
		private int JjStopStringLiteralDfa_3(int pos, long active0)
		{
			switch (pos)
			{
				
				default: 
					return - 1;
				
			}
		}
		private int JjStartNfa_3(int pos, long active0)
		{
			return JjMoveNfa_3(JjStopStringLiteralDfa_3(pos, active0), pos + 1);
		}
		private int JjStartNfaWithStates_3(int pos, int kind, int state)
		{
			jjmatchedKind = kind;
			jjmatchedPos = pos;
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				return pos + 1;
			}
			return JjMoveNfa_3(state, pos + 1);
		}
		private int JjMoveStringLiteralDfa0_3()
		{
			switch (curChar)
			{
				
				case (char) (34): 
					return JjStopAtPos(0, 21);
				
				case (char) (39): 
					return JjStopAtPos(0, 20);
				
				default: 
					return JjMoveNfa_3(0, 0);
				
			}
		}
		private int JjMoveNfa_3(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 3;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
					ulong l = ((ulong) 1L) << (int) curChar;

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
								if ((0x9fffff7affffd9ffL & l) != 0L)
								{
									if (kind > 19)
										kind = 19;
									JjCheckNAdd(1);
								}
								else if ((0x100002600L & l) != 0L)
								{
									if (kind > 22)
										kind = 22;
									JjCheckNAdd(2);
								}
								break;
							
							case 1: 
								if ((0xbffffffeffffd9ffL & l) == 0L)
									break;
								if (kind > 19)
									kind = 19;
								JjCheckNAdd(1);
								break;
							
							case 2: 
								if ((0x100002600L & l) == 0L)
									break;
								kind = 22;
								JjCheckNAdd(2);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
							case 1: 
								if (kind > 19)
									kind = 19;
								JjCheckNAdd(1);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
							case 1: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 19)
									kind = 19;
								JjCheckNAdd(1);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 3 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException e)
				{
					return curPos;
				}
			}
		}
		private int JjStopStringLiteralDfa_6(int pos, long active0)
		{
			switch (pos)
			{
				
				case 0: 
					if ((active0 & 0x10000000L) != 0L)
					{
						jjmatchedKind = 27;
						return - 1;
					}
					return - 1;
				
				case 1: 
					if ((active0 & 0x10000000L) != 0L)
					{
						if (jjmatchedPos == 0)
						{
							jjmatchedKind = 27;
							jjmatchedPos = 0;
						}
						return - 1;
					}
					return - 1;
				
				default: 
					return - 1;
				
			}
		}
		private int JjStartNfa_6(int pos, long active0)
		{
			return JjMoveNfa_6(JjStopStringLiteralDfa_6(pos, active0), pos + 1);
		}
		private int JjStartNfaWithStates_6(int pos, int kind, int state)
		{
			jjmatchedKind = kind;
			jjmatchedPos = pos;
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				return pos + 1;
			}
			return JjMoveNfa_6(state, pos + 1);
		}
		private int JjMoveStringLiteralDfa0_6()
		{
			switch (curChar)
			{
				
				case (char) (45): 
					return JjMoveStringLiteralDfa1_6(0x10000000L);
				
				default: 
					return JjMoveNfa_6(1, 0);
				
			}
		}
		private int JjMoveStringLiteralDfa1_6(long active0)
		{
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				JjStopStringLiteralDfa_6(0, active0);
				return 1;
			}
			switch (curChar)
			{
				
				case (char) (45): 
					return JjMoveStringLiteralDfa2_6(active0, 0x10000000L);
				
				default: 
					break;
				
			}
			return JjStartNfa_6(0, active0);
		}
		private int JjMoveStringLiteralDfa2_6(long old0, long active0)
		{
			if (((active0 &= old0)) == 0L)
				return JjStartNfa_6(0, old0);
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				JjStopStringLiteralDfa_6(1, active0);
				return 2;
			}
			switch (curChar)
			{
				
				case (char) (62): 
					if ((active0 & 0x10000000L) != 0L)
						return JjStopAtPos(2, 28);
					break;
				
				default: 
					break;
				
			}
			return JjStartNfa_6(1, active0);
		}
		private int JjMoveNfa_6(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 2;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
					ulong l = ((ulong) 1L) << curChar;

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
								if ((0xffffdfffffffffffL & l) != 0L)
								{
									if (kind > 27)
										kind = 27;
									JjCheckNAdd(0);
								}
								else if (curChar == 45)
								{
									if (kind > 27)
										kind = 27;
								}
								break;
							
							case 0: 
								if ((0xffffdfffffffffffL & l) == 0L)
									break;
								kind = 27;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
							case 0: 
								kind = 27;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
							case 0: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 27)
									kind = 27;
								JjCheckNAdd(0);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 2 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException e)
				{
					return curPos;
				}
			}
		}
		private int JjMoveStringLiteralDfa0_1()
		{
			return JjMoveNfa_1(1, 0);
		}
		private int JjMoveNfa_1(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 12;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
					ulong l = ((ulong) 1L) << (int) curChar;

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
								if ((0xafffffffffffffffL & l) != 0L)
								{
									if (kind > 14)
										kind = 14;
									JjCheckNAdd(0);
								}
								else if ((0x5000000000000000L & l) != 0L)
								{
									if (kind > 14)
										kind = 14;
								}
								if (curChar == 60)
									jjstateSet[jjnewStateCnt++] = 10;
								break;
							
							case 0: 
								if ((0xafffffffffffffffL & l) == 0L)
									break;
								if (kind > 14)
									kind = 14;
								JjCheckNAdd(0);
								break;
							
							case 3: 
								if ((0xafffffffffffffffL & l) != 0L)
									JjAddStates(18, 19);
								break;
							
							case 4: 
								if (curChar == 62 && kind > 15)
									kind = 15;
								break;
							
							case 10: 
								if (curChar == 47)
									jjstateSet[jjnewStateCnt++] = 9;
								break;
							
							case 11: 
								if (curChar == 60)
									jjstateSet[jjnewStateCnt++] = 10;
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
							case 0: 
								if (kind > 14)
									kind = 14;
								JjCheckNAdd(0);
								break;
							
							case 2: 
								if (curChar == 116)
									JjCheckNAddTwoStates(3, 4);
								break;
							
							case 3: 
								JjCheckNAddTwoStates(3, 4);
								break;
							
							case 5: 
								if (curChar == 112)
									jjstateSet[jjnewStateCnt++] = 2;
								break;
							
							case 6: 
								if (curChar == 105)
									jjstateSet[jjnewStateCnt++] = 5;
								break;
							
							case 7: 
								if (curChar == 114)
									jjstateSet[jjnewStateCnt++] = 6;
								break;
							
							case 8: 
								if (curChar == 99)
									jjstateSet[jjnewStateCnt++] = 7;
								break;
							
							case 9: 
								if (curChar == 115)
									jjstateSet[jjnewStateCnt++] = 8;
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 1: 
							case 0: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 14)
									kind = 14;
								JjCheckNAdd(0);
								break;
							
							case 3: 
								if ((jjbitVec0[i2] & l2) != 0L)
									JjAddStates(18, 19);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 12 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException e)
				{
					return curPos;
				}
			}
		}
		private int JjStopStringLiteralDfa_2(int pos, long active0)
		{
			switch (pos)
			{
				
				default: 
					return - 1;
				
			}
		}
		private int JjStartNfa_2(int pos, long active0)
		{
			return JjMoveNfa_2(JjStopStringLiteralDfa_2(pos, active0), pos + 1);
		}
		private int JjStartNfaWithStates_2(int pos, int kind, int state)
		{
			jjmatchedKind = kind;
			jjmatchedPos = pos;
			try
			{
				curChar = input_stream.ReadChar();
			}
			catch (System.IO.IOException e)
			{
				return pos + 1;
			}
			return JjMoveNfa_2(state, pos + 1);
		}
		private int JjMoveStringLiteralDfa0_2()
		{
			switch (curChar)
			{
				
				case (char) (34): 
					return JjStopAtPos(0, 21);
				
				case (char) (39): 
					return JjStopAtPos(0, 20);
				
				case (char) (61): 
					return JjStartNfaWithStates_2(0, 17, 3);
				
				default: 
					return JjMoveNfa_2(0, 0);
				
			}
		}
		private int JjMoveNfa_2(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 6;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
					ulong l = ((ulong) 1L) << curChar;

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
								if ((0x9fffff7affffd9ffL & l) != 0L)
								{
									if (kind > 16)
										kind = 16;
									JjCheckNAdd(1);
								}
								else if ((0x100002600L & l) != 0L)
								{
									if (kind > 22)
										kind = 22;
									JjCheckNAdd(5);
								}
								else if (curChar == 61)
									jjstateSet[jjnewStateCnt++] = 3;
								else if (curChar == 62)
								{
									if (kind > 18)
										kind = 18;
								}
								break;
							
							case 1: 
								if ((0x9ffffffeffffd9ffL & l) == 0L)
									break;
								if (kind > 16)
									kind = 16;
								JjCheckNAdd(1);
								break;
							
							case 2: 
							case 3: 
								if (curChar == 62 && kind > 18)
									kind = 18;
								break;
							
							case 4: 
								if (curChar == 61)
									jjstateSet[jjnewStateCnt++] = 3;
								break;
							
							case 5: 
								if ((0x100002600L & l) == 0L)
									break;
								kind = 22;
								JjCheckNAdd(5);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
							case 1: 
								if (kind > 16)
									kind = 16;
								JjCheckNAdd(1);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
							case 1: 
								if ((jjbitVec0[i2] & l2) == 0L)
									break;
								if (kind > 16)
									kind = 16;
								JjCheckNAdd(1);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException e)
				{
					return curPos;
				}
			}
		}
		internal static readonly int[] jjnextStates = new int[]{20, 21, 24, 12, 14, 16, 5, 8, 0, 4, 6, 0, 4, 6, 5, 0, 4, 6, 3, 4};
		public static readonly System.String[] jjstrLiteralImages = new System.String[]{"", "\x003C\x0073\x0063\x0072\x0069\x0070\x0074", null, null, "\x003C\x0021\x002D\x002D", "\x003C\x0021", null, null, null, null, null, null, null, null, null, null, null, "\x003D", null, null, "\x0027", "\x0022", null, null, null, null, null, null, "\x002D\x002D\x003E", null, "\x003E"};
		public static readonly System.String[] lexStateNames = new System.String[]{"DEFAULT", "WithinScript", "WithinTag", "AfterEquals", "WithinQuote1", "WithinQuote2", "WithinComment1", "WithinComment2"};
		public static readonly int[] jjnewLexState = new int[]{- 1, 1, 2, 2, 6, 7, - 1, - 1, - 1, - 1, - 1, - 1, - 1, - 1, - 1, 0, - 1, 3, 0, 2, 4, 5, - 1, - 1, 2, - 1, 2, - 1, 0, - 1, 0};
		internal static readonly long[] jjtoToken = new long[]{0x7fbfec7fL};
		internal static readonly long[] jjtoSkip = new long[]{0x400000L};
		protected internal SimpleCharStream input_stream;
		private uint[] jjrounds = new uint[28];
		private int[] jjstateSet = new int[56];
		protected internal char curChar;
		public HTMLParserTokenManager(SimpleCharStream stream)
		{
			InitBlock();
			if (SimpleCharStream.staticFlag)
				throw new System.ApplicationException("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
			input_stream = stream;
		}
		public HTMLParserTokenManager(SimpleCharStream stream, int lexState):this(stream)
		{
			SwitchTo(lexState);
		}
		public virtual void  ReInit(SimpleCharStream stream)
		{
			jjmatchedPos = jjnewStateCnt = 0;
			curLexState = defaultLexState;
			input_stream = stream;
			ReInitRounds();
		}
		private void  ReInitRounds()
		{
			int i;
			jjround = 0x80000001;
			for (i = 28; i-- > 0; )
				jjrounds[i] = 0x80000000;
		}
		public virtual void  ReInit(SimpleCharStream stream, int lexState)
		{
			ReInit(stream);
			SwitchTo(lexState);
		}
		public virtual void  SwitchTo(int lexState)
		{
			if (lexState >= 8 || lexState < 0)
				throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
			else
				curLexState = lexState;
		}
		
		protected internal virtual Token JjFillToken()
		{
			Token t = Token.NewToken(jjmatchedKind);
			t.kind = jjmatchedKind;
			System.String im = jjstrLiteralImages[jjmatchedKind];
			t.image = (im == null)?input_stream.GetImage():im;
			t.beginLine = input_stream.GetBeginLine();
			t.beginColumn = input_stream.GetBeginColumn();
			t.endLine = input_stream.GetEndLine();
			t.endColumn = input_stream.GetEndColumn();
			return t;
		}
		
		internal int curLexState = 0;
		internal int defaultLexState = 0;
		internal int jjnewStateCnt;
		internal uint jjround;
		internal int jjmatchedPos;
		internal int jjmatchedKind;
		
		public virtual Token GetNextToken()
		{
			int kind;
			Token specialToken = null;
			Token matchedToken;
			int curPos = 0;
			
			for (; ; )
			{
				try
				{
					curChar = input_stream.BeginToken();
				}
				catch (System.IO.IOException e)
				{
					jjmatchedKind = 0;
					matchedToken = JjFillToken();
					return matchedToken;
				}
				
				switch (curLexState)
				{
					
					case 0: 
						jjmatchedKind = 0x7fffffff;
						jjmatchedPos = 0;
						curPos = JjMoveStringLiteralDfa0_0();
						if (jjmatchedPos == 0 && jjmatchedKind > 13)
						{
							jjmatchedKind = 13;
						}
						break;
					
					case 1: 
						jjmatchedKind = 0x7fffffff;
						jjmatchedPos = 0;
						curPos = JjMoveStringLiteralDfa0_1();
						break;
					
					case 2: 
						jjmatchedKind = 0x7fffffff;
						jjmatchedPos = 0;
						curPos = JjMoveStringLiteralDfa0_2();
						break;
					
					case 3: 
						jjmatchedKind = 0x7fffffff;
						jjmatchedPos = 0;
						curPos = JjMoveStringLiteralDfa0_3();
						break;
					
					case 4: 
						jjmatchedKind = 0x7fffffff;
						jjmatchedPos = 0;
						curPos = JjMoveStringLiteralDfa0_4();
						break;
					
					case 5: 
						jjmatchedKind = 0x7fffffff;
						jjmatchedPos = 0;
						curPos = JjMoveStringLiteralDfa0_5();
						break;
					
					case 6: 
						jjmatchedKind = 0x7fffffff;
						jjmatchedPos = 0;
						curPos = JjMoveStringLiteralDfa0_6();
						break;
					
					case 7: 
						jjmatchedKind = 0x7fffffff;
						jjmatchedPos = 0;
						curPos = JjMoveStringLiteralDfa0_7();
						break;
					}
				if (jjmatchedKind != 0x7fffffff)
				{
					if (jjmatchedPos + 1 < curPos)
						input_stream.Backup(curPos - jjmatchedPos - 1);
					if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 63))) != 0L)
					{
						matchedToken = JjFillToken();
						if (jjnewLexState[jjmatchedKind] != - 1)
							curLexState = jjnewLexState[jjmatchedKind];
						return matchedToken;
					}
					else
					{
						if (jjnewLexState[jjmatchedKind] != - 1)
							curLexState = jjnewLexState[jjmatchedKind];
						goto EOFLoop;
					}
				}
				int error_line = input_stream.GetEndLine();
				int error_column = input_stream.GetEndColumn();
				System.String error_after = null;
				bool EOFSeen = false;
				try
				{
					input_stream.ReadChar(); input_stream.Backup(1);
				}
				catch (System.IO.IOException e1)
				{
					EOFSeen = true;
					error_after = curPos <= 1?"":input_stream.GetImage();
					if (curChar == '\n' || curChar == '\r')
					{
						error_line++;
						error_column = 0;
					}
					else
						error_column++;
				}
				if (!EOFSeen)
				{
					input_stream.Backup(1);
					error_after = curPos <= 1?"":input_stream.GetImage();
				}
				throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);

EOFLoop: ;
			}
		}
	}
}