/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Generated By:JavaCC: Do not edit this line. StandardTokenizerTokenManager.java */
using System;

namespace Lucene.Net.Analysis.Standard
{
	
	public class StandardTokenizerTokenManager : StandardTokenizerConstants
	{
        /// <summary>By default, closes the input Reader. </summary>
        public void Close()
        { 
            debugStream.Close(); 
            input_stream.Done(); 
        }

		private void  InitBlock()
		{
			System.IO.StreamWriter temp_writer;
			temp_writer = new System.IO.StreamWriter(System.Console.OpenStandardOutput(), System.Console.Out.Encoding);
			temp_writer.AutoFlush = true;
			debugStream = temp_writer;
		}
		public System.IO.StreamWriter debugStream;
		public virtual void  SetDebugStream(System.IO.StreamWriter ds)
		{
			debugStream = ds;
		}
		private int JjMoveStringLiteralDfa0_0()
		{
			return JjMoveNfa_0(0, 0);
		}
		private void  JjCheckNAdd(int state)
		{
			if (jjrounds[state] != jjround)
			{
				jjstateSet[jjnewStateCnt++] = state;
				jjrounds[state] = jjround;
			}
		}
		private void  JjAddStates(int start, int end)
		{
			do 
			{
				jjstateSet[jjnewStateCnt++] = jjnextStates[start];
			}
			while (start++ != end);
		}
		private void  JjCheckNAddTwoStates(int state1, int state2)
		{
			JjCheckNAdd(state1);
			JjCheckNAdd(state2);
		}
		private void  JjCheckNAddStates(int start, int end)
		{
			do 
			{
				JjCheckNAdd(jjnextStates[start]);
			}
			while (start++ != end);
		}
		private void  JjCheckNAddStates(int start)
		{
			JjCheckNAdd(jjnextStates[start]);
			JjCheckNAdd(jjnextStates[start + 1]);
		}
		internal static readonly ulong[] jjbitVec0 = new ulong[]{0x1ff0000000000000L, 0xffffffffffffc000L, 0xffffffffL, 0x600000000000000L};
		internal static readonly ulong[] jjbitVec2 = new ulong[]{0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL};
		internal static readonly ulong[] jjbitVec3 = new ulong[]{0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffL, 0x0L};
		internal static readonly ulong[] jjbitVec4 = new ulong[]{0xffffffffffffffffL, 0xffffffffffffffffL, 0x0L, 0x0L};
		internal static readonly ulong[] jjbitVec5 = new ulong[]{0x3fffffffffffL, 0x0L, 0x0L, 0x0L};
		internal static readonly ulong[] jjbitVec6 = new ulong[]{0x0L, 0x0L, 0xfffff00000000000L, 0x7fffffL};
		internal static readonly ulong[] jjbitVec7 = new ulong[]{0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffL, 0x0L};
		internal static readonly ulong[] jjbitVec8 = new ulong[]{0xfffffffeL, 0x0L, 0x0L, 0x0L};
		internal static readonly ulong[] jjbitVec9 = new ulong[]{0x0L, 0x0L, 0x0L, 0xff7fffffff7fffffL};
		internal static readonly ulong[] jjbitVec10 = new ulong[]{0x1600L, 0x0L, 0x0L, 0x0L};
		internal static readonly ulong[] jjbitVec11 = new ulong[]{0x0L, 0xffc000000000L, 0x0L, 0xffc000000000L};
		internal static readonly ulong[] jjbitVec12 = new ulong[]{0x0L, 0x3ff00000000L, 0x0L, 0x3ff000000000000L};
		internal static readonly ulong[] jjbitVec13 = new ulong[]{0x0L, 0xffc000000000L, 0x0L, 0xff8000000000L};
		internal static readonly ulong[] jjbitVec14 = new ulong[]{0x0L, 0xffc000000000L, 0x0L, 0x0L};
		internal static readonly ulong[] jjbitVec15 = new ulong[]{0x0L, 0x3ff0000L, 0x0L, 0x3ff0000L};
		internal static readonly ulong[] jjbitVec16 = new ulong[]{0x0L, 0x3ffL, 0x0L, 0x0L};
		internal static readonly ulong[] jjbitVec17 = new ulong[]{0xfffffffeL, 0x0L, 0xfffff00000000000L, 0x7fffffL};
		private int JjMoveNfa_0(int startState, int curPos)
		{
			int[] nextStates;
			int startsAt = 0;
			jjnewStateCnt = 75;
			int i = 1;
			jjstateSet[0] = startState;
			int j, kind = 0x7fffffff;
			for (; ; )
			{
				if (++jjround == 0x7fffffff)
					ReInitRounds();
				if (curChar < 64)
				{
                    ulong l = ((ulong) 1L) << curChar;

MatchLoop: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
								{
									if (kind > 1)
										kind = 1;
									JjCheckNAddStates(0, 11);
								}
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddStates(12, 17);
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddStates(18, 23);
								break;
							
							case 2: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddStates(18, 23);
								break;
							
							case 3: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(3, 4);
								break;
							
							case 4: 
							case 5: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(5, 6);
								break;
							
							case 6: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAdd(7);
								break;
							
							case 7: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAdd(7);
								break;
							
							case 8: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(8, 9);
								break;
							
							case 9: 
							case 10: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(10, 11);
								break;
							
							case 11: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAdd(12);
								break;
							
							case 12: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(12, 13);
								break;
							
							case 13: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(14, 15);
								break;
							
							case 14: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(14, 15);
								break;
							
							case 15: 
							case 16: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(11, 16);
								break;
							
							case 17: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(17, 18);
								break;
							
							case 18: 
							case 19: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(19, 20);
								break;
							
							case 20: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAdd(21);
								break;
							
							case 21: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(21, 22);
								break;
							
							case 22: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(23, 24);
								break;
							
							case 23: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(23, 24);
								break;
							
							case 24: 
							case 25: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(25, 26);
								break;
							
							case 26: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAdd(27);
								break;
							
							case 27: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(22, 27);
								break;
							
							case 28: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddStates(12, 17);
								break;
							
							case 29: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 1)
									kind = 1;
								JjCheckNAddStates(0, 11);
								break;
							
							case 30: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 1)
									kind = 1;
								JjCheckNAdd(30);
								break;
							
							case 31: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddStates(24, 26);
								break;
							
							case 32: 
								if ((0x600000000000L & l) != (ulong) 0L)
									JjCheckNAdd(33);
								break;
							
							case 33: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddStates(27, 29);
								break;
							
							case 35: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(35, 36);
								break;
							
							case 36: 
								if ((0x600000000000L & l) != (ulong) 0L)
									JjCheckNAdd(37);
								break;
							
							case 37: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 5)
									kind = 5;
								JjCheckNAddTwoStates(36, 37);
								break;
							
							case 38: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(38, 39);
								break;
							
							case 39: 
								if (curChar == 46)
									JjCheckNAdd(40);
								break;
							
							case 40: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddTwoStates(39, 40);
								break;
							
							case 41: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(41, 42);
								break;
							
							case 42: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(43, 44);
								break;
							
							case 43: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(43, 44);
								break;
							
							case 44: 
							case 45: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAdd(45);
								break;
							
							case 46: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(46, 47);
								break;
							
							case 47: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(48, 49);
								break;
							
							case 48: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(48, 49);
								break;
							
							case 49: 
							case 50: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(50, 51);
								break;
							
							case 51: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAdd(52);
								break;
							
							case 52: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(47, 52);
								break;
							
							case 53: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(53, 54);
								break;
							
							case 54: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(55, 56);
								break;
							
							case 55: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(55, 56);
								break;
							
							case 56: 
							case 57: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(57, 58);
								break;
							
							case 58: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAdd(59);
								break;
							
							case 59: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(59, 60);
								break;
							
							case 60: 
								if ((0xf00000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(61, 62);
								break;
							
							case 61: 
								if ((0x3ff000000000000L & l) != (ulong) 0L)
									JjCheckNAddTwoStates(61, 62);
								break;
							
							case 62: 
							case 63: 
								if ((0x3ff000000000000L & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(58, 63);
								break;
							
							case 66: 
								if (curChar == 39)
									jjstateSet[jjnewStateCnt++] = 67;
								break;
							
							case 69: 
								if (curChar == 46)
									JjCheckNAdd(70);
								break;
							
							case 71: 
								if (curChar != 46)
									break;
								if (kind > 3)
									kind = 3;
								JjCheckNAdd(70);
								break;
							
							case 73: 
								if (curChar == 38)
									jjstateSet[jjnewStateCnt++] = 74;
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else if (curChar < 128)
				{
					ulong l = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddStates(30, 35);
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
								{
									if (kind > 1)
										kind = 1;
									JjCheckNAddStates(0, 11);
								}
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddStates(18, 23);
								break;
							
							case 2: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddStates(18, 23);
								break;
							
							case 3: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(3, 4);
								break;
							
							case 5: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjAddStates(36, 37);
								break;
							
							case 6: 
								if (curChar == 95)
									JjCheckNAdd(7);
								break;
							
							case 7: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAdd(7);
								break;
							
							case 8: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(8, 9);
								break;
							
							case 10: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(10, 11);
								break;
							
							case 11: 
								if (curChar == 95)
									JjCheckNAdd(12);
								break;
							
							case 12: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(12, 13);
								break;
							
							case 13: 
								if (curChar == 95)
									JjCheckNAddTwoStates(14, 15);
								break;
							
							case 14: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(14, 15);
								break;
							
							case 16: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(11, 16);
								break;
							
							case 17: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(17, 18);
								break;
							
							case 19: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjAddStates(38, 39);
								break;
							
							case 20: 
								if (curChar == 95)
									JjCheckNAdd(21);
								break;
							
							case 21: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(21, 22);
								break;
							
							case 22: 
								if (curChar == 95)
									JjCheckNAddTwoStates(23, 24);
								break;
							
							case 23: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(23, 24);
								break;
							
							case 25: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjAddStates(40, 41);
								break;
							
							case 26: 
								if (curChar == 95)
									JjCheckNAdd(27);
								break;
							
							case 27: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(22, 27);
								break;
							
							case 29: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 1)
									kind = 1;
								JjCheckNAddStates(0, 11);
								break;
							
							case 30: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 1)
									kind = 1;
								JjCheckNAdd(30);
								break;
							
							case 31: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddStates(24, 26);
								break;
							
							case 32: 
								if (curChar == 95)
									JjCheckNAdd(33);
								break;
							
							case 33: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddStates(27, 29);
								break;
							
							case 34: 
								if (curChar == 64)
									JjCheckNAdd(35);
								break;
							
							case 35: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(35, 36);
								break;
							
							case 37: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 5)
									kind = 5;
								JjCheckNAddTwoStates(36, 37);
								break;
							
							case 38: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(38, 39);
								break;
							
							case 40: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddTwoStates(39, 40);
								break;
							
							case 41: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(41, 42);
								break;
							
							case 42: 
								if (curChar == 95)
									JjCheckNAddTwoStates(43, 44);
								break;
							
							case 43: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(43, 44);
								break;
							
							case 45: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								jjstateSet[jjnewStateCnt++] = 45;
								break;
							
							case 46: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(46, 47);
								break;
							
							case 47: 
								if (curChar == 95)
									JjCheckNAddTwoStates(48, 49);
								break;
							
							case 48: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(48, 49);
								break;
							
							case 50: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjAddStates(42, 43);
								break;
							
							case 51: 
								if (curChar == 95)
									JjCheckNAdd(52);
								break;
							
							case 52: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(47, 52);
								break;
							
							case 53: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(53, 54);
								break;
							
							case 54: 
								if (curChar == 95)
									JjCheckNAddTwoStates(55, 56);
								break;
							
							case 55: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(55, 56);
								break;
							
							case 57: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(57, 58);
								break;
							
							case 58: 
								if (curChar == 95)
									JjCheckNAdd(59);
								break;
							
							case 59: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(59, 60);
								break;
							
							case 60: 
								if (curChar == 95)
									JjCheckNAddTwoStates(61, 62);
								break;
							
							case 61: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(61, 62);
								break;
							
							case 63: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(58, 63);
								break;
							
							case 64: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddStates(30, 35);
								break;
							
							case 65: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(65, 66);
								break;
							
							case 67: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 2)
									kind = 2;
								JjCheckNAddTwoStates(66, 67);
								break;
							
							case 68: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(68, 69);
								break;
							
							case 70: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjAddStates(44, 45);
								break;
							
							case 72: 
								if ((0x7fffffe07fffffeL & l) != (ulong) 0L)
									JjCheckNAddTwoStates(72, 73);
								break;
							
							case 73: 
								if (curChar == 64)
									JjCheckNAdd(74);
								break;
							
							case 74: 
								if ((0x7fffffe07fffffeL & l) == (ulong) 0L)
									break;
								if (kind > 4)
									kind = 4;
								JjCheckNAdd(74);
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				else
				{
					int hiByte = (int) (curChar >> 8);
					int i1 = hiByte >> 6;
					ulong l1 = ((ulong) 1L) << (hiByte & 63);
					int i2 = (curChar & 0xff) >> 6;
					ulong l2 = ((ulong) 1L) << (curChar & 63);

MatchLoop1: 
					do 
					{
						switch (jjstateSet[--i])
						{
							
							case 0: 
								if (JjCanMove_0(hiByte, i1, i2, l1, l2))
								{
									if (kind > 12)
										kind = 12;
								}
								if (JjCanMove_1(hiByte, i1, i2, l1, l2))
								{
									if (kind > 13)
										kind = 13;
								}
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddStates(18, 23);
								if (JjCanMove_3(hiByte, i1, i2, l1, l2))
									JjCheckNAddStates(12, 17);
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
								{
									if (kind > 1)
										kind = 1;
									JjCheckNAddStates(0, 11);
								}
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddStates(30, 35);
								break;
							
							case 1: 
								if (JjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 13)
									kind = 13;
								break;
							
							case 2: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddStates(18, 23);
								break;
							
							case 3: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(3, 4);
								break;
							
							case 4: 
								if (JjCanMove_3(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(5, 6);
								break;
							
							case 5: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(5, 6);
								break;
							
							case 7: 
								if (!JjCanMove_4(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								jjstateSet[jjnewStateCnt++] = 7;
								break;
							
							case 8: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(8, 9);
								break;
							
							case 9: 
								if (JjCanMove_3(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(10, 11);
								break;
							
							case 10: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(10, 11);
								break;
							
							case 12: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjAddStates(46, 47);
								break;
							
							case 14: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjAddStates(48, 49);
								break;
							
							case 15: 
								if (!JjCanMove_3(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(11, 16);
								break;
							
							case 16: 
								if (!JjCanMove_2(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(11, 16);
								break;
							
							case 17: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(17, 18);
								break;
							
							case 18: 
								if (JjCanMove_3(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(19, 20);
								break;
							
							case 19: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(19, 20);
								break;
							
							case 21: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(21, 22);
								break;
							
							case 23: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjAddStates(50, 51);
								break;
							
							case 24: 
								if (JjCanMove_3(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(25, 26);
								break;
							
							case 25: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(25, 26);
								break;
							
							case 27: 
								if (!JjCanMove_4(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(22, 27);
								break;
							
							case 28: 
								if (JjCanMove_3(hiByte, i1, i2, l1, l2))
									JjCheckNAddStates(12, 17);
								break;
							
							case 29: 
								if (!JjCanMove_4(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 1)
									kind = 1;
								JjCheckNAddStates(0, 11);
								break;
							
							case 30: 
								if (!JjCanMove_4(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 1)
									kind = 1;
								JjCheckNAdd(30);
								break;
							
							case 31: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjCheckNAddStates(24, 26);
								break;
							
							case 33: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjCheckNAddStates(27, 29);
								break;
							
							case 35: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(35, 36);
								break;
							
							case 37: 
								if (!JjCanMove_4(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 5)
									kind = 5;
								JjCheckNAddTwoStates(36, 37);
								break;
							
							case 38: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(38, 39);
								break;
							
							case 40: 
								if (!JjCanMove_4(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 6)
									kind = 6;
								JjCheckNAddTwoStates(39, 40);
								break;
							
							case 41: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(41, 42);
								break;
							
							case 43: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjAddStates(52, 53);
								break;
							
							case 44: 
								if (!JjCanMove_3(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAdd(45);
								break;
							
							case 45: 
								if (!JjCanMove_2(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAdd(45);
								break;
							
							case 46: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(46, 47);
								break;
							
							case 48: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjAddStates(54, 55);
								break;
							
							case 49: 
								if (JjCanMove_3(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(50, 51);
								break;
							
							case 50: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(50, 51);
								break;
							
							case 52: 
								if (!JjCanMove_4(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(47, 52);
								break;
							
							case 53: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(53, 54);
								break;
							
							case 55: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjAddStates(56, 57);
								break;
							
							case 56: 
								if (JjCanMove_3(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(57, 58);
								break;
							
							case 57: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(57, 58);
								break;
							
							case 59: 
								if (JjCanMove_4(hiByte, i1, i2, l1, l2))
									JjAddStates(58, 59);
								break;
							
							case 61: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjAddStates(60, 61);
								break;
							
							case 62: 
								if (!JjCanMove_3(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(58, 63);
								break;
							
							case 63: 
								if (!JjCanMove_2(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 7)
									kind = 7;
								JjCheckNAddTwoStates(58, 63);
								break;
							
							case 64: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddStates(30, 35);
								break;
							
							case 65: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(65, 66);
								break;
							
							case 67: 
								if (!JjCanMove_2(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 2)
									kind = 2;
								JjCheckNAddTwoStates(66, 67);
								break;
							
							case 68: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(68, 69);
								break;
							
							case 70: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjAddStates(44, 45);
								break;
							
							case 72: 
								if (JjCanMove_2(hiByte, i1, i2, l1, l2))
									JjCheckNAddTwoStates(72, 73);
								break;
							
							case 74: 
								if (!JjCanMove_2(hiByte, i1, i2, l1, l2))
									break;
								if (kind > 4)
									kind = 4;
								jjstateSet[jjnewStateCnt++] = 74;
								break;
							
							default:  break;
							
						}
					}
					while (i != startsAt);
				}
				if (kind != 0x7fffffff)
				{
					jjmatchedKind = kind;
					jjmatchedPos = curPos;
					kind = 0x7fffffff;
				}
				++curPos;
				if ((i = jjnewStateCnt) == (startsAt = 75 - (jjnewStateCnt = startsAt)))
					return curPos;
				try
				{
					curChar = input_stream.ReadChar();
				}
				catch (System.IO.IOException)
				{
					return curPos;
				}
			}
		}
		internal static readonly int[] jjnextStates = new int[]{30, 31, 32, 34, 38, 39, 41, 42, 46, 47, 53, 54, 5, 6, 10, 11, 19, 20, 3, 4, 8, 9, 17, 18, 31, 32, 34, 32, 33, 34, 65, 66, 68, 69, 72, 73, 5, 6, 19, 20, 25, 26, 50, 51, 70, 71, 12, 13, 14, 15, 23, 24, 43, 44, 48, 49, 55, 56, 59, 60, 61, 62};
		private static bool JjCanMove_0(int hiByte, int i1, int i2, ulong l1, ulong l2)
		{
			switch (hiByte)
			{
				
				case 48: 
					return ((jjbitVec2[i2] & l2) != (ulong) 0L);
				
				case 49: 
					return ((jjbitVec3[i2] & l2) != (ulong) 0L);
				
				case 51: 
					return ((jjbitVec4[i2] & l2) != (ulong) 0L);
				
				case 61: 
					return ((jjbitVec5[i2] & l2) != (ulong) 0L);
				
				default: 
					if ((jjbitVec0[i1] & l1) != (ulong) 0L)
						return true;
					return false;
				
			}
		}
		private static bool JjCanMove_1(int hiByte, int i1, int i2, ulong l1, ulong l2)
		{
			switch (hiByte)
			{
				
				case 215: 
					return ((jjbitVec7[i2] & l2) != (ulong) 0L);
				
				default: 
					if ((jjbitVec6[i1] & l1) != (ulong) 0L)
						return true;
					return false;
				
			}
		}
		private static bool JjCanMove_2(int hiByte, int i1, int i2, ulong l1, ulong l2)
		{
			switch (hiByte)
			{
				
				case 0: 
					return ((jjbitVec9[i2] & l2) != (ulong) 0L);
				
				default: 
					if ((jjbitVec8[i1] & l1) != (ulong) 0L)
						return true;
					return false;
				
			}
		}
		private static bool JjCanMove_3(int hiByte, int i1, int i2, ulong l1, ulong l2)
		{
			switch (hiByte)
			{
				
				case 6: 
					return ((jjbitVec12[i2] & l2) != (ulong) 0L);
				
				case 11: 
					return ((jjbitVec13[i2] & l2) != (ulong) 0L);
				
				case 13: 
					return ((jjbitVec14[i2] & l2) != (ulong) 0L);
				
				case 14: 
					return ((jjbitVec15[i2] & l2) != (ulong) 0L);
				
				case 16: 
					return ((jjbitVec16[i2] & l2) != (ulong) 0L);
				
				default: 
					if ((jjbitVec10[i1] & l1) != (ulong) 0L)
						if ((jjbitVec11[i2] & l2) == (ulong) 0L)
							return false;
						else
							return true;
					return false;
				
			}
		}
		private static bool JjCanMove_4(int hiByte, int i1, int i2, ulong l1, ulong l2)
		{
			switch (hiByte)
			{
				
				case 0: 
					return ((jjbitVec9[i2] & l2) != (ulong) 0L);
				
				case 215: 
					return ((jjbitVec7[i2] & l2) != (ulong) 0L);
				
				default: 
					if ((jjbitVec17[i1] & l1) != (ulong) 0L)
						return true;
					return false;
				
			}
		}
		public static readonly System.String[] jjstrLiteralImages = new System.String[]{"", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
		public static readonly System.String[] lexStateNames = new System.String[]{"DEFAULT"};
		internal static readonly long[] jjtoToken = new long[]{0x30ffL};
		internal static readonly long[] jjtoSkip = new long[]{0x8000L};
		protected internal CharStream input_stream;
		private uint[] jjrounds = new uint[75];
		private int[] jjstateSet = new int[150];
		protected internal char curChar;
		public StandardTokenizerTokenManager(CharStream stream)
		{
			InitBlock();
			input_stream = stream;
		}
		public StandardTokenizerTokenManager(CharStream stream, int lexState) : this(stream)
		{
			SwitchTo(lexState);
		}
		public virtual void  ReInit(CharStream stream)
		{
			jjmatchedPos = jjnewStateCnt = 0;
			curLexState = defaultLexState;
			input_stream = stream;
			ReInitRounds();
		}
		private void  ReInitRounds()
		{
			int i;
			jjround = 0x80000001;
			for (i = 75; i-- > 0; )
				jjrounds[i] = 0x80000000;
		}
		public virtual void  ReInit(CharStream stream, int lexState)
		{
			ReInit(stream);
			SwitchTo(lexState);
		}
		public virtual void  SwitchTo(int lexState)
		{
			if (lexState >= 1 || lexState < 0)
				throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
			else
				curLexState = lexState;
		}
		
		protected internal virtual Token JjFillToken()
		{
			Token t = Token.NewToken(jjmatchedKind);
			t.kind = jjmatchedKind;
			System.String im = jjstrLiteralImages[jjmatchedKind];
			t.image = (im == null) ? input_stream.GetImage() : im;
			t.beginLine = input_stream.GetBeginLine();
			t.beginColumn = input_stream.GetBeginColumn();
			t.endLine = input_stream.GetEndLine();
			t.endColumn = input_stream.GetEndColumn();
			return t;
		}
		
		internal int curLexState = 0;
		internal int defaultLexState = 0;
		internal int jjnewStateCnt;
		internal uint jjround;
		internal int jjmatchedPos;
		internal int jjmatchedKind;
		
		public virtual Token GetNextToken()
		{
			int kind;
			Token specialToken = null;
			Token matchedToken;
			int curPos = 0;
			
			for (; ; )
			{
				try
				{
					curChar = input_stream.BeginToken();
				}
				catch (System.IO.IOException)
				{
					jjmatchedKind = 0;
					matchedToken = JjFillToken();
					return matchedToken;
				}
				
				jjmatchedKind = 0x7fffffff;
				jjmatchedPos = 0;
				curPos = JjMoveStringLiteralDfa0_0();
				if (jjmatchedPos == 0 && jjmatchedKind > 15)
				{
					jjmatchedKind = 15;
				}
				if (jjmatchedKind != 0x7fffffff)
				{
					if (jjmatchedPos + 1 < curPos)
						input_stream.Backup(curPos - jjmatchedPos - 1);
					if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 63))) != 0L)
					{
						matchedToken = JjFillToken();
						return matchedToken;
					}
					else
					{
						goto EOFLoop;
					}
				}
				int error_line = input_stream.GetEndLine();
				int error_column = input_stream.GetEndColumn();
				System.String error_after = null;
				bool EOFSeen = false;
				try
				{
					input_stream.ReadChar(); input_stream.Backup(1);
				}
				catch (System.IO.IOException)
				{
					EOFSeen = true;
					error_after = curPos <= 1?"":input_stream.GetImage();
					if (curChar == '\n' || curChar == '\r')
					{
						error_line++;
						error_column = 0;
					}
					else
						error_column++;
				}
				if (!EOFSeen)
				{
					input_stream.Backup(1);
					error_after = curPos <= 1?"":input_stream.GetImage();
				}
				throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);

EOFLoop: ;
			}
		}
	}
}