﻿using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Text;
using System.IO;
using System.Collections;

using Lucene.Net.Documents;
using Lucene.Net.Index;
using Lucene.Net.Search;
using Lucene.Net.QueryParsers;
using Lucene.Net.Analysis.Standard;


public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {    }


    protected void Button2_Click(object sender, EventArgs e)
    {
        CreateIndex();
    }

    //获得查询结果
    public SqlDataReader ExecuteQuery(string sql)
    {
        string connstr = @"server=.;uid=sa;pwd=sa;database=lucene";
        SqlConnection con = new SqlConnection(connstr);
       
        if(con.State== ConnectionState.Closed)con.Open();

        SqlCommand command = new SqlCommand(sql, con);
        SqlDataReader datareader = command.ExecuteReader();
        return datareader;
    }
    //建立索引
    public IndexWriter CreateIndex()
    {
        string INDEX_STORE_PATH = Server.MapPath("index");  //INDEX_STORE_PATH 为索引存储目录

        IndexWriter writer = null;
        try
        {
            writer = new IndexWriter(INDEX_STORE_PATH, new StandardAnalyzer(), true);

            SqlDataReader myred = ExecuteQuery("select title,content from article");

            //建立索引字段
            while (myred.Read())
            {
                Document doc = new Document();
                doc.Add(new Field("tablename", "article", Field.Store.YES, Field.Index.UN_TOKENIZED));//存储，不索引
               // doc.Add(new Field("wid", myred["wid"].ToString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                doc.Add(new Field("title", myred["title"].ToString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                doc.Add(new Field("indexcontent", myred["title"].ToString() + myred["content"].ToString(), Field.Store.NO, Field.Index.TOKENIZED));//不存储，索引，indexcontent实现了title和content，也就是标题和内容的索引
              //  doc.Add(new Field("createdate", myred["createdate"].ToString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                
                writer.AddDocument(doc);
            }
            myred.Close();
            myred.Dispose();
            //

            writer.Optimize();
            writer.Close();

            TextBox1.Text = "建立索引成功" ;
        }
        catch (Exception e)
        {
            TextBox1.Text = e.ToString();
        }
        return writer;
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        string INDEX_STORE_PATH = Server.MapPath("index");  //INDEX_STORE_PATH 为索引存储目录
        string keyword = TextBox2.Text;

        Hits myhit = null;

        IndexSearcher mysea = new IndexSearcher(INDEX_STORE_PATH);
        QueryParser q = new QueryParser("indexcontent", new StandardAnalyzer());
        Query query = q.Parse(keyword);
        
        myhit = mysea.Search(query);
        Response.Write("关于：" + keyword + "  搜索到" + myhit.Length() + "个结果<br>");
        
        if (myhit != null)
        {
            DataRow myrow;
            DataTable mytab = new DataTable();
           // mytab.Columns.Add("wid");
            mytab.Columns.Add("title");
           // mytab.Columns.Add("createdate");
            mytab.Columns.Add("tablename");
            mytab.Clear();
            for (int i = 0; i < myhit.Length(); i++)
            {
                Document doc = myhit.Doc(i);
                myrow = mytab.NewRow();
              //  myrow[0] = doc.Get("wid").ToString();
                myrow[0] = doc.Get("title").ToString();
              //  myrow[2] = doc.Get("createdate").ToString();
                myrow[1] = doc.Get("tablename").ToString();
                mytab.Rows.Add(myrow);
                myrow.AcceptChanges();
            }

            GridView1.DataSource = mytab;
            GridView1.DataBind();
        }
        else
        {
            Response.Write("Hits为空");
        }
        mysea.Close();
    }

}
