﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class A_Detail_IncomeInfo : PageBase
{
    private static int accountTypeIdBefore = 0;//修改前的账户类型id
    private static int accountIdBefore = 0;//修改前的账户id
    private static double incomeMoneyBefore = 0.00;//修改前的收入金额
    private static int accountTypeId=0;//修改后的账户类型id
    private static int accountId = 0;//修改后的账户id
    private static int incomeTypeId = 0;//修改后的支出类型id
    private static int incomeSellerId = 0;//修改后的付款方id
    private static int projectId = 0;//修改后的项目id
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            OfficeManage.BindDdlIncomeType(ddlIncomeType);//绑定收入类型
            OfficeManage.BindDdlSeller(ddlSeller);//绑定付款方
            OfficeManage.BindDdlProject(ddlProject);//绑定项目
            BindPage();
        }
    }
    #region 功能栏事件（全部、支出、收入、转账、借贷按钮）
    protected void btnAllDetail_Click(object sender, EventArgs e)//全部明细
    {
        Response.Redirect("Detail.aspx");
    }
    protected void btnExpenditure_Click(object sender, EventArgs e)//支出明细
    {
        Response.Redirect("Detail_Expenditure.aspx");
    }
    protected void btnIncome_Click(object sender, EventArgs e)//收入明细
    {
        Response.Redirect("Detail_Income.aspx");
    }
    protected void btnTransfer_Click(object sender, EventArgs e)//转账明细
    {
        Response.Redirect("Detail_Transfer.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷明细
    {
        Response.Redirect("Detail_Loan.aspx");
    }
    #endregion
    #region 绑定收入信息页面数据
    /// <summary>
    /// 绑定收入信息页面数据
    /// </summary>
    public void BindPage()
    {
        if (!string.IsNullOrEmpty(Request["riid"]))
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT RIncomeMoney,RIncomeTypeId,IncomeTypeName,IncomeState,RIAccountTypeId,RIAccountId,RIncomeSellerId,SellerName,SellerState,RIncomeDateTime,RIncomeProjectId,ProjectTypeName,ProjectState,RIncomeRemarks,HandlerId FROM dbo.V_Detail_Income WHERE State=1 AND RecordIncomeId="+ConvertHelper.GetInteger(Request["riid"])+"", "constring");
            if(ds.Tables[0].Rows.Count>0)
            {
                #region 修改前账户类型id，账户id，收入金额
                accountTypeIdBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountTypeId"]);//修改前账户类型id
                accountIdBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//修改前账户类型id
                incomeMoneyBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIncomeMoney"]);//修改前收入金额
                #endregion
                txtIncomeMoney.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RIncomeMoney"]);//收入金额
                #region 收入类型
                if (ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["IncomeState"]) == 0)//收入类型已删除
                {
                    spanIncomeTypeName.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["IncomeTypeName"]);//已删除的收入类型名
                    incomeTypeId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIncomeTypeId"]);//收入类型id
                }
                else//收入类型未删除
                {
                    ddlIncomeType.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RIncomeTypeId"]);//收入类型
                }
                #endregion
                #region 付款方
                if (ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["SellerState"]) == 0)//付款方已删除
                {
                    spanSellerName.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["SellerName"]);//已删除的付款方名
                    incomeSellerId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIncomeSellerId"]);//修改后的付款方id
                }
                else//付款方未删除
                {
                    ddlSeller.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RIncomeSellerId"]);//付款方
                }
                #endregion
                #region 收入账户
                accountTypeId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountTypeId"]);//修改后账户类型id
                uclAccount.AccountTypeID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountTypeId"]);//账户类型
                if (accountTypeId==1)//现金账户
                {
                    #region 现金账户
                    DataSet dsCashAccount = SqlHelper.GetDataSet("SELECT CashAccountName,State FROM dbo.tabA_Account_Cash WHERE CashAccountId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]) + "", "constring");
                    if (dsCashAccount.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsCashAccount.Tables[0].Rows[0]["State"]) == 0)//现金账户已删除
                        {
                            spanAccountName.InnerHtml = ConvertHelper.GetString(dsCashAccount.Tables[0].Rows[0]["CashAccountName"]);//已删除的现金账户名
                            accountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//修改后账户id
                        }
                        else//现金账户未删除
                        {
                            uclAccount.CashAccountID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//现金账户
                        }
                    }
                    #endregion
                }
                else if(accountTypeId==2)//信用卡
                {
                    #region 信用卡
                    DataSet dsCreditCard = SqlHelper.GetDataSet("SELECT CreditCardName,State FROM dbo.tabA_Account_CreditCard WHERE CreditCardId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]) + "", "constring");
                    if (dsCreditCard.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsCreditCard.Tables[0].Rows[0]["State"]) == 0)//信用卡已删除
                        {
                            spanAccountName.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CreditCardName"]);//已删除的信用卡名
                            accountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//修改后账户id
                        }
                        else//信用卡未删除
                        {
                            uclAccount.CreditCardID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//信用卡id
                        }
                    }
                    #endregion
                }
                else if(accountTypeId==3)//储蓄卡
                {
                    #region 储蓄卡
                    DataSet dsSavingsCard = SqlHelper.GetDataSet("SELECT SavingsCardName,State FROM dbo.tabA_Account_SavingsCard WHERE SavingsCardId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]) + "", "constring");
                    if (dsSavingsCard.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsSavingsCard.Tables[0].Rows[0]["State"]) == 0)//储蓄卡已删除
                        {
                            spanAccountName.InnerHtml = ConvertHelper.GetString(dsSavingsCard.Tables[0].Rows[0]["SavingsCardName"]);
                            accountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//修改后账户id
                        }
                        else//储蓄卡未删除
                        {
                            uclAccount.SavingsCardID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//储蓄卡
                        }
                    }
                    #endregion
                }
                else if(accountTypeId==4)//网上支付
                {
                    #region 网上支付
                    DataSet dsOnlinePay = SqlHelper.GetDataSet("SELECT OnlinePayName,State FROM dbo.tabA_Account_OnlinePay WHERE OnlinePayId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]) + "", "constring");
                    if (dsOnlinePay.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsOnlinePay.Tables[0].Rows[0]["State"]) == 0)//网上支付已删除
                        {
                            spanAccountName.InnerHtml = ConvertHelper.GetString(dsOnlinePay.Tables[0].Rows[0]["OnlinePayName"]);//已删除的网上支付名
                            accountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//修改后账户id
                        }
                        else//网上支付未删除
                        {
                            uclAccount.OnlinePayID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIAccountId"]);//网上支付账户
                        }
                    }
                    #endregion
                }
                #endregion
                txtIncomeDateTime.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RIncomeDateTime"]);//支出时间
                #region 项目
                if (ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["ProjectState"]) == 0)//项目已删除
                {
                    spanProjectName.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["ProjectTypeName"]);//已删除的项目名
                    projectId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RIncomeProjectId"]);//修改后的项目id
                }
                else//项目未删除
                {
                    ddlProject.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RIncomeProjectId"]);//项目
                }
                #endregion
                txtIncomeRemarks.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RIncomeRemarks"]);//收入备注
            }
        }
    }
    #endregion 
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if(!string.IsNullOrEmpty(Request["riid"]))
        {
            if (spanIncomeTypeName.InnerHtml == "")//修改前支出类型未删除
            {
                incomeTypeId = ConvertHelper.GetInteger(ddlIncomeType.SelectedValue);//支出类型
            }
            else//修改前支出类型已删除
            {
                if(ddlIncomeType.SelectedValue!="0")
                {
                    incomeTypeId = ConvertHelper.GetInteger(ddlIncomeType.SelectedValue);//支出类型
                }
            }
            if (spanSellerName.InnerHtml == "")//修改前付款方未删除
            {
                incomeSellerId = ConvertHelper.GetInteger(ddlSeller.SelectedValue);//付款方
            }
            else//修改前付款方已删除
            {
                if(ddlSeller.SelectedValue!="0")
                {
                    incomeSellerId = ConvertHelper.GetInteger(ddlSeller.SelectedValue);//付款方
                }
            }
            if (spanAccountName.InnerHtml == "")//修改前账户未删除
            {
                accountTypeId = ConvertHelper.GetInteger(uclAccount.AccountTypeID);//账户类型
                if (accountTypeId == 1)//现金账户
                {
                    accountId = ConvertHelper.GetInteger(uclAccount.CashAccountID);//账户id
                }
                else if (accountTypeId == 2)//信用卡
                {
                    accountId = ConvertHelper.GetInteger(uclAccount.CreditCardID);//账户id
                }
                else if (accountTypeId == 3)//储蓄卡
                {
                    accountId = ConvertHelper.GetInteger(uclAccount.SavingsCardID);//账户id
                }
                else if (accountTypeId == 4)//网上支付
                {
                    accountId = ConvertHelper.GetInteger(uclAccount.OnlinePayID);//账户id
                }
            }
            else//修改前账户已删除
            {
                if (!(uclAccount.CashAccountID == 0 && uclAccount.CreditCardID == 0 && uclAccount.SavingsCardID == 0 && uclAccount.OnlinePayID == 0))
                {
                    accountTypeId = ConvertHelper.GetInteger(uclAccount.AccountTypeID);//账户类型id
                    if (accountTypeId == 1)//现金账户
                    {
                        accountId = ConvertHelper.GetInteger(uclAccount.CashAccountID);//账户id
                    }
                    else if (accountTypeId == 2)//信用卡
                    {
                        accountId = ConvertHelper.GetInteger(uclAccount.CreditCardID);//账户id
                    }
                    else if (accountTypeId == 3)//储蓄卡
                    {
                        accountId = ConvertHelper.GetInteger(uclAccount.SavingsCardID);//账户id
                    }
                    else if (accountTypeId == 4)//网上支付
                    {
                        accountId = ConvertHelper.GetInteger(uclAccount.OnlinePayID);//账户id
                    }
                }
            }
            if (spanProjectName.InnerHtml == "")//项目已删除
            {
                projectId = ConvertHelper.GetInteger(ddlProject.SelectedValue);//项目
            }
            else//项目未删除
            {
                if(ddlProject.SelectedValue!="0")
                {
                    projectId = ConvertHelper.GetInteger(ddlProject.SelectedValue);//项目
                }
            }
            int flag = SqlHelper.Operation("UPDATE dbo.tabA_Record_Income SET RIncomeMoney=" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + ",RIncomeTypeId=" + incomeTypeId + ",RIncomeSellerId=" + incomeSellerId + ",RIAccountTypeId=" + accountTypeId + ",RIAccountId=" + accountId + ",RIncomeDateTime='" + ConvertHelper.GetDateTime(txtIncomeDateTime.Text.Trim()) + "',RIncomeProjectId=" + projectId + ",RIncomeRemarks='" + txtIncomeRemarks.Text.Trim() + "' WHERE RecordIncomeId=" + ConvertHelper.GetInteger(Request["riid"]) + "", "constring");
            if (flag > 0)//修改收入记录成功
            {
                if (accountTypeId == accountTypeIdBefore && accountId == accountIdBefore)//修改前后账户类型相同，账户id相同
                {
                    if (incomeMoneyBefore != ConvertHelper.GetDouble(txtIncomeMoney.Text.Trim()))//修改前后账户类型相同，账户id相同，收入金额不同
                    {
                        int flags = 0;//修改前后账户类型相同，账户相同，收入金额不同的余额修改是否成功的标志
                        if (accountTypeId == 1)//现金账户
                        {
                            flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(incomeMoneyBefore) + "+" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + " WHERE CashAccountId=" + accountId + "", "constring");
                        }
                        else if (accountTypeId == 2)//信用卡(CardArrears:欠款金额，所以支出是“+”，收入是“-”)
                        {
                            flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(incomeMoneyBefore) + "-" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + " WHERE CreditCardId=" + accountId + "", "constring");
                        }
                        else if (accountTypeId == 3)//储蓄卡
                        {
                            flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(incomeMoneyBefore) + "+" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + " WHERE SavingsCardId=" + accountId + "", "constring");
                        }
                        else if (accountTypeId == 4)//网上支付
                        {
                            flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(incomeMoneyBefore) + "+" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + " WHERE OnlinePayId=" + accountId + "", "constring");
                        }
                        if (flags > 0)//修改前后账户类型相同，账户相同，收入金额不同的余额修改成功
                        {
                            Response.Redirect("Detail_Income.aspx");
                        }
                        else//修改前后账户类型相同，账户相同，收入金额不同的余额修改失败
                        {
                            ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                        }
                    }
                    else//修改前后账户类型相同，账户相同，收入金额相同的，账户余额不同做任何操作，直接跳转到收入明细页
                    {
                        Response.Redirect("Detail_Income.aspx");
                    }
                }
                else//修改前后账户类型不同或账户id不同
                {
                    int flagBefore = 0;//修改前的账户余额是否修改成功的标志
                    if (accountTypeIdBefore == 1)//修改前现金账户
                    {
                        flagBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(incomeMoneyBefore) + " WHERE CashAccountId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 2)//修改前信用卡(CardArrears:欠款金额，所以支出是“+”，收入是“-”)
                    {
                        flagBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(incomeMoneyBefore) + " WHERE CreditCardId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 3)//修改前储蓄卡
                    {
                        flagBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(incomeMoneyBefore) + " WHERE SavingsCardId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 4)//修改前网上支付
                    {
                        flagBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(incomeMoneyBefore) + " WHERE OnlinePayId=" + accountIdBefore + "", "constring");
                    }
                    if (flagBefore > 0)//修改前的账户余额修改成功
                    {
                        int flagAfter = 0;//修改后的账户余额是否修改成功的标志
                        if (accountTypeId == 1)//现金账户
                        {
                            flagAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + " WHERE CashAccountId=" + accountId + "", "constring");
                        }
                        else if (accountTypeId == 2)//信用卡(CardArrears:欠款金额，所以支出是“+”，收入是“-”)
                        {
                            flagAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + " WHERE CreditCardId=" + accountId + "", "constring");
                        }
                        else if (accountTypeId == 3)//储蓄卡
                        {
                            flagAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + " WHERE SavingsCardId=" + accountId + "", "constring");
                        }
                        else if (accountTypeId == 4)//网上支付
                        {
                            flagAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + ConvertHelper.GetDecimal(txtIncomeMoney.Text.Trim()) + " WHERE OnlinePayId=" + accountId + "", "constring");
                        }
                        if (flagAfter > 0)//修改后的账户余额修改成功
                        {
                            Response.Redirect("Detail_Income.aspx");
                        }
                        else
                        {
                            ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
                        }
                    }
                    else//修改前的账户余额修改失败
                    {
                        ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
                    }
                }
            }
            else//修改收入记录失败
            {
                ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)//取消事件
    {
        Response.Redirect("Detail_Income.aspx");
    }
}