﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

public partial class Account_Account_Cash : PageBase
{
    private static int currentPageNum = 1;//当前页数
    private static int pageCount = 1;//总页数
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.Page.IsPostBack)
        {
            pageCount = GetPageCount();//总页数
            spanPageCount.InnerHtml = ConvertHelper.GetString(pageCount);//总页数
            BindrptCashAccount();
        }
    }
    #region 功能列表
    protected void btnAllAccount_Click(object sender, EventArgs e)//全部账户
    {
        Response.Redirect("Account.aspx");
    }
    protected void btnCashAccount_Click(object sender, EventArgs e)//现金账户
    {
        Response.Redirect("Account_Cash.aspx");
    }
    protected void btnCreditCard_Click(object sender, EventArgs e)//信用卡账户
    {
        Response.Redirect("Account_CreditCard.aspx");
    }
    protected void btnSavingsCard_Click(object sender, EventArgs e)//储蓄卡账户
    {
        Response.Redirect("Account_SavingsCard.aspx");
    }
    protected void btnOnlinPay_Click(object sender, EventArgs e)//网上支付
    {
        Response.Redirect("Account_OnlinePay.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷账户
    {
        Response.Redirect("Account_Loan.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定现金账户rptCashAccount
    /// </summary>
    /// <param name="sql">sql语句</param>
    public void BindrptCashAccount()
    {
        SetStrWhere();
        ControlHelper.BindRepeater(this.rptCashAccount, "constring", StrWhere + "AND Row BETWEEN (" + currentPageNum + "-1)*15+1 AND " + currentPageNum + "*15 ");
    }
    //现金账户ItemCommand事件
    protected void rptCashAccount_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int cashAccountid = ConvertHelper.GetInteger((e.Item.FindControl("hfCashAccountId") as HiddenField).Value);//现金账户id
        if (e.CommandName == "edit")//现金账户编辑
        {
            Response.Redirect("CashAccountInfo.aspx?caid=" + cashAccountid + "");
        }
        else if (e.CommandName == "block")//现金账户的停用与恢复
        {
            int state = ConvertHelper.GetInteger((e.Item.FindControl("hfCashBlockState") as HiddenField).Value);//现金账户的停用状态（0-已停用，1-未停用）
            if (state > 0)//未停用的账户
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET State=0 WHERE CashAccountId=" + cashAccountid + "", "constring");
                if (flag > 0)
                {
                    BindrptCashAccount();
                    (e.Item.FindControl("lbtnBlockCash") as LinkButton).Text = "恢复";//停用按钮变为恢复按钮
                    (e.Item.FindControl("lbtnEditCash") as LinkButton).Visible = false;//编辑不可用
                }
                else
                {
                    ScriptHelper.AlertMessage(this.Page, "停用失败，请联系管理员！");
                }
            }
            else//已停用的账户
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET State=1 WHERE CashAccountId=" + cashAccountid + "", "constring");
                if (flag > 0)
                {
                    BindrptCashAccount();
                    (e.Item.FindControl("lbtnBlockCash") as LinkButton).Text = "停用";//恢复按钮变为停用按钮
                    (e.Item.FindControl("lbtnEditCash") as LinkButton).Visible = true;//编辑可用
                }
                else
                {
                    ScriptHelper.AlertMessage(this.Page, "恢复失败，请联系管理员！");
                }
            }
        }
    }
    //现金账户ItemDateBound事件
    protected void rptCashAccount_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        int cashAccountid = ConvertHelper.GetInteger((e.Item.FindControl("hfCashAccountId") as HiddenField).Value);//现金账户id
        int state = ConvertHelper.GetInteger((e.Item.FindControl("hfCashBlockState") as HiddenField).Value);//现金账户的停用状态（0-已停用，1-未停用）
        if (state > 0)//未停用的现金账户
        {
            (e.Item.FindControl("lbtnBlockCash") as LinkButton).Text = "停用";//停用按钮
            (e.Item.FindControl("lbtnEditCash") as LinkButton).Visible = true;//编辑可用
        }
        else
        {
            (e.Item.FindControl("lbtnBlockCash") as LinkButton).Text = "恢复";//恢复按钮
            (e.Item.FindControl("lbtnEditCash") as LinkButton).Visible = false;//编辑不可用
        }
    }
    #region 分页
    #region 获取分页总页数
    /// <summary>
    /// 获取分页总页数
    /// </summary>
    /// <returns></returns>
    public int GetPageCount()
    {
        int pagecount = 0;//总页数
        SetStrWhere();
        DataSet ds = SqlHelper.GetDataSet(StrWhere, "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            int loanAccountCount = ConvertHelper.GetInteger(ds.Tables[0].Rows.Count);//借贷用户总个数
            if (loanAccountCount % 15 == 0)
            {
                pagecount = loanAccountCount / 15;
            }
            else
            {
                pagecount = loanAccountCount / 15 + 1;
            }
        }
        else
        {
            pagecount = 1;
        }
        return pagecount;
    }
    #endregion
    #region 首页
    protected void lbtnPageFirst_Click(object sender, EventArgs e)//首页
    {
        currentPageNum = 1;
        BindrptCashAccount();
        spanPageCurrent.InnerHtml = "1";//当前页为1
    }
    #endregion
    #region 上页
    protected void lbtnPageUp_Click(object sender, EventArgs e)//上页
    {
        if (spanPageCurrent.InnerHtml != "1")//不是首页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) - 1;
            BindrptCashAccount();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 下页
    protected void lbtnPageDown_Click(object sender, EventArgs e)//下页
    {
        if (spanPageCurrent.InnerHtml != ConvertHelper.GetString(pageCount))//不是尾页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) + 1;
            BindrptCashAccount();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 末页
    protected void lbtnPageLast_Click(object sender, EventArgs e)//末页
    {
        currentPageNum = GetPageCount();
        BindrptCashAccount();
        spanPageCurrent.InnerHtml = ConvertHelper.GetString(pageCount);//当前页等于总页数
    }
    #endregion
    #endregion
    #region 查询sql语句属性
    /// <summary>
    /// 查询sql语句属性
    /// </summary>
    public string StrWhere
    {
        get { return Convert.ToString(ViewState["StrWhere"]); }
        set { ViewState["StrWhere"] = value; }
    }
    /// <summary>
    /// 修改sql语句属性的方法
    /// </summary>
    public void SetStrWhere()
    {
        StringBuilder strb = new StringBuilder();
        strb.Append("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY CreateTime) AS Row,CashAccountId,CashAccountName,CashRemainder,State FROM dbo.tabA_Account_Cash) AS temptable  WHERE 1=1 ");
        //if (uclBankCard.BankCardID != 0)//查询事件中的银行卡
        //{
        //    strb.Append("AND BankCardID=" + uclBankCard.BankCardID + " ");//银行卡id
        //}
        //else if (!string.IsNullOrEmpty(Request["BankId"]))//从银行卡列表页点击查看明细跳转到明细页面（即本页面）
        //{
        //    strb.Append("AND BankCardID=" + Request["BankId"] + " ");//银行卡id
        //}
        //if (!string.IsNullOrEmpty(txtCardNumber.Text.Trim()))
        //{
        //    strb.Append("AND BankCardNumber like '%" + txtCardNumber.Text.Trim() + "%' ");//银行卡号（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtHeader.Text.Trim()))
        //{
        //    strb.Append("AND Header like '%" + txtHeader.Text.Trim() + "%' ");//户主名（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtOther.Text.Trim()))
        //{
        //    strb.Append("AND OtherName like '%" + txtOther.Text.Trim() + "%'");//交易对方（模糊查询）
        //}
        //strb.Append(string.Format(timewhere.WhereString, " a.CreateTime"));
        StrWhere = strb.ToString();
    }
    #endregion
    protected void btnAddAccount_Click(object sender, EventArgs e)//新增（现金账户）
    {
        Response.Redirect("CashAccountInfo.aspx");
    }
}