﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Account_CashAccountInfo : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindPage();
        }
    }
    #region 功能列表
    protected void btnAllAccount_Click(object sender, EventArgs e)//全部账户
    {
        Response.Redirect("Account.aspx");
    }
    protected void btnCashAccount_Click(object sender, EventArgs e)//现金账户
    {
        Response.Redirect("Account_Cash.aspx");
    }
    protected void btnCreditCard_Click(object sender, EventArgs e)//信用卡账户
    {
        Response.Redirect("Account_CreditCard.aspx");
    }
    protected void btnSavingsCard_Click(object sender, EventArgs e)//储蓄卡账户
    {
        Response.Redirect("Account_SavingsCard.aspx");
    }
    protected void btnOnlinPay_Click(object sender, EventArgs e)//网上支付
    {
        Response.Redirect("Account_OnlinePay.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷账户
    {
        Response.Redirect("Account_Loan.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定现金账户页面信息
    /// </summary>
    public void BindPage()
    {
        if (!string.IsNullOrEmpty(Request["caid"]))
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT CashAccountName,CashRemainder,CashRemarks FROM dbo.tabA_Account_Cash WHERE CashAccountId="+ConvertHelper.GetInteger(Request["caid"])+" AND State=1", "constring");
            if(ds.Tables[0].Rows.Count>0)
            {
                txtCashAccountName.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CashAccountName"]);//现金账户名称
                txtCashRemainder.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CashRemainder"]);//现金账户余额
                txtCashRemarks.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CashRemarks"]);//现金用户备注
            }
        }
    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request["caid"]))//修改现金账户
        {
            int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashAccountName='" + txtCashAccountName.Text.Trim() + "',CashRemainder='" + txtCashRemainder.Text.Trim() + "',CashRemarks='" + txtCashRemarks.Text.Trim() + "' WHERE CashAccountId=" + ConvertHelper.GetInteger(Request["caid"]) + "", "constring");
            if (flag > 0)
            {
                Response.Redirect("Account_Cash.aspx");
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
            }
        }
        else//添加现金账户
        {
            int flag = SqlHelper.Operation("INSERT INTO dbo.tabA_Account_Cash(CashAccountName,CashRemainder,CashRemarks,CreateTime) VALUES('"+txtCashAccountName.Text.Trim()+"',"+ConvertHelper.GetDecimal(txtCashRemainder.Text.Trim())+",'"+txtCashRemarks.Text.Trim()+"','"+System.DateTime.Now+"')", "constring");
            if (flag > 0)
            {
                Response.Redirect("Account_Cash.aspx");
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page, "添加失败，请联系管理员！");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)//取消事件
    {
        Response.Redirect("Account_Cash.aspx");
    }
}