﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

public partial class PowerManage_PowerManage : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindPage();
            BindCheckBox();
        }
    }
    #region 绑定模块和子模块
    /// <summary>
    /// 绑定模块和子模块
    /// </summary>
    public void BindPage()
    {
        BindRptMainModule();
        BindRptSubModule();
        if(!string.IsNullOrEmpty(Request["pid"]))
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT WorkId FROM dbo.tabP_Personnel WHERE Pid="+ConvertHelper.GetInteger(Request["pid"])+"","constring");
            if(ds.Tables[0].Rows.Count>0)
            {//超级管理员模块子模块全部选中且不可操作
                if (ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["WorkId"])==1)//超级管理员
                {
                    for (int i = 0; i < rptMainModule.Items.Count;i++ )//模块全选中，并不可操作
                    {
                        (rptMainModule.Items[i].FindControl("chkMainItem") as CheckBox).Checked = true;
                        (rptMainModule.Items[i].FindControl("chkMainItem") as CheckBox).Enabled = false;
                    }
                    for (int j = 0; j < rptSubModule.Items.Count;j++ )//子模块全选中，并不可操作
                    {
                        (rptSubModule.Items[j].FindControl("chkSubItem") as CheckBox).Checked = true;
                        (rptSubModule.Items[j].FindControl("chkSubItem") as CheckBox).Enabled = false;
                    }
                }
            }
        }
    }
    /// <summary>
    /// 绑定模块rptMainModule
    /// </summary>
    public void BindRptMainModule()
    {
        ControlHelper.BindRepeater(this.rptMainModule, "constring", "SELECT ModuleId,ModuleName FROM dbo.tabF_Module WHERE State=1");
    }
    /// <summary>
    /// 绑定子模块rptSubModule
    /// </summary>
    public void BindRptSubModule()
    {
        ControlHelper.BindRepeater(this.rptSubModule, "constring", "SELECT FunctionId,ModuleId,ModuleName,FunctionName,State,ModuleState FROM dbo.V_Module WHERE State=1 AND ModuleState=1");
    }
    #endregion
    #region 勾选模块全选子模块，取消模块则子模块不可操作
    protected void chkMainItem_Onclick(object sender, EventArgs e)
    {
        for (int i = 0; i < rptMainModule.Items.Count;i++ )
        {
            int mainModuleId = ConvertHelper.GetInteger((rptMainModule.Items[i].FindControl("hdModuleId") as HiddenField).Value);//模块id
            if ((rptMainModule.Items[i].FindControl("chkMainItem") as CheckBox).Checked)//模块选中则选中子模块，子模块可操作
            {
                #region 模块选中则全选子模块，子模块可操作
                for (int k = 0; k < rptSubModule.Items.Count; k++)
                {
                    if (ConvertHelper.GetInteger((rptSubModule.Items[k].FindControl("hdModuleId") as HiddenField).Value) == mainModuleId)//子模块属于该模块的
                    {
                        (rptSubModule.Items[k].FindControl("chkSubItem") as CheckBox).Checked = true;//子模块选中
                        (rptSubModule.Items[k].FindControl("chkSubItem") as CheckBox).Enabled = true;//子模块可操作
                    }
                }
                #endregion
            }
            else//模块取消选中则子模块不选中，且子模块不可操作
            {
                #region 模块取消选中则子模块不选中，且子模块不可操作
                for (int k = 0; k < rptSubModule.Items.Count; k++)
                {
                    if (ConvertHelper.GetInteger((rptSubModule.Items[k].FindControl("hdModuleId") as HiddenField).Value) == mainModuleId)//子模块属于该模块的
                    {
                        (rptSubModule.Items[k].FindControl("chkSubItem") as CheckBox).Checked = false;//子模块不选中
                        (rptSubModule.Items[k].FindControl("chkSubItem") as CheckBox).Enabled = false;//子模块不可操作
                    }
                }
                #endregion
            }
        }
    }
    #endregion
    #region 绑定CheckBox
    /// <summary>
    /// 绑定CheckBox
    /// </summary>
    public void BindCheckBox()
    {
        if (!string.IsNullOrEmpty(Request["pid"]))//如果用户管理页面传的用户id（pid）不为空时
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT MainModuleIdString,SubModuleIdString FROM tabP_Personnel WHERE Pid="+ConvertHelper.GetInteger(Request["pid"])+" AND State=1", "constring");
            if(ds.Tables[0].Rows.Count>0)
            {
                //模块和子模块都不为空时
                if ((string.IsNullOrEmpty(ConvertHelper.GetString(ds.Tables[0].Rows[0]["MainModuleIdString"])) || string.IsNullOrEmpty(ConvertHelper.GetString(ds.Tables[0].Rows[0]["SubModuleIdString"])))==false)
                {
                    #region 绑定模块CheckBox
                    string[] MainModuleId = ConvertHelper.GetString(ds.Tables[0].Rows[0]["MainModuleIdString"]).Split(',');//模块id数组
                    for (int i = 0; i < rptMainModule.Items.Count;i++ )//rptMainModule循环(模块)
                    {
                        for (int j = 0; j < MainModuleId.Length;j++ )//MainModuleId循环（模块）
                        {
                            if ((rptMainModule.Items[i].FindControl("hdModuleId") as HiddenField).Value==MainModuleId[j])//rptMainModule中ModuleId等于数据库中存的模块id时将rptMainModule中的该行选中
                            {
                                (rptMainModule.Items[i].FindControl("chkMainItem") as CheckBox).Checked = true;
                            }
                        }
                    }
                    #endregion
                    #region 绑定子模块CheckBox
                    string[] SubModuleId = ConvertHelper.GetString(ds.Tables[0].Rows[0]["SubModuleIdString"]).Split(',');//子模块id数组
                    for (int k = 0; k < rptSubModule.Items.Count;k++ )//rptSubModule循环（子模块）
                    {
                        for (int n = 0; n < SubModuleId.Length; n++)//SubModuleId循环（子模块）
                        {
                            if ((rptSubModule.Items[k].FindControl("hdFunctionId") as HiddenField).Value==SubModuleId[n])//rptSubModule中SubModuleId等于数据库中存的id时将rptSubModule中的该行选中
                            {
                                (rptSubModule.Items[k].FindControl("chkSubItem") as CheckBox).Checked = true;
                            }
                        }
                    }
                    #endregion
                }
            }
        }
    }
    #endregion 
    protected void btnPowerControl_Click(object sender, EventArgs e)
    {
        StringBuilder stbMainModuleId = new StringBuilder();//修改后的模块id字符串（如：1,2,3）
        StringBuilder stbSubModuleId = new StringBuilder();//修改后的子模块id字符串（如：1,2,3）
        for (int i = 0; i < rptMainModule.Items.Count;i++ )
        {
            if ((rptMainModule.Items[i].FindControl("chkMainItem") as CheckBox).Checked)
            {
                stbMainModuleId.Append(ConvertHelper.GetString((rptMainModule.Items[i].FindControl("hdModuleId") as HiddenField).Value));//选中的模块id
                stbMainModuleId.Append(",");
            }
        }
        if (string.IsNullOrEmpty(ConvertHelper.GetString(stbMainModuleId)))//模块没有选中的（则子模块存为空）
        {
            ScriptHelper.AlertMessage(this.Page, "您没有选中项，请选中后再提交！");
        }
        else
        {
            for (int j = 0; j < rptSubModule.Items.Count;j++ )
            {
                if ((rptSubModule.Items[j].FindControl("chkSubItem") as CheckBox).Checked)
                {
                    stbSubModuleId.Append(ConvertHelper.GetString((rptSubModule.Items[j].FindControl("hdFunctionId") as HiddenField).Value));//选中的子模块id
                    stbSubModuleId.Append(",");
                }
            }
            if (string.IsNullOrEmpty(ConvertHelper.GetString(stbSubModuleId)))//子模块没有选中的
            {
                ScriptHelper.AlertMessage(this.Page, "您没有选中项，请选中后再提交！");
            }
            else
            {
                string mainModuleId = ConvertHelper.GetString(stbMainModuleId).TrimEnd(',');//模块字符串
                string subModuleId = ConvertHelper.GetString(stbSubModuleId).TrimEnd(',');//子模块字符串
                int flag = SqlHelper.Operation("UPDATE dbo.tabP_Personnel SET MainModuleIdString='" + mainModuleId + "',SubModuleIdString='" + subModuleId + "' WHERE Pid="+ConvertHelper.GetInteger(Request["pid"])+"", "constring");
                if (flag > 0)
                {
                    Response.Redirect("../personal/Staffmanagemen.aspx");
                }
                else
                {
                    ScriptHelper.AlertMessage(this.Page,"修改权限失败，请联系管理员！");
                }
            }
        }
    }
}