﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Ucontrol_work : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindDdlDepartment();
            if(DepartmentID!=0)
            {
                ddlDepartment.SelectedValue = hdDepartmentId.Value;
            }
            BindDdlWork();
            if(WorkID!=0)
            {
                ddlWork.SelectedValue = hdWorkId.Value;
            }
            BindDdlPersonnel();
            if(PersonnelID!=0)
            {
                ddlPersonnel.SelectedValue = hdPersonnelId.Value;
            }
        }
    }
    #region //信用卡异步页路径属性
    /// <summary>
    /// 信用卡异步页路径属性
    /// </summary>
    public string OpenAjaxUrl
    {
        get
        {
            return ConvertHelper.GetString(ViewState["OpenAjaxUrl"]);
        }
        set
        {
            ViewState["OpenAjaxUrl"] = value;
        }
    }
    #endregion
    #region 绑定部门
    /// <summary>
    /// 绑定部门ddlDepartment
    /// </summary>
    public void BindDdlDepartment()
    {
        ControlHelper.BindDropDownList(this.ddlDepartment, "constring", "SELECT DepartmentId,DepartmentName FROM dbo.tabP_Department WHERE State=1", "DepartmentId", "DepartmentName");
        ddlDepartment.Items.Insert(0,new ListItem("请选择部门","0"));
    }
    #endregion
    #region 绑定职位
    /// <summary>
    /// 绑定职位ddlWork
    /// </summary>
    public void BindDdlWork()
    {
        ControlHelper.BindDropDownList(this.ddlWork, "constring", "SELECT WorkId,WorkName FROM dbo.tabP_Work WHERE State=1 AND DepartmentId="+ddlDepartment.SelectedValue+"", "WorkId", "WorkName");
        ddlWork.Items.Insert(0,new ListItem("请选择职位","0"));
    }
    #endregion
    #region 绑定人员
    /// <summary>
    /// 绑定人员
    /// </summary>
    public void BindDdlPersonnel()
    {
        ControlHelper.BindDropDownList(this.ddlPersonnel, "constring", "SELECT Pid,PersonnelName FROM dbo.tabP_Personnel WHERE State=1 AND WorkId="+ddlWork.SelectedValue+"", "Pid", "PersonnelName");
        ddlPersonnel.Items.Insert(0,new ListItem("请选择人员","0"));
    }
    #endregion 
    #region 属性
    #region DepartmentID属性：部门id
    /// <summary>
    /// DepartmentID属性：部门id
    /// </summary>
    public int DepartmentID
    {
        get 
        {
            return ConvertHelper.GetInteger(hdDepartmentId.Value);
        }
        set 
        {
            hdDepartmentId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #region WorkID属性：职位id
    /// <summary>
    /// WorkID属性：职位id
    /// </summary>
    public int WorkID
    {
        get 
        {
            return ConvertHelper.GetInteger(hdWorkId.Value);
        }
        set 
        {
            if(DepartmentID==0)
            {
                DepartmentID = GetDepartmentIdByWorkId(value);
            }
            hdWorkId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion 
    public int PersonnelID
    {
        get 
        {
            return ConvertHelper.GetInteger(hdPersonnelId.Value);
        }
        set
        {
            if(DepartmentID==0)
            {
                DepartmentID = GetDepartmentIdByWorkId(GetWorkIdByPersonnelId(value));
            }
            if(WorkID==0)
            {
                WorkID = GetWorkIdByPersonnelId(value);
            }
            hdPersonnelId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #region 由职位id获取部门id
    /// <summary>
    /// 由职位id获取部门id
    /// </summary>
    /// <param name="WorkId">职位id</param>
    /// <returns>部门id</returns>
    public int GetDepartmentIdByWorkId(int WorkId)
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT DepartmentId FROM dbo.tabP_Work WHERE WorkId="+WorkId+" AND State=1", "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            return ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["DepartmentId"]);
        }
        else
        {
            return 0;
        }
    }
    #endregion
    #region
    /// <summary>
    /// 由人员id获取职位id
    /// </summary>
    /// <param name="PersonnelId">人员id</param>
    /// <returns>职位id</returns>
    public int GetWorkIdByPersonnelId(int PersonnelId)
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT WorkId FROM dbo.tabP_Personnel WHERE Pid="+PersonnelId+"", "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            return ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["WorkId"]);
        }
        else
        {
            return 0;
        }
    }
    #endregion
}