﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;
using System.Configuration;

public partial class goods_goodsrkcx : PageBase
{
    SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["constring"].ConnectionString);


    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {


            string strtime2 = DateTime.Now.ToString("yyyy-MM-dd");
            string strtime1 = DateTime.Now.ToString("yyyy-MM");

            strtime1 = strtime1 + "-01";
            TextBox1.Text = strtime1;
            TextBox2.Text = strtime2;
            DataBindRePeat();
        }


    }
    private void DataBindRePeat()
    {

        int temp1 = Convert.ToInt32(lblCurrentPage.Text);
        List<goods> Stus = GetTestData();
        Stus = Stus.Skip((temp1 - 1) * 15).Take(15).ToList();
        this.Repeater1.DataSource = Stus;
        this.Repeater1.DataBind();

        int count;
        List<goods> Stu = GetTestData();
        count = ConvertHelper.GetInteger(Stu.Count());

        int j = count / 15;
        int i = count % 15;
        if (j >= 1)
        {
            if (i > 0)
            {
                j = j + 1;
            }

        }
        else
        {
            j = 1;

        }

        lblPageCount.Text = j.ToString();
    }
    private List<goods> GetTestData()
    {
        string str1, str2;
        DateTime adt1, adt2;

        str1 = TextBox1.Text + " 00:00:00";

        str2 = TextBox2.Text + " 23:59:59";

        adt1 = Convert.ToDateTime(str1);
        adt2 = Convert.ToDateTime(str2);
        List<goods> stus = new List<goods>();

        try
        {
            string sql = " select v_rkcxhz.gid,v_rkcxhz.GoodsName,v_rkcxhz.goodprice,sum(v_rkcxhz.rksl)as rksl FROM [v_rkcxhz] where date >='" + adt1 + "' and date <= '" + adt2 + "' group by v_rkcxhz.gid,v_rkcxhz.GoodsName,v_rkcxhz.goodprice order by rksl asc ";
            conn.Open();
            SqlCommand cmd = new SqlCommand(sql, conn);
            using (SqlDataReader dr = cmd.ExecuteReader())
            {
                while (dr.Read())
                {
                    goods s = new goods();

                    s.gid = ConvertHelper.GetInteger(dr["gid"]);
                    s.GoodsName = ConvertHelper.GetString(dr["GoodsName"]);
                    s.goodprice = ConvertHelper.GetDecimal(dr["goodprice"]);
                    s.rksl = ConvertHelper.GetInteger(dr["rksl"]);

                    //s.state = ConvertHelper.GetInteger(dr["state"]);

                    stus.Add(s);
                }
            }
        }
        catch (Exception)
        {

            throw;
        }
        finally
        {
            conn.Close();
        }
        return stus;
    }
    public class goods
    {
        public int gid { get; set; }
        public string GoodsName { get; set; }
        public decimal goodprice { get; set; }
        public int rksl { get; set; }
    }
    protected void Btncx_Click(object sender, EventArgs e)
    {
        DataBindRePeat();
    }
    protected void Button4_Click(object sender, EventArgs e)
    {
        List<goods> Stus = GetTestData();

        Stus = Stus.Skip(0).Take(15).ToList();

        this.Repeater1.DataSource = Stus;
        this.Repeater1.DataBind();
        lblCurrentPage.Text = "1";
    }
    protected void Button6_Click(object sender, EventArgs e)
    {
        int temp = Convert.ToInt32(this.lblCurrentPage.Text);

        if (temp > 1)
        {
            List<goods> Stus = GetTestData();

            this.lblCurrentPage.Text = (--temp).ToString();

            Stus = Stus.Skip((temp - 1) * 15).Take(15).ToList();

            this.Repeater1.DataSource = Stus;
            this.Repeater1.DataBind();
        }
    }
    protected void Button7_Click(object sender, EventArgs e)
    {
        int temp = Convert.ToInt32(this.lblCurrentPage.Text);

        if (temp < Convert.ToInt32(lblPageCount.Text))
        {
            List<goods> Stus = GetTestData();
            this.lblCurrentPage.Text = (++temp).ToString();

            Stus = Stus.Skip((temp - 1) * 15).Take(15).ToList();

            this.Repeater1.DataSource = Stus;
            this.Repeater1.DataBind();
        }
    }
    protected void Button8_Click(object sender, EventArgs e)
    {
        int intendpage = Convert.ToInt32(lblPageCount.Text);

        List<goods> Stus = GetTestData();

        Stus = Stus.Skip((intendpage - 1) * 15).Take(15).ToList();

        this.Repeater1.DataSource = Stus;
        this.Repeater1.DataBind();
        lblCurrentPage.Text = lblPageCount.Text;
    }
    protected void Repeater1_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        string strgid = e.CommandArgument.ToString();
        string adt1 = TextBox1.Text.ToString();
        string adt2 = TextBox2.Text.ToString();
        string strname = (e.Item.FindControl("HiddenField1") as HiddenField).Value;
        if (e.CommandName == "cxmx")
        {
            string url = "goodsrkcxmx.aspx?&gid=" + strgid + "&strname=" + strname + "&adt1=" + adt1 + "&adt2=" + adt2;
     
            Response.Redirect(url);
        }
    }
}