﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;

public partial class rptList_rpt_ExpenditureAccount : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            GetExpenditureMoneyCount();
            BindRptEAccountMoneyCount();
        }
    }
    #region 功能列表
    protected void btnRptExpenditureType_Click(object sender, EventArgs e)//类别支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureType.aspx");
    }
    protected void btnRptExpenditureAccount_Click(object sender, EventArgs e)//账户支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureAccount.aspx");
    }
    protected void btnRptExpenditureSeller_Click(object sender, EventArgs e)//商家支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureSeller.aspx");
    }
    protected void btnRptExpenditureProject_Click(object sender, EventArgs e)//项目支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureProject.aspx");
    }
    protected void btnRptIncomeType_Click(object sender, EventArgs e)//类别收入
    {
        Response.Redirect("../rptList/rpt_IncomeType.aspx");
    }
    protected void btnRptIncomeAccount_Click(object sender, EventArgs e)//账户收入
    {
        Response.Redirect("../rptList/rpt_IncomeAccount.aspx");
    }
    protected void btnRptIncomeSeller_Click(object sender, EventArgs e)//付款方收入
    {
        Response.Redirect("../rptList/rpt_IncomeSeller.aspx");
    }
    protected void btnRptIncomeProject_Click(object sender, EventArgs e)//项目收入
    {
        Response.Redirect("../rptList/rpt_IncomeProject.aspx");
    }
    protected void btnRptBalance_Click(object sender, EventArgs e)//余额状况
    {
        Response.Redirect("../rptList/rpt_Balance.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定支出总金额spanExpenditureMoney
    /// </summary>
    public void GetExpenditureMoneyCount()
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT SUM(RExpenditureMoney) AS ExpenditureMoneyCount FROM dbo.tabA_Record_Expenditure WHERE State = 1", "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            spanExpenditureMoney.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["ExpenditureMoneyCount"]);//支出总金额
        }
    }
    /// <summary>
    /// 绑定支出账户报表
    /// </summary>
    public void BindRptEAccountMoneyCount()
    {
        ControlHelper.BindRepeater(this.rptEAccountMoneyCount, "constring", "SELECT REAccountTypeId,EAccountMoney,EAccountRate,CashAccountName,CreditCardName,SavingsCardName,OnlinePayName FROM dbo.V_List_ExpenditureAccount ORDER BY REAccountTypeId,REAccountId");
    }
    protected void rptEAccountMoneyCount_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        //绑定百分比
        (e.Item.FindControl("spanEAccountRate") as HtmlGenericControl).InnerHtml = ConvertHelper.GetString(ConvertHelper.GetDouble(ConvertHelper.GetDouble((e.Item.FindControl("spanEAccountRate") as HtmlGenericControl).InnerHtml).ToString("#0.0000")) * 100);
        #region 绑定账户名
        int accountTypeId = ConvertHelper.GetInteger((e.Item.FindControl("hfREAccountTypeId") as HiddenField).Value);//账户类型id（1-现金，2-信用卡，3-储蓄卡，4-网上支付）
        if(accountTypeId==1)//现金
        {
            (e.Item.FindControl("spanAcccountName") as HtmlGenericControl).InnerHtml =(e.Item.FindControl("hfCashAccountName") as HiddenField).Value;
        }
        else if(accountTypeId==2)//信用卡
        {
            (e.Item.FindControl("spanAcccountName") as HtmlGenericControl).InnerHtml = (e.Item.FindControl("hfCreditCardName") as HiddenField).Value;
        }
        else if (accountTypeId == 3)//储蓄卡
        {
            (e.Item.FindControl("spanAcccountName") as HtmlGenericControl).InnerHtml = (e.Item.FindControl("hfSavingsCardName") as HiddenField).Value;
        }
        else if (accountTypeId == 4)//网上支付
        {
            (e.Item.FindControl("spanAcccountName") as HtmlGenericControl).InnerHtml = (e.Item.FindControl("hfOnlinePayName") as HiddenField).Value;
        }
        #endregion
    }
}