﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Collections;
using System.Web.UI.WebControls;
using System.Data;
using System.Web.UI.HtmlControls;

public partial class rptList_rpt_ExpenditureType : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindRptETypeMoneyCount();
            GetExpenditureMoneyCount();
        }
    }
    #region 功能列表
    protected void btnRptExpenditureType_Click(object sender, EventArgs e)//类别支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureType.aspx");
    }
    protected void btnRptExpenditureAccount_Click(object sender, EventArgs e)//账户支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureAccount.aspx");
    }
    protected void btnRptExpenditureSeller_Click(object sender, EventArgs e)//商家支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureSeller.aspx");
    }
    protected void btnRptExpenditureProject_Click(object sender, EventArgs e)//项目支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureProject.aspx");
    }
    protected void btnRptIncomeType_Click(object sender, EventArgs e)//类别收入
    {
        Response.Redirect("../rptList/rpt_IncomeType.aspx");
    }
    protected void btnRptIncomeAccount_Click(object sender, EventArgs e)//账户收入
    {
        Response.Redirect("../rptList/rpt_IncomeAccount.aspx");
    }
    protected void btnRptIncomeSeller_Click(object sender, EventArgs e)//付款方收入
    {
        Response.Redirect("../rptList/rpt_IncomeSeller.aspx");
    }
    protected void btnRptIncomeProject_Click(object sender, EventArgs e)//项目收入
    {
        Response.Redirect("../rptList/rpt_IncomeProject.aspx");
    }
    protected void btnRptBalance_Click(object sender, EventArgs e)//余额状况
    {
        Response.Redirect("../rptList/rpt_Balance.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定支出总金额spanExpenditureMoney
    /// </summary>
    public void GetExpenditureMoneyCount()
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT SUM(RExpenditureMoney) AS ExpenditureMoneyCount FROM dbo.tabA_Record_Expenditure WHERE State = 1","constring");
        if(ds.Tables[0].Rows.Count>0)
        {
            spanExpenditureMoney.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["ExpenditureMoneyCount"]);//支出总金额
        }
    }
    /// <summary>
    /// 获取类别支出报表rptETypeMoneyCount
    /// </summary>
    public void BindRptETypeMoneyCount()
    {
        ControlHelper.BindRepeater(this.rptETypeMoneyCount, "constring", "SELECT ExpenditureTypeName,ExpenditureMoneySum,TypeRate FROM V_List_ExpenditureTypeCount");
    }
    protected void rptETypeMoneyCount_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        (e.Item.FindControl("spanTypeRate") as HtmlGenericControl).InnerHtml = ConvertHelper.GetString(ConvertHelper.GetDouble(ConvertHelper.GetDouble((e.Item.FindControl("spanTypeRate") as HtmlGenericControl).InnerHtml).ToString("#0.0000")) * 100);
    }
}