﻿using System;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Web;
//该源码首发自www.51aspx.com(５１ａsｐｘ．ｃｏｍ)

/// <summary>
///OleDbHelper 数据操作类(ACCESS数据库)
/// </summary>

namespace DbHelper
{
    public class OleDbHelper
    {
        public OleDbHelper() { }

        private static OleDbConnection Conn;
        private static OleDbCommand Cmd;
        private static OleDbDataAdapter Da;
        private static DataSet Ds;
        private static DataTable Dt;
        private static string strConn = "Provider=Microsoft.Jet.OleDb.4.0;Data Source="
        + System.Web.HttpContext.Current.Server.MapPath(ConfigurationManager.ConnectionStrings["Conn"].ToString());

        /* Web.Config配置
          <connectionStrings>
          <!--数据库连接字符-->
          <add name="ConnStr" connectionString="~/App_Data/Data.mdb"/>
          </connectionStrings>
        */

        /// <summary>
        /// 打开连接
        /// </summary>
        public static void Open()
        {
            Conn = new OleDbConnection();
            Cmd = new OleDbCommand();
            if (Conn.State.Equals(ConnectionState.Closed))
            {
                Conn.ConnectionString = strConn;
                Conn.Open();
            }
            Cmd.Connection = Conn;
        }


        /// <summary>
        /// 关闭连接
        /// </summary>
        public static void Close()
        {
            if (Conn.State.Equals(ConnectionState.Open))
            {
                Conn.Close();
                Conn.Dispose();
            }
        }

        /// <summary>
        /// 执行ExecuteNonQuery()
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <returns></returns>
        public static int ExecuteCmd(string sql)
        {
            try
            {
                Open();
                Cmd.CommandText = sql;
                return Cmd.ExecuteNonQuery();
            }
            catch (Exception e)
            {
                throw new Exception(e.Message, e);
            }
            finally
            {
                Close();
            }
        }


        /// <summary>
        /// DataSet类
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <returns></returns>
        public static DataSet GetDataSet(string sql)
        {
            try
            {
                Open();
                Cmd.CommandText = sql;
                Da = new OleDbDataAdapter();
                Da.SelectCommand = Cmd;
                Ds = new DataSet();
                Da.Fill(Ds);
                return Ds;
            }
            catch (Exception e)
            {
                throw new Exception(e.Message, e);
            }
            finally
            {
                Close();
            }
        }

        /// <summary>
        /// DataTable 类
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <returns></returns>
        public static DataTable GetDataTable(string sql)
        {
            try
            {
                Open();
                Cmd.CommandText = sql;
                Da = new OleDbDataAdapter();
                Da.SelectCommand = Cmd;
                Dt = new DataTable();
                Da.Fill(Dt);
                return Dt;
            }
            catch (Exception e)
            {
                throw new Exception(e.Message, e);
            }
            finally
            {
                Close();
            }
        }

        /// <summary>
        /// 执行 ExecuteScalar
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <returns></returns>
        public static int ExecuteScalar(string sql)
        {
            try
            {
                Open();
                Cmd.CommandText = sql;
                return (int)Cmd.ExecuteScalar();
            }
            catch (Exception e)
            {
                throw new Exception(e.Message, e);
            }
            finally
            {
                Close();
            }
        }
    }
}