﻿<%@ WebHandler Language="C#" Class="adminclient"%>
using System;
using System.Web;
using System.Web.SessionState;
public class adminclient : IHttpHandler, IRequiresSessionState
{
    private string _key;
    private string _vector;
    private string _nextClientUrl;

    public adminclient()
    {
        System.Xml.XmlDocument doc = HaiLi.IOUtility.ConfigFile.Read(System.Web.HttpContext.Current.Server.MapPath("") + "\\application.config");
        this._key = doc.GetElementsByTagName("adminserver").Item(0).Attributes["key"].Value;
        this._vector = doc.GetElementsByTagName("adminserver").Item(0).Attributes["vector"].Value;
        this._nextClientUrl = doc.GetElementsByTagName("adminserver").Item(0).Attributes["nextclienturl"].Value;
    }

    public void ProcessRequest(HttpContext context)
    {
        string backurl = context.Request.QueryString["backurl"];
        string action = context.Request.QueryString["_action"];
        if (action == "login")
        {
            string data = context.Request.QueryString["data"];
            string[] temp = HaiLi.Security.AESDecrypt(data, this._key, this._vector).Split(new char[] { ',' }, System.StringSplitOptions.RemoveEmptyEntries);
            if (temp == null || temp.Length < 3)
            {
                System.Web.HttpContext.Current.Response.Write("登陆失败,无法解析登陆数据,请先检查配置文件中的密钥是否正确");
                context.Response.End();
            }
            string accountName = temp[0];
            string loginCode = temp[1];
            System.DateTime date = System.DateTime.Parse(temp[2]);
            if (date.CompareTo(System.DateTime.Now.AddSeconds(-60)) < 0 && date.CompareTo(System.DateTime.Now.AddSeconds(60)) > 0)
            {
                if (string.IsNullOrEmpty(backurl) == false)
                {
                    context.Response.Redirect(backurl);
                }
                else
                {
                    System.Web.HttpContext.Current.Response.Write("登陆失败,相关数据过期");
                    context.Response.End();
                }
            }

            context.Session["adminserveraccountid"] = null;
            context.Session["adminserveraccountname"] = null;
            context.Response.Cookies.Remove("adminserveraccount");
            string[] host = context.Request.Url.Host.Split(new string[] { "." }, System.StringSplitOptions.RemoveEmptyEntries);
            System.Web.HttpCookie cookie = new System.Web.HttpCookie("adminserveraccount");
            cookie.Domain = context.Request.Url.Host != context.Request.UserHostAddress && host.Length > 1 ? "." + host[host.Length - 2] + "." + host[host.Length - 1] : "";
            cookie.Path = "/";
            cookie.Expires = System.DateTime.Now.AddDays(30);
            cookie.HttpOnly = true;
            cookie["data"] = HaiLi.Security.AESEncrypt(accountName + "," + loginCode, this._key, this._vector, true);
            context.Response.Cookies.Add(cookie);
            if (string.IsNullOrEmpty(this._nextClientUrl) == false)
            {
                context.Response.Redirect(this._nextClientUrl + "adminclient.ashx?_action=login&data=" + data + "&backurl=" + System.Web.HttpUtility.UrlEncode(backurl));
            }
            else
            {
                if (string.IsNullOrEmpty(backurl) == false)
                {
                    context.Response.Redirect(backurl);
                }
                else
                {
                    context.Response.End();
                }
            }
        }
        else if (action == "exit")
        {
            context.Session["adminserveraccountid"] = null;
            context.Session["adminserveraccountname"] = null;
            context.Response.Cookies.Remove("adminserveraccount");
            string[] host = context.Request.Url.Host.Split(new string[] { "." }, System.StringSplitOptions.RemoveEmptyEntries);
            System.Web.HttpCookie cookie = new System.Web.HttpCookie("adminserveraccount");
            cookie.Domain = context.Request.Url.Host != context.Request.UserHostAddress && host.Length > 1 ? "." + host[host.Length - 2] + "." + host[host.Length - 1] : "";
            cookie.Path = "/";
            cookie.Expires = System.DateTime.Now.AddDays(1);
            cookie.HttpOnly = true;
            context.Response.Cookies.Add(cookie);
            if (string.IsNullOrEmpty(this._nextClientUrl) == false)
            {
                context.Response.Redirect(this._nextClientUrl + "adminclient.ashx?_action=exit&backurl=" + System.Web.HttpUtility.UrlEncode(backurl));
            }
            else
            {
                context.Response.Redirect(backurl);
            }
        }
    }

    public bool IsReusable
    {
        get
        {
            return true;
        }
    }
}