﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.OleDb;

/// <summary>
/// ConfigHelper 的摘要说明
/// </summary>
public class SqlHelper
{
	public SqlHelper()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}
    /// <summary>
    /// 连接串
    /// </summary>
    static string ConnectionString
    {
        get
        {

            string _connectionStringType = ConfigurationManager.AppSettings["ConnectionStringType"];
            string _connectionStringMDB = ConfigurationManager.AppSettings["ConnectionStringMDB"];
            string _connectionString = _connectionStringType + HttpContext.Current.Server.MapPath(_connectionStringMDB);
            string ConStringEncrypt = ConfigurationManager.AppSettings["ConStringEncrypt"];
            //if (ConStringEncrypt == "true")
            //{
            //    _connectionString = DESEncrypt.Decrypt(_connectionString);
            //}
            return _connectionString;
        }
    }

    /// <summary>
    /// 得到web.config里配置项的数据库连接字符串。
    /// </summary>
    /// <param name="configName"></param>
    /// <returns></returns>
    static string GetConnectionString(string configName)
    {
        string connectionString = ConfigurationManager.AppSettings[configName];
        string ConStringEncrypt = ConfigurationManager.AppSettings["ConStringEncrypt"];
        //if (ConStringEncrypt == "true")
        //{
        //    connectionString = DESEncrypt.Decrypt(connectionString);
        //}
        return connectionString;
    }

    /// <summary>
    /// 执行查询语句，返回OleDbDataReader ( 注意：调用该方法后，一定要对OleDbDataReader进行Close )
    /// </summary>
    /// <param name="strSQL">查询语句</param>
    /// <returns>OleDbDataReader</returns>
    public static OleDbDataReader ExecuteReader(string SQLString, params OleDbParameter[] cmdParms)
    {
        OleDbConnection connection = new OleDbConnection(ConnectionString);
        OleDbCommand cmd = new OleDbCommand();
        try
        {
            PrepareCommand(cmd, connection, null, SQLString, cmdParms);
            OleDbDataReader myReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
            cmd.Parameters.Clear();
            return myReader;
        }
        catch (OleDbException e)
        {
            throw e;
        }

    }
    /// <summary>
    /// 执行一条计算查询结果语句，返回查询结果（object）。
    /// </summary>
    /// <param name="SQLString">计算查询结果语句</param>
    /// <returns>查询结果（object）</returns>
    public static object GetSingle(string SQLString)
    {
        using (OleDbConnection connection = new OleDbConnection(ConnectionString))
        {
            using (OleDbCommand cmd = new OleDbCommand(SQLString, connection))
            {
                try
                {
                    connection.Open();
                    object obj = cmd.ExecuteScalar();
                    if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                    {
                        return null;
                    }
                    else
                    {
                        return obj;
                    }
                }
                catch (OleDbException e)
                {
                    connection.Close();
                    throw e;
                }
                finally
                {
                    cmd.Dispose();
                    connection.Close();
                }
            }
        }
    }
    /// <summary>
    /// 执行带一个存储过程参数的的SQL语句。
    /// </summary>
    /// <param name="SQLString">SQL语句</param>
    /// <param name="content">参数内容,比如一个字段是格式复杂的文章，有特殊符号，可以通过这个方式添加</param>
    /// <returns>影响的记录数</returns>
    public static int ExecuteSql(string SQLString, string content)
    {
        using (OleDbConnection connection = new OleDbConnection(ConnectionString))
        {
            OleDbCommand cmd = new OleDbCommand(SQLString, connection);
            OleDbParameter myParameter = new System.Data.OleDb.OleDbParameter("@text", OleDbType.VarChar,2000);
            myParameter.Value = content;
            cmd.Parameters.Add(myParameter);
            try
            {
                connection.Open();
                int rows = cmd.ExecuteNonQuery();
                return rows;
            }
            catch (OleDbException e)
            {
                throw e;
            }
            finally
            {
                cmd.Dispose();
                connection.Close();
            }
        }
    }

    ///// <summary>
    ///// 执行带一个存储过程参数的的SQL语句。
    ///// </summary>
    ///// <param name="SQLString">SQL语句</param>
    ///// <param name="content">参数内容,比如一个字段是格式复杂的文章，有特殊符号，可以通过这个方式添加</param>
    ///// <returns>影响的记录数</returns>
    //public static int ExecuteSql(string SQLString, string content)
    //{
    //    //using (OleDbConnection connection = new OleDbConnection(ConnectionString))
    //    //{
    //    //    OleDbCommand cmd = new OleDbCommand(SQLString, connection);
    //    //    //OleDbParameter myParameter = new System.Data.OleDb.OleDbParameter("@content", SqlDbType.NText);
    //    //    //myParameter.Value = content;
    //    //    //cmd.Parameters.Add(myParameter);
    //    //    try
    //    //    {
    //    //        connection.Open();
    //    //        int rows = cmd.ExecuteNonQuery();
    //    //        return rows;
    //    //    }
    //    //    catch (OleDbException e)
    //    //    {
    //    //        throw e;
    //    //    }
    //    //    finally
    //    //    {
    //    //        cmd.Dispose();
    //    //        connection.Close();
    //    //    }
    //    //}

    //    using (OleDbConnection connection = new OleDbConnection(ConnectionString))
    //    {
    //        using (OleDbCommand cmd = new OleDbCommand())
    //        {
    //            try
    //            {
    //                PrepareCommand(cmd, connection, null, SQLString, cmdParms);
    //                object obj = cmd.ExecuteScalar();
    //                cmd.Parameters.Clear();
    //                if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
    //                {
    //                    return null;
    //                }
    //                else
    //                {
    //                    return obj;
    //                }
    //            }
    //            catch (OleDbException e)
    //            {
    //                throw e;
    //            }
    //            finally
    //            {
    //                cmd.Dispose();
    //                connection.Close();
    //            }
    //        }
    //    }
    //}
    private static void PrepareCommand(OleDbCommand cmd, OleDbConnection conn, OleDbTransaction trans, string cmdText, OleDbParameter[] cmdParms)
    {
        if (conn.State != ConnectionState.Open)
            conn.Open();
        cmd.Connection = conn;
        cmd.CommandText = cmdText;
        if (trans != null)
            cmd.Transaction = trans;
        cmd.CommandType = CommandType.Text;//cmdType;
        if (cmdParms != null)
        {


            foreach (OleDbParameter parameter in cmdParms)
            {
                if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) &&
                    (parameter.Value == null))
                {
                    parameter.Value = DBNull.Value;
                }
                cmd.Parameters.Add(parameter);
            }
        }
    }
    /// <summary>
    /// 执行SQL语句，返回影响的记录数
    /// </summary>
    /// <param name="SQLString">SQL语句</param>
    /// <returns>影响的记录数</returns>
    public static int ExecuteSql(string SQLString)
    {
        using (OleDbConnection connection = new OleDbConnection(ConnectionString))
        {
            using (OleDbCommand cmd = new OleDbCommand(SQLString, connection))
            {
                try
                {
                    connection.Open();
                    int rows = cmd.ExecuteNonQuery();
                    return rows;
                }
                catch (OleDbException e)
                {
                    connection.Close();
                    throw e;
                }
                finally
                {
                    cmd.Dispose();
                    connection.Close();
                }
            }
        }
    }
    /// <summary>
    /// 执行一条计算查询结果语句，返回查询结果（object）。
    /// </summary>
    /// <param name="SQLString">计算查询结果语句</param>
    /// <returns>查询结果（object）</returns>
    public static object GetSingle(string SQLString, params OleDbParameter[] cmdParms)
    {
        using (OleDbConnection connection = new OleDbConnection(ConnectionString))
        {
            using (OleDbCommand cmd = new OleDbCommand())
            {
                try
                {
                    PrepareCommand(cmd, connection, null, SQLString, cmdParms);
                    object obj = cmd.ExecuteScalar();
                    cmd.Parameters.Clear();
                    if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                    {
                        return null;
                    }
                    else
                    {
                        return obj;
                    }
                }
                catch (OleDbException e)
                {
                    throw e;
                }
                finally
                {
                    cmd.Dispose();
                    connection.Close();
                }
            }
        }
    }
        
        
}
