﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;
using System.Text;
using System.Text.RegularExpressions;

public partial class Tool_link : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string sUrl = Request.ServerVariables["HTTP_REFERER"];
        string[] s = new string[] { };
        if(!string.IsNullOrEmpty(sUrl))
          s = sUrl.Replace("http://","").Split('/');
        if (!string.IsNullOrEmpty(sUrl))
        {
            try
            {
                string sql = string.Format("UPDATE LINKS SET SCOUNT=SCOUNT+1,STIME='{0}',sstatus=true WHERE SURL='{1}'", DateTime.Now, s[0].Trim());
                SqlHelper.ExecuteSql(sql);
            }
            catch (Exception ex)
            {
                Response.Redirect("err.aspx?s=" + Server.HtmlEncode(ex.Message));
            }
            this.divFrom.Visible = true;
            this.spanFrom.InnerHtml = sUrl;
        }
        else
            this.divFrom.Visible = false;

        GetNewTop();
        GetLinks();
        GetNoLink();
    }

    void GetLinks()
    {
        OleDbDataReader reader = null;
        try
        {
            string sql = "SELECT * FROM LINKS WHERE SSTATUS=TRUE ORDER BY SCOUNT,STIME DESC";
            reader = SqlHelper.ExecuteReader(sql);
            StringBuilder sb = new StringBuilder();
            while (reader.Read())
            {
                string url = reader["surl"].ToString().Replace("http://", "");
                string desc = string.Format("点入次数：{0}&nbsp;&nbsp;点出次数：{1}&nbsp;&nbsp;站点描述：{2}", reader["scount"], "暂未统计", reader["sdesc"]);
                sb.AppendFormat("<li><a title=\"{0}\" href=\"http://{1}\" target=\"_blank\">{2}</a> </li>", desc, url, reader["sname"]);
            }
            this.ulLink.InnerHtml = sb.ToString();
        }
        catch (Exception ex)
        {
            Response.Redirect("err.aspx?s=" + Server.HtmlEncode(ex.Message));
        }
        finally { if (reader != null) { reader.Close(); reader.Dispose(); } }
    }

    void GetNewTop()
    {
        OleDbDataReader reader=null;
        try
        {
            
            string sql1 = "SELECT TOP 30 * FROM LINKS WHERE SSTATUS=TRUE ORDER BY stime,scount desc";
            reader = SqlHelper.ExecuteReader(sql1, null);
            StringBuilder sb = new StringBuilder();
            sb.Append("最新点入网站TOP30：");
            while (reader.Read())
            {
                string url = reader["surl"].ToString().Replace("http://", "");
                string desc = string.Format("点入次数：{0}&nbsp;&nbsp;点出次数：{1}&nbsp;&nbsp;站点描述：{2}", reader["scount"], "暂未统计", reader["sdesc"]);
                sb.AppendFormat("<a href=\"http://{0}\" target=\"_blank\" title=\"{1}\"><font color=red>{2}</font></a>&nbsp;&nbsp;", url, desc, reader["sname"]);
            }
            this.adhere.InnerHtml = sb.ToString();
        }
        catch (Exception ex)
        {
            Response.Redirect("err.aspx?s=" + Server.HtmlEncode(ex.Message));
        }
        finally { if (reader != null) { reader.Close(); reader.Dispose(); } }
    }

    void GetNoLink()
    {
        OleDbDataReader reader = null;
        try
        {

            string sql = "SELECT * FROM LINKS WHERE SSTATUS=false ORDER BY stime,scount desc";
            reader = SqlHelper.ExecuteReader(sql, null);
            StringBuilder sb = new StringBuilder();
            sb.Append("<br><font color=blue>以下网站未连接，请做好本站连接后点入即可(请连接到：<font color=red>http://www.16sb.cn/tool/link.aspx</font> 否则系统不会自动加入)：<br></font>");
            while (reader.Read())
            {
                string url = reader["surl"].ToString().Replace("http://", "");
                sb.AppendFormat("{0}&nbsp;&nbsp;",Server.HtmlEncode( url));
            }
            sb.Append("<br>");
            this.divNoLink.InnerHtml = sb.ToString();
        }
        catch (Exception ex)
        {
            Response.Redirect("err.aspx?s=" + Server.HtmlEncode(ex.Message));
        }
        finally { if (reader != null) { reader.Close(); reader.Dispose(); } } 
    }
}
