﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Net;
using System.Xml;
public partial class tool_IpQuery : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        InsertNodes(this.ip.Text.Trim());
        string text = this.ip.Text;
        string iPByDomain = this.GetIPByDomain(text);
        string str3 = IPLocation.IPLocate(base.Server.MapPath(IpQueryDat), iPByDomain);
        this.sp1.InnerHtml = "IP地址：<font color=red>" + iPByDomain + "</font> &nbsp;&nbsp;地理位置：<font color=red>" + str3+"</font>";
        getNewSite();
    }
    string GetIPByDomain(string url)
    {
        string str;
        if (url.Trim() == string.Empty)
        {
            return "";
        }
        try
        {
            str = Dns.GetHostEntry(url).AddressList.GetValue(0).ToString();
        }
        catch (Exception exception)
        {
            throw exception;
        }
        return str;
    }

    void InsertNodes(string s)
    {
        XmlDocument doc = new XmlDocument();
        doc.Load(Server.MapPath(NewIpQuery));
        XmlNode root = doc.SelectSingleNode("querys");
        XmlElement xe1 = doc.CreateElement("query");
        xe1.SetAttribute("queryKey", Guid.NewGuid().ToString());
        xe1.SetAttribute("queryDate", HttpContext.Current.Server.HtmlEncode(DateTime.Now.ToString("yyyy-MM-dd")));
        xe1.SetAttribute("queryUrl", HttpContext.Current.Server.HtmlEncode(s));


        root.AppendChild(xe1);

        doc.Save(HttpContext.Current.Server.MapPath(NewIpQuery));
        WebClass.ReMoveCacheByKey("queryIpSite");
    }

    /// <summary>
    /// 获取最近查询TOP30
    /// </summary>
    void getNewSite()
    {
        string s = "";
        if (WebClass.GetCache("queryIpSite") == null)
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath(NewIpQuery));
            XmlNodeList nodes = doc.SelectNodes("querys/query");

            int j = 0;
            for (int i = nodes.Count - 1; i >= 0; i--)
            {
                j++;
                if (j == 30)
                    break;
                s += "<li><a href=\"http://" + nodes[i].Attributes["queryUrl"].Value + "\" target='_blank'>" + nodes[i].Attributes["queryUrl"].Value + "</a></li>";
            }
            WebClass.SetCache("queryIpSite", s);
        }
        else
        {
            s = WebClass.GetCache("queryIpSite").ToString();
        }
        this.ulTop.InnerHtml = s;
    }
}
