﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;
using System.Text;

public partial class usercontrol_NewArticle : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        getNewArticle();
    }
    void getNewArticle()
    {
        if (WebClass.GetCache("NewArticle") == null)
        {
            OleDbDataReader dr = null;
            try
            {
                string sql = "SELECT TOP 10 * FROM ARTICLE ORDER BY ID DESC";
                dr = SqlHelper.ExecuteReader(sql, null);
                StringBuilder sb = new StringBuilder();
                sb.Append("<span style='width:98%;font-weight:bold;margin-top:10px;'>最新文章</span>");
                while (dr.Read())
                {
                    //string url = dr["surl"].ToString().Replace("http://", "");
                    string ut = dr["arttitle"].ToString();
                    if (WebClass.GetBytesLength(ut) > 25)
                        ut = WebClass.CutString(ut, 25);
                    sb.AppendFormat("<li><a href=\"{0}/ShowArticle.aspx?id={1}\">{2}</a></li>",WebHelper.GetBaseURL() ,dr["id"], Server.HtmlEncode(ut));
                }
                WebClass.SetCache("NewArticle", sb.ToString());
                this.NewArticle.InnerHtml = sb.ToString();
            }
            catch (Exception ex)
            {
                this.NewArticle.InnerHtml = "读取数据出错！"+Server.HtmlEncode( ex.Message);
            }
            finally { if (dr != null)dr.Close(); }
        }
        else
        {
            this.NewArticle.InnerHtml = WebClass.GetCache("NewArticle").ToString();
        }
    }
}
