﻿/*
=============================================================================
Author:魏宝辉 FTchina
CreatedTime:2008-11-18
Description:三层结构数据访问层的通用数据库访问方法
=============================================================================
*/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
//该源码首发自www.51aspx.com(５１ａsｐｘ．ｃｏｍ)

namespace FTchina.DAL
{
	///<summary>
	/// 数据库访问通用方法类
	/// </summary>
	public static class DBHelper
	{
		private static SqlConnection connection;//连接对象
		public static SqlConnection Connection
		{
			get 
			{
				string connectionString = ConfigurationSettings.AppSettings["ConnectionString"];
				if (connection == null)
				{
					connection = new SqlConnection(connectionString);
					connection.Open();
					}
				else if (connection.State == System.Data.ConnectionState.Closed)
				{
					connection.Open();
				}
				else if (connection.State == System.Data.ConnectionState.Broken)
				{
					connection.Close();
					connection.Open();
				}
				return connection;
			}
		}
		//执行SQl语句
		public static int ExecuteCommand(string safeSql)
		{
			SqlCommand cmd = new SqlCommand(safeSql, Connection);
			int result = cmd.ExecuteNonQuery();
			return result;
		}
		//带参数值的sql
		public static int ExecuteCommand(string sql, params SqlParameter[] values)
		{
			SqlCommand cmd = new SqlCommand(sql, Connection);
			cmd.Parameters.AddRange(values);
			return cmd.ExecuteNonQuery();
		}
		//执行SQl语句的
		public static int GetScalar(string safeSql)
		{
			SqlCommand cmd = new SqlCommand(safeSql, Connection);
			int result = Convert.ToInt32(cmd.ExecuteScalar());
			return result;
		}

		public static int GetScalar(string sql, params SqlParameter[] values)
		{
			SqlCommand cmd = new SqlCommand(sql, Connection);
			cmd.Parameters.AddRange(values);
			int result = Convert.ToInt32(cmd.ExecuteScalar());
			return result;
		}
		//查询返回记录集对象
		public static SqlDataReader GetReader(string safeSql)
		{
			SqlCommand cmd = new SqlCommand(safeSql, Connection);
			SqlDataReader reader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
			return reader;
		}
		//带参数值的查询返回记录集对象
		public static SqlDataReader GetReader(string sql, params SqlParameter[] values)
		{
			SqlCommand cmd = new SqlCommand(sql, Connection);
			cmd.Parameters.AddRange(values);
			SqlDataReader reader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
			return reader;
		}
		//返回表格的查询
		public static DataTable GetDataSet(string safeSql)
		{
			DataSet ds = new DataSet();
			SqlCommand cmd = new SqlCommand(safeSql, Connection);
			SqlDataAdapter da = new SqlDataAdapter(cmd);
			da.Fill(ds);
			return ds.Tables[0];
		}
		//带参数的查询返回表
		public static DataTable GetDataSet(string sql, params SqlParameter[] values)
		{
			DataSet ds = new DataSet();
			SqlCommand cmd = new SqlCommand(sql, Connection);
			cmd.Parameters.AddRange(values);
			SqlDataAdapter da = new SqlDataAdapter(cmd);
			da.Fill(ds);
			return ds.Tables[0];
		}

	}
}
