﻿/*
=============================================================================
Author:魏宝辉 FTchina
CreatedTime:2008-11-18
Description:radio三层结构数据访问层
=============================================================================
*/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using FTchina.Models;
namespace FTchina.DAL
{
	public static partial class RadioService
	{
		#region 增加一条数据
		public static Radio AddRadio(Radio radio)
		{
			string sql =
			"INSERT radio(name,radiotype,path,hits,date,error,leibie) "+
			"VALUES (@name,@radiotype,@path,@hits,@date,@error,@leibie)";
			sql += " ; SELECT @@IDENTITY";//获得当前的标识列
			try
			{
				SqlParameter[] para = new SqlParameter[]
				{
					new SqlParameter("@name",radio.Name),
					new SqlParameter("@radiotype",radio.Radiotype),
					new SqlParameter("@path",radio.Path),
					new SqlParameter("@hits",radio.Hits),
					new SqlParameter("@date",radio.Date),
					new SqlParameter("@error",radio.Error),
					new SqlParameter("@leibie",radio.Leibie)
				};
				int newId = DBHelper.GetScalar(sql, para);
				return GetRadioById(newId);
			}
			catch (Exception e)
			{
				 
				throw e;
			}
		}
		#endregion
		#region 删除数据
		public static void DeleteRadio(Radio radio)
		{
			DeleteRadioById(radio.Id);
		}
		public static void DeleteRadioById(int id)
		{
			string sql = "DELETE "+"radio"+" WHERE Id = @Id";
			try
			{
				SqlParameter[] para = new SqlParameter[]
				{
					new SqlParameter("@Id", id)
				};
				DBHelper.ExecuteCommand(sql, para);
			}catch(Exception e)
			{
				 
				throw e;
			}
		}
		#endregion
		#region 修改数据
		public static void ModifyRadio(Radio radio)
		{
			string sql ="UPDATE "+"radio"+" set "+
					"name=@name, "+
					"radiotype=@radiotype, "+
					"path=@path, "+
					"hits=@hits, "+
					"date=@date, "+
					"error=@error, "+
					"leibie=@leibie "+ 
					"Where id=@id";
			try
			{
				SqlParameter[] para = new SqlParameter[]
				{
					new SqlParameter("@id",radio.Id),
					new SqlParameter("@name",radio.Name),
					new SqlParameter("@radiotype",radio.Radiotype),
					new SqlParameter("@path",radio.Path),
					new SqlParameter("@hits",radio.Hits),
					new SqlParameter("@date",radio.Date),
					new SqlParameter("@error",radio.Error),
					new SqlParameter("@leibie",radio.Leibie)
				};
				DBHelper.ExecuteCommand(sql, para);
			}
			catch (Exception e)
			{
				 
				throw e;
			}
		}		
		#endregion
		#region 查询数据
		public static IList<Radio> GetAllRadios()
		{
			string sqlAll = "SELECT * FROM radio";
			return GetRadiosBySql(sqlAll);
		}
		public static Radio GetRadioById(int id)
		{
			string sql = "SELECT * FROM "+"radio"+" WHERE Id = @Id";
			try
			{
				SqlDataReader reader = DBHelper.GetReader(sql, new SqlParameter("@Id", id));
				if (reader.Read())
				{
					Radio radio = new Radio();
					radio.Id=(int)reader["id"];
					radio.Name=(string)reader["name"];
					radio.Radiotype=(int)reader["radiotype"];
					radio.Path=(string)reader["path"];
					radio.Hits=(int)reader["hits"];
					radio.Date=(DateTime)reader["date"];
					radio.Error=(int)reader["error"];
					radio.Leibie=(string)reader["leibie"];
					reader.Close();
					return radio;
					}
				else
				{
					reader.Close();
					return null;
				}
			}
			catch(Exception e)
			{ 
				throw e;
			}
		}
		public static IList<Radio> GetRadiosBySql(string safeSql)
		{
			List<Radio> list = new List<Radio>();
			using (DataTable table = DBHelper.GetDataSet(safeSql))
			{
				foreach (DataRow row in table.Rows)
				{
					Radio radio = new Radio();
					radio.Id=(int)row["id"];
					radio.Name=(string)row["name"];
					radio.Radiotype=(int)row["radiotype"];
					radio.Path=(string)row["path"];
					radio.Hits=(int)row["hits"];
					radio.Date=(DateTime)row["date"];
					radio.Error=(int)row["error"];
					radio.Leibie=(string)row["leibie"];
					list.Add(radio);
				}
				return list;
			}
		}
		private static IList<Radio> GetRadiosBySql( string sql, params SqlParameter[] values )
		{
			List<Radio> list = new List<Radio>();
			try
			{
				DataTable table = DBHelper.GetDataSet( sql, values );
				
				foreach (DataRow row in table.Rows)
				{
					Radio radio = new Radio();
					radio.Id=(int)row["id"];
					radio.Name=(string)row["name"];
					radio.Radiotype=(int)row["radiotype"];
					radio.Path=(string)row["path"];
					radio.Hits=(int)row["hits"];
					radio.Date=(DateTime)row["date"];
					radio.Error=(int)row["error"];
					radio.Leibie=(string)row["leibie"];
					list.Add(radio);
				}
				return list;
			}
			catch (Exception e)
			{
				 
				throw e;
			}
			
		}
		#endregion
	}
}

