﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

public partial class manage : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (FilterSQL(Request["action"]) == "mod" && FilterSQL(Request["id"]).Length > 0)
            {
                ReadModel();
                btnok.Text = "确定修改";
            }
            else
            { btnok.Text = "确定添加"; }

            bindData();
            FillDdlLb();

        }

    }

    public static string FilterSQL(string text)
    {
        string validSql = "";
        if (text != null)
        {
            text = text.Trim();
            text = text.Replace(";", "'';''");
            text = text.Replace("'", "''");
            text = text.Replace("--", "''--''");
            text = text.Replace("%25", "");
            text = text.Replace("%0a", "");
            text = text.Replace("%22", "");
            text = text.Replace("%27", "");
            text = text.Replace("%5c", "");
            text = text.Replace("%2f", "");
            text = text.Replace("%3c", "");
            text = text.Replace("%3e", "");
            text = text.Replace("%26", "");
            text = text.Replace("<", "&lt;");
            text = text.Replace(">", "&gt;");
            validSql = text;
        }
        return validSql;
    }


    #region 列表相关
    void bindData()
    {
        IList<FTchina.Models.Radio> Ilistmr = FTchina.DAL.RadioService.GetRadiosBySql("select * from radio order by id desc");
        gvList.DataSource = Ilistmr;
        gvList.DataBind();
        LblCurrentIndex.Text = (gvList.PageIndex + 1).ToString();
        LblPageCount.Text = gvList.PageCount.ToString();
        LblRecordCount.Text = Ilistmr.Count.ToString();
        if (Ilistmr.Count == 0)
        {
            btnFirst.Visible = false;
            btnPrev.Visible = false;
            btnNext.Visible = false;
            btnLast.Visible = false;

            LblCurrentIndex.Visible = false;
            LblPageCount.Visible = false;
            LblRecordCount.Visible = false;
            Label1.Visible = false;
            Label1.Visible = false;
            Label2.Visible = false;
            Label3.Visible = false;
            Label4.Visible = false;
            Label5.Visible = false;
            Label6.Visible = false;

            //lbMessage.Text = "没有记录！";
        }
        else if (gvList.PageCount == 1)
        {
            btnFirst.Visible = false;
            btnPrev.Visible = false;
            btnNext.Visible = false;
            btnLast.Visible = false;
        }
        // 计算生成分页页码,分别为："首 页" "上一页" "下一页" "尾 页"
        btnFirst.CommandName = "1";
        btnPrev.CommandName = (gvList.PageIndex == 0 ? "1" : gvList.PageIndex.ToString());
        btnNext.CommandName = (gvList.PageCount == 1 ? gvList.PageCount.ToString() : (gvList.PageIndex + 2).ToString());
        btnLast.CommandName = gvList.PageCount.ToString();

        ddlpage.Items.Clear();
        ddlpage.Items.Add("请选择");
        for (int i = 1; i < gvList.PageCount + 1; i++)
        {
            ddlpage.Items.Add(i.ToString());
        }


    }
    protected void ddlpage_SelectedIndexChanged(object sender, EventArgs e)
    {
        gvList.PageIndex = Convert.ToInt32(ddlpage.SelectedValue) - 1;
        bindData();
    }
    protected void PagerButtonClick(object sender, EventArgs e)
    {
        gvList.PageIndex = Convert.ToInt32(((LinkButton)sender).CommandName) - 1;
        bindData();
     }
    protected void gvList_PageIndexChanging(Object sender, GridViewPageEventArgs e)
    {
        if (gvList.PageCount > 1)
        {
            gvList.PageIndex = e.NewPageIndex;
            bindData();
        }
        else
        {
            LblCurrentIndex.Text = gvList.EditIndex.ToString();
        }
    }
    protected void gvList_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        int i;
        //执行循环，保证每条数据都可以更新
        for (i = 0; i < gvList.Rows.Count; i++)
        {
            //首先判断是否是数据行
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //当鼠标停留时更改背景色
                e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#f4f5eb'");
                //当鼠标移开时还原背景色
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
            }
        }

    }

    #endregion

    #region 类别列表相关

    protected void FillDdlLb()
    {
        ddllb.DataSource = FTchina.DAL.DBHelper.GetDataSet("select distinct leibie from radio");
        ddllb.DataTextField = "leibie";
        ddllb.DataValueField = "leibie";
        ddllb.DataBind();
        ddllb.Items.Add("请选择");
        ddllb.SelectedIndex = ddllb.Items.Count - 1;
    }
    protected void ddllb_SelectedIndexChanged(object sender, EventArgs e)
    {
        txblb.Text = ddllb.SelectedValue;
    }
    #endregion

    private void ReadModel()
    {
        FTchina.Models.Radio mr = new FTchina.Models.Radio();
        mr = FTchina.BLL.RadioManager.GetRadioById(Convert.ToInt32(FilterSQL(Request["id"])));
        txblb.Text = mr.Leibie;
        txbname.Text = mr.Name;
        txbpath.Text = mr.Path;
        txbhit.Text = mr.Hits.ToString();
    }
    protected void btnok_Click(object sender, EventArgs e)
    {
        FTchina.Models.Radio mr = new FTchina.Models.Radio();
        mr.Date = DateTime.Now;
        mr.Leibie = FilterSQL(txblb.Text);
        mr.Name = FilterSQL(txbname.Text);
        mr.Path = FilterSQL(txbpath.Text);
        mr.Radiotype = Convert.ToInt32(ddltype.SelectedValue);
        mr.Hits = Convert.ToInt32(txbhit.Text);
        mr.Error = 0;
        if (FilterSQL(Request["action"]) == "mod")
        {
            mr.Id = Convert.ToInt32(Request["id"]);

        }
        if (btnok.Text == "确定修改") FTchina.BLL.RadioManager.ModifyRadio(mr);
        else FTchina.BLL.RadioManager.AddRadio(mr);

        Response.Redirect("manage.aspx");
    }

}
