using System.Collections;
using System.Drawing;
using LLK.AI;
using LLK.UI;

namespace LLK.ACTION
{
	/// <summary>
	/// LineManager ժҪ˵
	/// ߹
	/// </summary>
	public class LineManager
	{
		private ArrayList LineList = new ArrayList();
		private Map oMap;

		public const int MaxTrunCount = 3;

		public LineManager(Map map)
		{
			oMap = map;
		}

		public int Count
		{
			get { return this.LineList.Count; }
		}

		public Line Items(int Index)
		{
			return (Line) this.LineList[Index];
		}

		public void Add(int x, int y, int ImageID)
		{
			Line l = new Line();
			l.X = x;
			l.Y = y;
			l.ID = ImageID;
			LineList.Add((object) l);
		}

		public void Add(Line line)
		{
			LineList.Add((object) line);
		}

		public bool RemoveAt(int index)
		{
			try
			{
				LineList.RemoveAt(index);
				return true;
			}
			catch
			{
				return false;
			}
		}

		public void Clear()
		{
			LineList.Clear();
			LineList.TrimToSize();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="Point1"></param>
		/// <param name="Point2"></param>
		/// <returns></returns>
		public bool SearchLine(ref Line Point1, ref Line Point2)
		{
			//
			ArrayList al = oMap.GetObjectList();
			this.Clear();
			for (int i = 0; i < al.Count; i++)
			{
				//
				if ((al[i] as Line).ID > 0)
				{
					Line p1 = (al[i] as Line);
					for (int j = i + 1; j < al.Count; j++)
					{
						if ((al[j] as Line).ID > 0 && (al[j] as Line).ID == p1.ID)
						{
							Line p2 = (al[j] as Line);
							this.Add(p1);
							this.Add(p2);
							if (this.CanStartLink())
							{
								ArrayList findPathPoints = null;
								int trunCount = 0;
								if (this.TestLink(out findPathPoints, out trunCount))
								{
									Point1 = p1;
									Point2 = p2;
									return true;
								}
								this.Clear();
							}
						}
					}
				}
			}
			return false;
		}

		/// <summary>
		/// жǷԿʼ
		/// </summary>
		/// <returns></returns>
		public bool CanStartLink()
		{
			if (LineList.Count > 0)
			{
				return (LineList.Count%2) == 0;
			}
			else
				return false;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public bool TestLink(out ArrayList findPathPoints, out int trunCount)
		{
			findPathPoints = null;
			trunCount = 0;
			//ܿʼ
			if (!CanStartLink())
				return false;

			//ȡp1,p2
			Line p1 = (Line) LineList[LineList.Count - 2];
			Line p2 = (Line) LineList[LineList.Count - 1];

			//Ŀͬ
			if (p1.ID != p2.ID)
				return false;

			if (p1.ID == 0 || p2.ID == 0)
				return false;

			if (p1.X == p2.X && p1.Y == p2.Y)
				return false;

			if (p1.X > p2.X)
			{
				Line tmp = p1;
				p1 = p2;
				p2 = tmp;
			}

			TestPath TP = new TestPath(new Point(p1.X, p1.Y), new Point(p2.X, p2.Y), oMap.TestMapArray(p1, p2));
			if (TP.Execute())
			{
				findPathPoints = TP.PathPointArray;
				trunCount = TP.PathPointCount;

				if (trunCount > 3) return false;

				return (findPathPoints.Count > 0 && (trunCount >= 0 && trunCount <= MaxTrunCount));

			}
			return false;
		}

		private bool findLine(ref ArrayList al, Line l)
		{
			if (al.Count > 0)
			{
				Line ll = (al[al.Count - 1] as Line);
				bool isX = (ll.X == l.X);
				bool isY = (ll.Y == l.Y);
				if (isX)
				{
					return (ll.X == l.X);
				}
				else if (isY)
				{
					return (ll.Y == l.Y);
				}
				else
				{
					return false;
				}
			}
			else
			{
				return false;
			}

		}
	}
}