using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using LLK.ACTION;
using LLK.UI;

namespace LLK
{
	/// <summary>
	/// GameMain ժҪ˵
	/// </summary>
	public class GameMain : Form
	{
		private IContainer components;
		private CheckBox AutoClear;
		private Timer lineTimer;
		private Button btnReset;
		private Button btnInfo;
		private Button btnRePlay;
		private Label lbP;
		private Label lbInfoCount;
		private Label label3;
		private Button btnExit;
		private ProgressBar pBar;
		private Timer timeOutTimer;
		private Label lbTimeOut;
		private PictureBox pictureBox1;
		private Label label1;
		private Label lbCaption;
		private CheckBox AutoReset;
		private Button btnAbout;
		private Button btnConfig;

		private ScreenDraw SD = null;
		private Line search_p1 = null;
		private Line search_p2 = null;

		private bool isSearch = false;
		private int PointCount = 0;
		private int InfoCount = 5;
		private const int GameTimeSec = 60;

		private GameState gs = GameState.Start;
		private Map[] oMap = null;
		private LineManager[] LM = null;
		private ScreenCursor cursor = null;
		private GameOption.Options options = new GameOption.Options();
		private ScreenObject SO = null;

		private BombPoint bp1 = new BombPoint();
		private BombPoint bp2 = new BombPoint();

		private SoundPlayList spl = new SoundPlayList();

		private string appPath = "";

		private SoundPlayer spBg;
		private SoundPlayer spBomb;
		private SoundPlayer spEarse;
		private SoundPlayer spRefresh;
		private SoundPlayer spSelect;
		private SoundPlayer spHint;

		//16, 22, 28, 34, 39
		private int[,] L = new int[3,3] {{28, 22, 16}, {34, 28, 22}, {39, 34, 28}};
		private Timer SplashTimer;
		private GameLoading GL = null;

		private enum GameState
		{
			Start,
			Play,
			End,
			Win
		}

		public GameMain(GameLoading gameLoading)
		{
			InitializeComponent();

			this.GL = gameLoading;

		}

		/// <summary>
		/// ʹõԴ
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows ɵĴ

		/// <summary>
		/// ֧ķ - Ҫʹô༭޸
		/// ˷ݡ
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new Container();
			this.btnReset = new Button();
			this.btnInfo = new Button();
			this.AutoClear = new CheckBox();
			this.lineTimer = new Timer(this.components);
			this.btnRePlay = new Button();
			this.label1 = new Label();
			this.lbP = new Label();
			this.lbInfoCount = new Label();
			this.label3 = new Label();
			this.btnExit = new Button();
			this.pBar = new ProgressBar();
			this.lbTimeOut = new Label();
			this.timeOutTimer = new Timer(this.components);
			this.pictureBox1 = new PictureBox();
			this.lbCaption = new Label();
			this.AutoReset = new CheckBox();
			this.btnAbout = new Button();
			this.btnConfig = new Button();
			this.SplashTimer = new Timer(this.components);
			this.SuspendLayout();
			// 
			// btnReset
			// 
			this.btnReset.ForeColor = Color.FromArgb(((Byte) (192)), ((Byte) (255)), ((Byte) (255)));
			this.btnReset.Location = new Point(672, 100);
			this.btnReset.Name = "btnReset";
			this.btnReset.TabIndex = 1;
			this.btnReset.Text = "";
			this.btnReset.Click += new EventHandler(this.btnReset_Click);
			// 
			// btnInfo
			// 
			this.btnInfo.ForeColor = Color.FromArgb(((Byte) (192)), ((Byte) (255)), ((Byte) (255)));
			this.btnInfo.Location = new Point(672, 68);
			this.btnInfo.Name = "btnInfo";
			this.btnInfo.TabIndex = 2;
			this.btnInfo.Text = "ʾ";
			this.btnInfo.Click += new EventHandler(this.btnInfo_Click);
			// 
			// AutoClear
			// 
			this.AutoClear.ForeColor = Color.Goldenrod;
			this.AutoClear.Location = new Point(672, 136);
			this.AutoClear.Name = "AutoClear";
			this.AutoClear.Size = new Size(80, 24);
			this.AutoClear.TabIndex = 0;
			this.AutoClear.Text = "Զ";
			// 
			// lineTimer
			// 
			this.lineTimer.Interval = 200;
			this.lineTimer.Tick += new EventHandler(this.lineTimer_Tick);
			// 
			// btnRePlay
			// 
			this.btnRePlay.ForeColor = Color.FromArgb(((Byte) (192)), ((Byte) (255)), ((Byte) (255)));
			this.btnRePlay.Location = new Point(672, 36);
			this.btnRePlay.Name = "btnRePlay";
			this.btnRePlay.TabIndex = 3;
			this.btnRePlay.Text = "¾";
			this.btnRePlay.Click += new EventHandler(this.btnRePlay_Click);
			// 
			// label1
			// 
			this.label1.AutoSize = true;
			this.label1.ForeColor = Color.Goldenrod;
			this.label1.Location = new Point(672, 204);
			this.label1.Name = "label1";
			this.label1.Size = new Size(35, 17);
			this.label1.TabIndex = 6;
			this.label1.Text = "÷:";
			// 
			// lbP
			// 
			this.lbP.AutoSize = true;
			this.lbP.ForeColor = Color.Red;
			this.lbP.Location = new Point(672, 228);
			this.lbP.Name = "lbP";
			this.lbP.Size = new Size(11, 17);
			this.lbP.TabIndex = 7;
			this.lbP.Text = "0";
			// 
			// lbInfoCount
			// 
			this.lbInfoCount.AutoSize = true;
			this.lbInfoCount.ForeColor = Color.Red;
			this.lbInfoCount.Location = new Point(672, 280);
			this.lbInfoCount.Name = "lbInfoCount";
			this.lbInfoCount.Size = new Size(11, 17);
			this.lbInfoCount.TabIndex = 9;
			this.lbInfoCount.Text = "0";
			// 
			// label3
			// 
			this.label3.AutoSize = true;
			this.label3.ForeColor = Color.Goldenrod;
			this.label3.Location = new Point(672, 256);
			this.label3.Name = "label3";
			this.label3.Size = new Size(60, 17);
			this.label3.TabIndex = 8;
			this.label3.Text = "ʾ:";
			// 
			// btnExit
			// 
			this.btnExit.ForeColor = Color.FromArgb(((Byte) (192)), ((Byte) (255)), ((Byte) (255)));
			this.btnExit.Location = new Point(672, 376);
			this.btnExit.Name = "btnExit";
			this.btnExit.TabIndex = 10;
			this.btnExit.Text = "˳";
			this.btnExit.Click += new EventHandler(this.btnExit_Click);
			// 
			// pBar
			// 
			this.pBar.Location = new Point(112, 400);
			this.pBar.Name = "pBar";
			this.pBar.Size = new Size(416, 23);
			this.pBar.TabIndex = 11;
			this.pBar.Value = 100;
			// 
			// lbTimeOut
			// 
			this.lbTimeOut.AutoSize = true;
			this.lbTimeOut.ForeColor = Color.Goldenrod;
			this.lbTimeOut.Location = new Point(8, 404);
			this.lbTimeOut.Name = "lbTimeOut";
			this.lbTimeOut.Size = new Size(97, 17);
			this.lbTimeOut.TabIndex = 12;
			this.lbTimeOut.Text = "ʣʱ(60):";
			// 
			// timeOutTimer
			// 
			this.timeOutTimer.Interval = 1000;
			this.timeOutTimer.Tick += new EventHandler(this.timeOutTimer_Tick);
			// 
			// pictureBox1
			// 
			this.pictureBox1.Location = new Point(8, 40);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new Size(630, 330);
			this.pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 13;
			this.pictureBox1.TabStop = false;
			// 
			// lbCaption
			// 
			this.lbCaption.AutoSize = true;
			this.lbCaption.ForeColor = Color.Lime;
			this.lbCaption.Location = new Point(8, 8);
			this.lbCaption.Name = "lbCaption";
			this.lbCaption.Size = new Size(116, 17);
			this.lbCaption.TabIndex = 14;
			this.lbCaption.Text = " Ͽ쿪ʼ.";
			// 
			// AutoReset
			// 
			this.AutoReset.ForeColor = Color.Goldenrod;
			this.AutoReset.Location = new Point(672, 168);
			this.AutoReset.Name = "AutoReset";
			this.AutoReset.Size = new Size(80, 24);
			this.AutoReset.TabIndex = 15;
			this.AutoReset.Text = "Զ";
			this.AutoReset.Visible = false;
			// 
			// btnAbout
			// 
			this.btnAbout.ForeColor = Color.FromArgb(((Byte) (192)), ((Byte) (255)), ((Byte) (255)));
			this.btnAbout.Location = new Point(672, 344);
			this.btnAbout.Name = "btnAbout";
			this.btnAbout.TabIndex = 16;
			this.btnAbout.Text = "";
			this.btnAbout.Click += new EventHandler(this.btnAbout_Click);
			// 
			// btnConfig
			// 
			this.btnConfig.ForeColor = Color.FromArgb(((Byte) (192)), ((Byte) (255)), ((Byte) (255)));
			this.btnConfig.Location = new Point(672, 312);
			this.btnConfig.Name = "btnConfig";
			this.btnConfig.TabIndex = 17;
			this.btnConfig.Text = "";
			this.btnConfig.Click += new EventHandler(this.btnConfig_Click);
			// 
			// SplashTimer
			// 
			this.SplashTimer.Enabled = true;
			this.SplashTimer.Interval = 500;
			this.SplashTimer.Tick += new EventHandler(this.SplashTimer_Tick);
			// 
			// GameMain
			// 
			this.AutoScaleBaseSize = new Size(6, 14);
			this.BackColor = Color.Black;
			this.ClientSize = new Size(758, 431);
			this.Controls.Add(this.btnConfig);
			this.Controls.Add(this.btnAbout);
			this.Controls.Add(this.AutoReset);
			this.Controls.Add(this.lbCaption);
			this.Controls.Add(this.lbTimeOut);
			this.Controls.Add(this.lbInfoCount);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.lbP);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.pBar);
			this.Controls.Add(this.btnExit);
			this.Controls.Add(this.btnRePlay);
			this.Controls.Add(this.AutoClear);
			this.Controls.Add(this.btnInfo);
			this.Controls.Add(this.btnReset);
			this.Controls.Add(this.pictureBox1);
			this.Cursor = Cursors.Default;
            //this.FormBorderStyle = FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.Name = "GameMain";
			this.StartPosition = FormStartPosition.CenterScreen;
			this.Text = "GameMain";
			this.Load += new EventHandler(this.GameMain_Load);
			this.MouseUp += new MouseEventHandler(this.GameMain_MouseUp);
			this.Paint += new PaintEventHandler(this.GameMain_Paint);
			this.MouseMove += new MouseEventHandler(this.GameMain_MouseMove);
			this.ResumeLayout(false);

		}

		#endregion

		/// <summary>
		/// Ӧóڵ㡣
		/// </summary>
		[STAThread]
		private static void Main()
		{
			GameLoading GL = new GameLoading();
			GL.Show();
			Application.Run(new GameMain(GL));
		}

		private void GameMain_Load(object sender, EventArgs e)
		{
			appPath = Application.ExecutablePath.Substring(0, Application.ExecutablePath.LastIndexOf("\\"));
			this.Hide();
			GL.Refresh();
			GL.UpdateLoadingInfo("ڳʼͼ...");
			oMap = new Map[3];
			GL.UpdateLoadingInfo("ʼͼ...,ڳʼ߹...");
			LM = new LineManager[3];
			GL.UpdateLoadingInfo("ʼ߹...,ڳʼõ...");
			cursor = new ScreenCursor();
			GameOption go = new GameOption(this.spl);
			options = go.ReadOption();
			go.Dispose();
			GL.UpdateLoadingInfo("ʼõ...,ڳʼز...");

			SO = new ScreenObject();
			GL.UpdateLoadingInfo("ʼز...,ڷԪ...");
			oMap[0] = new Map(SO, 39, 0, 0);
			oMap[1] = new Map(SO, 34, 0, 0);
			oMap[2] = new Map(SO, 28, 0, 0);
			GL.UpdateLoadingInfo("Ԫ...,ڼ·...");
			LM[0] = new LineManager(oMap[0]);
			LM[1] = new LineManager(oMap[1]);
			LM[2] = new LineManager(oMap[2]);

			SD = new ScreenDraw(this.CreateGraphics(), Map.TileRowCount*Map.TileWidth, Map.TileColCount*Map.TileHeight);
			search_p1 = new Line();
			search_p2 = new Line();
			this.Text = "  ";

			try
			{
				this.pictureBox1.Image = Image.FromFile(appPath + "\\Images\\WelCome.jpg");
			}
			catch
			{
				MessageBox.Show("ȱԴĿ¼!!", "뵽װĿ¼!", MessageBoxButtons.OK, MessageBoxIcon.Information);
				this.Close();
			}

			GL.UpdateLoadingInfo("·...,ڳʼ...");

			//			spl.Add(@".\Sounds\bg-01.mid");
			//			spl.Add(@".\Sounds\bg-02.mid");
			//			spl.Add(@".\Sounds\bg-03.mid");
			//			spl.Add(@".\Sounds\bg-04.mp3");
			spBg = new SoundPlayer(spl.CurrentMusic(), "bg");
			GL.UpdateLoadingInfo("ʼ...");
			spBomb = new SoundPlayer(appPath + @"\Sounds\bomb.wav", "bomb");
			GL.UpdateLoadingInfo("ʼըЧ...");
			spEarse = new SoundPlayer(appPath + @"\Sounds\Earse.wav", "earse");
			GL.UpdateLoadingInfo("ʼЧ...");
			spRefresh = new SoundPlayer(appPath + @"\Sounds\refresh.wav", "refresh");
			GL.UpdateLoadingInfo("ʼˢЧ...");
			spSelect = new SoundPlayer(appPath + @"\Sounds\select.wav", "select");
			GL.UpdateLoadingInfo("ʼѡЧ...");
			spHint = new SoundPlayer(appPath + @"\Sounds\hint.wav", "hint");
			GL.UpdateLoadingInfo("Ϸʼϣ");

			//GL.Close();
			//GL.Dispose();
			//GL =null;
		}

		private void InitGame()
		{
			//3
			pBar.Maximum = GameTimeSec;
			pBar.Minimum = 0;
			pBar.Value = pBar.Maximum;
			this.InfoCount = 5;
			this.PointCount = 0;
			if (File.Exists(appPath + "\\chinasf"))
			{
				this.InfoCount = 5000;
			}
			pictureBox1.Hide();
			lbCaption.Hide();

			for (int i = 0; i < oMap.Length; i++)
			{
				oMap[i].Level = L[options.Level - 1, i];
			}

			if (gs == GameState.End)
			{
				foreach (Map m in oMap)
				{
					m.ResetMap();
					m.RandomRefresh();
				}
				UpdateFrame();
			}
			gs = GameState.Play;

			this.timeOutTimer.Enabled = true;

			if (options.PlayMusic)
			{
				if (!spBg.IsPlaying)
				{
					spBg.FileName = spl.CurrentMusic();
					spBg.PlaySound();
				}
			}
			else
			{
				spBg.StopSound();
			}

			if (GL != null)
			{
				GL.Close();
				GL.Dispose();
				GL = null;
			}
		}

		private void EndGame()
		{
			gs = GameState.End;

			this.timeOutTimer.Enabled = false;

			SD.Fill(Color.Black);
			SD.Flip(0, 0);

			pBar.Maximum = GameTimeSec;
			pBar.Minimum = 0;
			pBar.Value = pBar.Maximum;
			pictureBox1.Show();
			lbCaption.Show();
			spBg.StopSound();

		}

		private void WinGame()
		{
			gs = GameState.Win;

			EndGame();
		}

		private void GameMain_MouseUp(object sender, MouseEventArgs e)
		{
			if (gs != GameState.Play) return;

			MapTile[] oMapTile = new MapTile[3];

			for (int i = oMap.Length - 1; i >= 0; i--)
			{
				if (oMap[i].GetCount() > 0)
				{
					oMapTile[i] = oMap[i].TranPointToMapTile(e.X, e.Y);
					if (oMapTile[i] != null)
					{
						if (oMapTile[i].XIndex == 0 || oMapTile[i].YIndex == 0 || oMapTile[i].XIndex == Map.TileRowCount - 1 || oMapTile[i].YIndex == Map.TileColCount - 1 || oMapTile[i].ID == 0)
						{
							return;
						}
						else
						{
							if (oMap[oMap.Length - 1].GetCount() > 0)
							{
								if (i < oMap.Length - 1) break;
							}
							Graphics g = this.CreateGraphics();
							g.DrawRectangle(new Pen(Color.Red), oMapTile[i].X, oMapTile[i].Y, oMapTile[i].Width, oMapTile[i].Height);
							LM[i].Add(oMapTile[i].XIndex, oMapTile[i].YIndex, oMapTile[i].ID);
							cursor.DrawCursor(g);

							if (this.options.PlaySound)
								spSelect.PlaySound();

							isSearch = false;

							if (LM[i].CanStartLink())
							{
								UpdateFrame();
							}
							break;
						}
					}
				}
			}

		}

		private void GameMain_Paint(object sender, PaintEventArgs e)
		{
			if (gs == GameState.Play) UpdateFrame();
		}

		private int ShowLineAndClear()
		{
			ArrayList findPathPoints = null;
			int trunCount = 0;

			bp1.SetEmpty();
			bp2.SetEmpty();

			for (int i = oMap.Length - 1; i >= 0; i--)
			{
				if (LM[i].TestLink(out findPathPoints, out trunCount))
				{
					oMap[i].DrawPathPoints(SD.Surface(), findPathPoints);

					/*ƱըЧ*/
					bp1.CurrentMap = oMap[i];
					bp2.CurrentMap = oMap[i];
					bp1.CurrentPoint = new Point(LM[i].Items(LM[i].Count - 1).X, LM[i].Items(LM[i].Count - 1).Y);
					bp2.CurrentPoint = new Point(LM[i].Items(LM[i].Count - 2).X, LM[i].Items(LM[i].Count - 2).Y);
					bp1.CurrentSurface = SD.Image();
					bp2.CurrentSurface = SD.Image();


					MapTile oMapTile1 = bp1.CurrentMap.MapView[bp1.CurrentPoint.X, bp1.CurrentPoint.Y];
					MapTile oMapTile2 = bp2.CurrentMap.MapView[bp2.CurrentPoint.X, bp2.CurrentPoint.Y];

					if (oMapTile1 != null)
					{
						Bitmap b1 = bp1.CurrentMap.DrawBombEff(bp1.CurrentSurface, 5, oMapTile1);
						SD.Surface().DrawImage((Image) b1, bp1.TransOffsetX(oMapTile1.X), bp1.TransOffsetY(oMapTile1.Y));
					}
					if (oMapTile2 != null)
					{
						Bitmap b2 = bp2.CurrentMap.DrawBombEff(bp2.CurrentSurface, 5, oMapTile2);
						SD.Surface().DrawImage((Image) b2, bp2.TransOffsetX(oMapTile2.X), bp2.TransOffsetY(oMapTile2.Y));
					}
					bp1.SetEmpty();
					bp2.SetEmpty();
					/*ըЧ*/

					oMap[i].DestroyObject(LM[i].Items(LM[i].Count - 1).X, LM[i].Items(LM[i].Count - 1).Y);
					oMap[i].DestroyObject(LM[i].Items(LM[i].Count - 2).X, LM[i].Items(LM[i].Count - 2).Y);

					lineTimer.Enabled = true;

					LM[i].Clear();
					return trunCount + 1;
				}
			}

			return 0;
		}

		//Զ
		//		private void AutoUpdateMap()
		//		{
		//			Line p1 = new Line();
		//			Line p2 = new Line();
		//			p1.X = -1;
		//			p2.X = -1;
		//			p1.Y = -1;
		//			p2.Y = -1;
		//			if(!LM.SearchLine(ref search_p1,ref search_p2))
		//			{
		//				LM.Clear();
		//				oMap.RandomRefresh();
		//				UpdateFrame();
		//			}
		//		}

		private void UpdateFrame()
		{
			UpdateFrame(true);
		}

		private void UpdateFrame(bool IsFlip)
		{
			if (gs == GameState.Play)
			{
				if (!this.Visible) return;

				SD.Fill(Color.Black);
				for (int i = 0; i < oMap.Length; i++)
				{
					if (oMap[i].GetCount() != 0)
					{
						if (i < 2)
						{
							if (oMap[i + 1].GetCount() != 0)
							{
								if (i == 0)
								{
									oMap[i].Draw(SD.Surface(), true, 1);
								}
								else
								{
									oMap[i].Draw(SD.Surface(), true, 2);
								}
							}
							else
							{
								oMap[i].Draw(SD.Surface(), false, 1);
							}
						}
						else
						{
							oMap[i].Draw(SD.Surface(), false, 1);
						}
					}

					if (LM[i].CanStartLink())
					{
						if (isSearch)
						{
							//ֻʾ
							MapTile MT1 = oMap[i].GetMapTile(search_p1.X, search_p1.Y);
							MapTile MT2 = oMap[i].GetMapTile(search_p2.X, search_p2.Y);
							SD.Surface().DrawRectangle(new Pen(Color.Red, 2F), MT1.X, MT1.Y, MT1.Width - 1, MT1.Height - 1);
							SD.Surface().DrawRectangle(new Pen(Color.Red, 2F), MT2.X, MT2.Y, MT2.Width - 1, MT2.Height - 1);
							cursor.DrawCursor(SD.Surface(), new Point(MT1.X + 15, MT1.Y + 15));
							cursor.DrawCursor(SD.Surface(), new Point(MT2.X + 15, MT2.Y + 15));
						}
						if (AutoClear.Checked && isSearch)
						{
							int t = ShowLineAndClear();
							if (isSearch)
							{
								if (t != 0)
								{
									PointCount -= t*100;
									if (this.options.PlaySound)
										spBomb.PlaySound();
								}
							}
							else
							{
								if (t != 0)
								{
									PointCount += t*100;
									if (this.options.PlaySound)
										spBomb.PlaySound();
								}
							}
							isSearch = false;
						}
						else if (!isSearch)
						{
							int t = ShowLineAndClear();
							if (t != 0)
							{
								PointCount += t*100;
								pBar.Value = pBar.Value + Math.Min(pBar.Maximum - pBar.Value, 6);
								if (this.options.PlaySound)
									spEarse.PlaySound();
							}
						}

						lbP.Text = PointCount.ToString();

					}

				}

				if (IsFlip)
				{
					SD.Flip(0, 0);
				}

				lbInfoCount.Text = InfoCount.ToString();

				int totalObjectCount = 0;
				foreach (Map m in oMap)
				{
					totalObjectCount += m.GetCount();
				}

				if (totalObjectCount == 0)
				{
					EndGame();
					MessageBox.Show("ϲѹأ", "ϵͳʾ", MessageBoxButtons.OK, MessageBoxIcon.Information);
				}


				if (options.PlayMusic && gs == GameState.Play)
				{
					if (!spBg.IsPlaying)
					{
						spBg.FileName = spl.CurrentMusic();
						spBg.PlaySound();
					}
				}
				else
				{
					spBg.StopSound();
				}
			}
		}

		private void lineTimer_Tick(object sender, EventArgs e)
		{
			if (gs != GameState.Play) return;
			lineTimer.Enabled = false;
			UpdateFrame();
		}

		private void btnInfo_Click(object sender, EventArgs e)
		{
			if (gs != GameState.Play) return;
			if (InfoCount > 0)
			{
				InfoCount --;

				search_p1.X = -1;
				search_p2.X = -1;
				search_p1.Y = -1;
				search_p2.Y = -1;
				if (oMap[2].GetCount() != 0)
					isSearch = LM[2].SearchLine(ref search_p1, ref search_p2);
				else if (oMap[1].GetCount() != 0)
					isSearch = LM[1].SearchLine(ref search_p1, ref search_p2);
				else
					isSearch = LM[0].SearchLine(ref search_p1, ref search_p2);
				UpdateFrame();

			}
		}

		private void btnReset_Click(object sender, EventArgs e)
		{
			if (gs != GameState.Play) return;
			if (this.options.PlaySound)
				spRefresh.PlaySound();
			foreach (Map m in oMap)
			{
				m.RandomRefresh();
			}

			UpdateFrame();
		}

		private void btnRePlay_Click(object sender, EventArgs e)
		{
			if (gs == GameState.Play)
			{
				if (MessageBox.Show("ĿǰϷ㿪¾", "ʾ", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.Yes)
				{
					this.EndGame();
				}
				else
				{
					return;
				}
			}
			this.InitGame();
			foreach (Map m in oMap)
			{
				m.ResetMap();
				m.RandomRefresh();
			}
			PointCount = 0;
			UpdateFrame();
		}

		private void btnExit_Click(object sender, EventArgs e)
		{
			this.EndGame();
			this.Close();
		}

		private void timeOutTimer_Tick(object sender, EventArgs e)
		{
			if (pBar.Value > 0)
			{
				pBar.Value = pBar.Value - 1;
				lbTimeOut.Text = String.Format("ʣʱ({0}):", pBar.Value);

				if (pBar.Value <= 3)
				{
					if (this.options.PlaySound)
						if (!spHint.IsPlaying)
							spHint.PlaySound();
				}
			}
			else
			{
				timeOutTimer.Enabled = false;
				if (gs != GameState.Win)
				{
					SD.GrayScale();
					SD.Flip(0, 0);

					MessageBox.Show("ʱ䵽Ŭ", "Ϸ", MessageBoxButtons.OK, MessageBoxIcon.Information);
				}
				spBg.StopSound();
				EndGame();
			}
		}

		private void btnAbout_Click(object sender, EventArgs e)
		{
			GameAbout ga = new GameAbout();
			ga.ShowDialog(this);
			ga.Dispose();
		}


		private void GameMain_MouseMove(object sender, MouseEventArgs e)
		{
			//			if(gs!=GameState.Play)return;
			//			
			//			MapTile[] oMapTile = new MapTile[3];
			//
			//			Bitmap backImg = SD.BackImage();
			//
			//			for(int i=oMap.Length-1;i>=0;i--)
			//			{
			//				if(oMap[i].GetCount()>0)
			//				{
			//					oMapTile[i] = oMap[i].TranPointToMapTile(e.X,e.Y);
			//					if(oMapTile[i]!=null)
			//					{
			//						if(oMapTile[i].ID>0)
			//						{
			//							Graphics g = this.CreateGraphics();
			//							g.DrawImage(backImg,0,0);
			//							Bitmap b = (Bitmap)Bitmap.FromFile(".\\Images\\" + oMapTile[i].ID + ".bmp",false);
			//							ScreenDraw.Color(b,100,100,100);
			//							g.DrawImage(b,oMapTile[i].X,oMapTile[i].Y,oMapTile[i].Width,oMapTile[i].Height);
			//						}
			//					}
			//					//SD.Flip(0,0);
			//					return;
			//				}
			//			}
			cursor.CursorPoint.X = e.X;
			cursor.CursorPoint.Y = e.Y;
		}

		private void btnConfig_Click(object sender, EventArgs e)
		{
			GameOption go = new GameOption(this.spl);
			if (go.ShowDialog() == DialogResult.OK)
			{
				options = go.OptionInfo;
			}
			go.Dispose();

			if (options.PlayMusic && gs == GameState.Play)
			{
				if (!spBg.IsPlaying)
				{
					spBg.FileName = spl.CurrentMusic();
					spBg.PlaySound();
				}
			}
			else
			{
				spBg.StopSound();
			}
		}

		private void SplashTimer_Tick(object sender, EventArgs e)
		{
			if (lbCaption.ForeColor == Color.Lime)
			{
				lbCaption.ForeColor = Color.Green;
			}
			else
			{
				lbCaption.ForeColor = Color.Lime;
			}

			if (gs == GameState.Start)
			{
                lbCaption.Text = ".NET:Ͽ쿪ʼϷ..";
			}
			else if (gs == GameState.Play)
			{
				if (this.pBar.Value < (this.pBar.Maximum/2))
				{
                    this.Text = ".NET:Ҫעʱ..";
				}
				else
				{
                    this.Text = ".NET:Ұ.";
				}
			}
			else if (gs == GameState.Win)
			{
                lbCaption.Text = ".NET:Ŀǰֻ3ͼ100Ļ..?";
				this.Text = lbCaption.Text;
			}
			else
			{
                lbCaption.Text = ".NET:ͣ";
			}
		}
	}
}