using System.Drawing;

namespace LLK.UI
{
	/// <summary>
	/// BombPoint ժҪ˵
	/// </summary>
	public class BombPoint
	{
		private Map oMap = null;
		private Bitmap oSurface = null;
		private Point oPoint = new Point(-1, -1);

		public BombPoint()
		{
		}

		public BombPoint(Map map, Bitmap surface, Point point)
		{
			oMap = map;
			oSurface = surface;
			oPoint = point;
		}

		public bool IsEmpty
		{
			get { return this.oMap == null || this.oPoint.X == -1 || this.oPoint.Y == -1 || this.oSurface == null; }
		}

		public void SetEmpty()
		{
			this.oMap = null;
			this.oPoint.X = -1;
			this.oPoint.Y = -1;
			this.oSurface = null;
		}

		public Map CurrentMap
		{
			get { return this.oMap; }
			set { this.oMap = value; }
		}

		public Bitmap CurrentSurface
		{
			get { return this.oSurface; }
			set { this.oSurface = value; }
		}

		public Point CurrentPoint
		{
			get { return this.oPoint; }
			set { this.oPoint = value; }
		}

		public int TransOffsetX(int srcX)
		{
			return srcX - ((Map.BombWidth - Map.TileWidth)/2);
		}

		public int TransOffsetY(int srcY)
		{
			return srcY - ((Map.BombHeight - Map.TileHeight)/2);
		}
	}
}