using System;
using System.Drawing;

namespace LLK.UI
{
	/// <summary>
	/// ScreenObject ժҪ˵
	/// </summary>
	public class ScreenObject
	{
		public Image[] objImage = new Image[39];
		public Image[] objImageL1 = new Image[39];
		public Image[] objImageL2 = new Image[39];
		public Bitmap[] objBombEff = new Bitmap[6];
		public Image objDot = null;

		public ScreenObject()
		{
			InitCreateL1L2Image();
			InitObjImage();
		}

		~ScreenObject()
		{
			foreach(Image img in objImage)
				if(img!=null)
				{
					img.Dispose();
				}
		}

		private void InitObjImage()
		{
			for(int i=0;i<39;i++)
			{
				objImage[i] = Image.FromFile(".\\Images\\" + (i+1).ToString() + ".bmp");
				objImageL1[i] = Image.FromFile(".\\Images\\" + (i+1).ToString() + "_L1.bmp");
				objImageL2[i] = Image.FromFile(".\\Images\\" + (i+1).ToString() + "_L2.bmp");
				if(i<6)
				{
					objBombEff[i] = (Bitmap)Bitmap.FromFile(".\\Images\\B" + (i+1).ToString() + ".bmp");
					objBombEff[i].MakeTransparent(Color.Black);
				}
			}
			objDot = Image.FromFile(".\\Images\\dots.gif");
		}

		private void InitCreateL1L2Image()
		{
			for(int i=1;i<40;i++)
			{
				if(System.IO.File.Exists(".\\Images\\" + i.ToString() + "_L1.bmp"))
					continue;
				Bitmap b = (Bitmap)Bitmap.FromFile(".\\Images\\" + i.ToString() + ".bmp",false);
				ScreenDraw.Color(b,-200,-200,-200);
				b.Save(".\\Images\\" + i.ToString() + "_L1.bmp");
			}
			for(int i=1;i<40;i++)
			{
				if(System.IO.File.Exists(".\\Images\\" + i.ToString() + "_L2.bmp"))
					continue;
				Bitmap b = (Bitmap)Bitmap.FromFile(".\\Images\\" + i.ToString() + ".bmp",false);
				ScreenDraw.Color(b,-150,-150,-150);
				b.Save(".\\Images\\" + i.ToString() + "_L2.bmp");
			}
		}
	}
}
