using System;
using System.IO;
using System.Text;
using System.Collections;
using System.Windows.Forms;

namespace LLK.UI
{
	/// <summary>
	/// SoundPlayList ժҪ˵
	/// </summary>
	public class SoundPlayList
	{
		private int musicIndex;
		private ArrayList mlist;

		public SoundPlayList()
		{			
			musicIndex = -1;
			mlist = new ArrayList();
			LoadMusicList();
		}

		public void ClearReInit()
		{
			musicIndex = -1;
			mlist.Clear();
			LoadMusicList();
		}

		public ArrayList MusicList
		{
			get
			{
				return this.mlist;
			}
		}

		public void Add(string MusicFile)
		{
			if(System.IO.File.Exists(MusicFile))
			{
				mlist.Add(MusicFile);
			}
		}

		public string CurrentMusic()
		{
			return Next();
		}

		private string Next()
		{
			if(musicIndex>mlist.Count-1)
			{
				musicIndex = 0;
			}
			else
			{
				musicIndex ++;
			}
			try
			{
				return (string)mlist[musicIndex];
			}
			catch
			{
				string appPath = Application.ExecutablePath.Substring(0,Application.ExecutablePath.LastIndexOf("\\"));
				return appPath + @"\Sounds\bg-01.mid";
			}
		}

		private void LoadMusicList()
		{
			string appPath = Application.ExecutablePath.Substring(0,Application.ExecutablePath.LastIndexOf("\\"));
			if(!File.Exists(".\\Music.list"))
			{				
				System.IO.StreamWriter wr = new StreamWriter(appPath + "\\Music.list",false,Encoding.Default);
				wr.WriteLine(".\\sounds\\bg-01.mid");
				wr.WriteLine(".\\sounds\\bg-02.mid");
				wr.WriteLine(".\\sounds\\bg-03.mid");
				wr.WriteLine(".\\sounds\\bg-04.mid");
				wr.WriteLine(".\\sounds\\bg-05.rmi");
				wr.WriteLine(".\\sounds\\bg-06.rmi");
				wr.WriteLine(".\\sounds\\bg-07.mid");
				wr.WriteLine(".\\sounds\\bg-08.rmi");
				wr.WriteLine(".\\sounds\\bg-09.rmi");
				wr.WriteLine(".\\sounds\\bg-10.rmi");
				wr.WriteLine(".\\sounds\\bg-11.rmi");
				wr.WriteLine(".\\sounds\\bg-12.rmi");				
				wr.Close();
			}
			System.IO.StreamReader sr = new StreamReader(appPath + "\\Music.list",Encoding.Default);
			string[] sl = sr.ReadToEnd().Split(System.Environment.NewLine.ToCharArray());

			for(int i=0;i<sl.Length;i++)
			{
				if(sl[i].Trim()!="")
				{
					this.Add(sl[i]);
					Console.WriteLine(sl[i]);
				}
			}

		}
	}
}
