﻿
------------------------------------
--初始化数据库
------------------------------------

IF not EXISTS (SELECT name FROM sys.databases WHERE name = N'{0}')
CREATE DATABASE [{0}]

!!!!!!

------------------------------------
--建立表
------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserSite]') AND type in (N'U'))
DROP TABLE [dbo].[UserSite]
GO

CREATE TABLE [dbo].[UserSite](
	[UserId] [int] NOT NULL,
	[SiteId] [int] NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_UserSite_CreatedOn]  DEFAULT (getdate()),
 CONSTRAINT [PK_UserSite] PRIMARY KEY CLUSTERED 
(
	[UserId] ASC,
	[SiteId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SiteUser]') AND type in (N'U'))
DROP TABLE [dbo].[SiteUser]
GO

CREATE TABLE [dbo].[SiteUser](
	[UserId] [int] IDENTITY(1,1) NOT NULL,
	[UserName] [nvarchar](50) NOT NULL,
	[Password] [nchar](32) NOT NULL,
	[Name] [nvarchar](20) NULL,
	[Email] [nvarchar](120) NULL,
	[MobilePhone] [nvarchar](20) NULL,
	[UserType] [int] NOT NULL CONSTRAINT [DF_User_UserType]  DEFAULT ((0)),
	[LastLoginIP] [nvarchar](60) NULL,
	[LastLoginOn] [datetime] NULL,
	[IsActive] [bit] NOT NULL CONSTRAINT [DF_User_IsActiv]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_User_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_User] PRIMARY KEY CLUSTERED 
(
	[UserId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CacheServer]') AND type in (N'U'))
DROP TABLE [dbo].[CacheServer]
GO

CREATE TABLE [dbo].[CacheServer](
	[ServerId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[ServerName] [nvarchar](300) NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_CacheServer_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_CacheServer_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_CacheServer] PRIMARY KEY CLUSTERED 
(
	[ServerId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Proxy]') AND type in (N'U'))
DROP TABLE [dbo].[Proxy]
GO

CREATE TABLE [dbo].[Proxy](
	[ProxyId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Address] [nvarchar](2000) NOT NULL,
	[Domain] [nvarchar](400) NULL,
	[UserName] [nvarchar](100) NULL,
	[Password] [nvarchar](100) NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_Proxy_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Proxy_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Proxy] PRIMARY KEY CLUSTERED 
(
	[ProxyId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ReplaceRule]') AND type in (N'U'))
DROP TABLE [dbo].[ReplaceRule]
GO

CREATE TABLE [dbo].[ReplaceRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NULL,
	[OldValue] [nvarchar](max) NULL,
	[NewValue] [nvarchar](max) NULL,
	[CaseSensitive] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_CaseSensitive]  DEFAULT ((1)),
	[IsRegex] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_IsRegex]  DEFAULT ((0)),
	[RuleType] [int] NOT NULL CONSTRAINT [DF_ReplaceRule_RuleType]  DEFAULT ((0)),
	[Priority] [int] NULL CONSTRAINT [DF_ReplaceRule_Priority]  DEFAULT ((1)),
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](1000) NULL,
	[ExactMatch] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_ExactMatch]  DEFAULT ((0)),
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_IsDefault]  DEFAULT ((0)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_ReplaceRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ReplaceRole] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

INSERT [ReplaceRule] ([SiteId],[Name],[OldValue],[NewValue],[CaseSensitive],[IsRegex],[RuleType],[Priority],[MatchUrl],[ExactMatch],[IsDefault],[IsEnable],[CreatedOn]) VALUES ( 0,N'PID',N'mm_[0-9]{8}_[0-9]_[0-9]',N'mm_13741296_0_0',0,1,0,1,0,0,1,1,GETDATE())
INSERT [ReplaceRule] ([SiteId],[Name],[OldValue],[NewValue],[CaseSensitive],[IsRegex],[RuleType],[Priority],[MatchUrl],[ExactMatch],[IsDefault],[IsEnable],[CreatedOn]) VALUES ( 0,N'google',N'pub-[0-9]{16}',N'pub-3560827693419030',0,1,0,1,0,0,1,1,GETDATE())
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitlePrefix]') AND type in (N'U'))
DROP TABLE [dbo].[TitlePrefix]
GO

CREATE TABLE [dbo].[TitlePrefix](
	[TitleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Value] [nvarchar](60) NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitlePrefix_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitlePrefix] PRIMARY KEY CLUSTERED 
(
	[TitleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeleteRule]') AND type in (N'U'))
DROP TABLE [dbo].[DeleteRule]
GO

CREATE TABLE [dbo].[DeleteRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[StartWord] [nvarchar](200) NOT NULL,
	[EndWord] [nvarchar](200) NOT NULL,
	[IncludeStartWord] [bit] NOT NULL CONSTRAINT [DF_DeleteRule_IncludeStartWord]  DEFAULT ((0)),
	[IncludeEndWord] [bit] NOT NULL,
	[CaseSensitive] [bit] NOT NULL CONSTRAINT [DF_DeleteRule_CaseSensitive]  DEFAULT ((0)),
	[DeleteType] [int] NOT NULL,
	[RuleType] [int] NOT NULL CONSTRAINT [DF_DeleteRule_RuleType]  DEFAULT ((0)),
	[Priority] [int] NULL CONSTRAINT [DF_DeleteRule_Priority]  DEFAULT ((1)),
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](1000) NULL,
	[ExactMatch] [bit] NOT NULL CONSTRAINT [DF_DeleteRule_ExactMatch]  DEFAULT ((0)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_DeleteRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_DeleteRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_DeleteRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NodeRule]') AND type in (N'U'))
DROP TABLE [dbo].[NodeRule]
GO

CREATE TABLE [dbo].[NodeRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[Expression] [nvarchar](2000) NOT NULL,
	[AttributeName] [nvarchar](200) NULL,
	[OperationValue] [nvarchar](max) NULL,
	[OperationIndex] [int] NOT NULL CONSTRAINT [DF_NodeRule_OperationIndex]  DEFAULT ((0)),
	[OperationType] [int] NOT NULL,
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](2000) NULL,
	[ExactMatch] [bit] NOT NULL CONSTRAINT [DF_NodeRule_ExactMatch]  DEFAULT ((0)),
	[Priority] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_NodeRule_IsEnable]  DEFAULT ((1)),
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_NodeRule_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_NodeRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_NodeRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OriginalVocabulary]') AND type in (N'U'))
DROP TABLE [dbo].[OriginalVocabulary]
GO

CREATE TABLE [dbo].[OriginalVocabulary](
	[VocabularyId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Vocabulary] [nvarchar](100) NOT NULL,
	[Synonyms] [nvarchar](100) NOT NULL,
	[CaseSensitive] [bit] NOT NULL CONSTRAINT [DF_OriginalVocabulary_CaseSensitive]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_OriginalVocabulary_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_OriginalVocabulary] PRIMARY KEY CLUSTERED 
(
	[VocabularyId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleExpression]') AND type in (N'U'))
DROP TABLE [dbo].[TitleExpression]
GO

CREATE TABLE [dbo].[TitleExpression](
	[ExpressionId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Value] [nvarchar](60) NOT NULL,
	[Priority] [int] NULL CONSTRAINT [DF_TitleExpression_Priority]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_TitleExpression_IsEnable]  DEFAULT ((1)),
 CONSTRAINT [PK_TitleExpression] PRIMARY KEY CLUSTERED 
(
	[ExpressionId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SiteSetting]') AND type in (N'U'))
DROP TABLE [dbo].[SiteSetting]
GO

CREATE TABLE [dbo].[SiteSetting](
	[SettingId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[IsActive] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_IsActive]  DEFAULT ((0)),
	[HeadCode] [nvarchar](max) NULL,
	[BodyCode] [nvarchar](max) NULL,
	[CacheExpireTime] [int] NULL,
	[Charset] [nvarchar](20) NULL,
	[ForbiddenFileType] [nvarchar](255) NULL,
	[CollectImage] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_CollectImage]  DEFAULT ((1)),
	[FakeOriginalTitle] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_FakeOriginal]  DEFAULT ((0)),
	[FakeOriginalContent] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_FakeOriginalContent]  DEFAULT ((0)),
	[StaticExtension] [nvarchar](20) NOT NULL CONSTRAINT [DF_SiteSetting_StaticExtension]  DEFAULT (N'html'),
	[EnableBillboard] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_EnableBillboard]  DEFAULT ((0)),
	[CustomInternalLinkKeyword] [nvarchar](255) NULL,
	[InternalSearchTemplate] [nvarchar](50) NOT NULL CONSTRAINT [DF_SiteSetting_InternalSearchTemplate]  DEFAULT (N'Search.htm'),
	[SupportPandomain] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_SupportPandomain]  DEFAULT ((0)),
	[UseProxy] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_UseProxy]  DEFAULT ((0)),
	[SynchronizeIECookie] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_SynchronizeIECookie]  DEFAULT ((0)),
	[CookieString] [nvarchar](4000) NULL,
	[EnableErrorLog] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_EnableErrorLog]  DEFAULT ((0)),
	[EnableStatisticalCode] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_EnableStatisticalCode]  DEFAULT ((1)),
	[ConvertToRedirectLink] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_ConvertToRedirectLink]  DEFAULT ((0)),
	[WorkMode] [int] NOT NULL CONSTRAINT [DF_SiteSetting_WorkMode]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_SiteSetting_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_SiteSetting] PRIMARY KEY CLUSTERED 
(
	[SettingId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Billboard]') AND type in (N'U'))
DROP TABLE [dbo].[Billboard]
GO

CREATE TABLE [dbo].[Billboard](
	[BillboardId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL CONSTRAINT [DF_Billboard_SiteId]  DEFAULT ((1)),
	[Name] [nvarchar](60) NOT NULL,
	[Url] [nvarchar](1000) NOT NULL,
	[DataType] [int] NOT NULL CONSTRAINT [DF_Billboard_DataType]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_Billboard_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Billboard_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Billboard] PRIMARY KEY CLUSTERED 
(
	[BillboardId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Site]') AND type in (N'U'))
DROP TABLE [dbo].[Site]
GO

CREATE TABLE [dbo].[Site](
	[SiteId] [int] IDENTITY(1,1) NOT NULL,
	[SiteName] [nvarchar](120) NOT NULL,
	[SiteProtoco] [nvarchar](50) NOT NULL,
	[SitePort] [int] NOT NULL,
	[SiteChildDomain] [nvarchar](60) NOT NULL,
	[SiteRootDomain] [nvarchar](60) NOT NULL,
	[Keyword] [nvarchar](120) NULL,
	[Description] [nvarchar](255) NULL,
	[ICPNumber] [nvarchar](60) NULL,
	[TargetSiteProtoco] [nvarchar](50) NOT NULL,
	[TargetSitePort] [int] NOT NULL,
	[TargetSiteChildDomain] [nvarchar](60) NOT NULL,
	[TargetSiteRootDomain] [nvarchar](60) NOT NULL,
	[Email] [nvarchar](120) NULL,
	[QQ] [nvarchar](60) NULL,
	[ForumUserName] [nvarchar](60) NULL,
	[CNZZCredentials] [nvarchar](200) NULL,
	[SiteStatus] [bit] NOT NULL CONSTRAINT [DF_Site_SiteStatus]  DEFAULT ((1)),
	[AuthorizedCode] [nvarchar](4000) NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Site_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Site] PRIMARY KEY CLUSTERED 
(
	[SiteId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BillboardExtractionRule]') AND type in (N'U'))
DROP TABLE [dbo].[BillboardExtractionRule]
GO

CREATE TABLE [dbo].[BillboardExtractionRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[BillboardId] [int] NOT NULL,
	[RuleName] [nvarchar](60) NOT NULL,
	[ExtractionRule] [nvarchar](255) NOT NULL,
	[KeywordCount] [int] NOT NULL CONSTRAINT [DF_BillboardExtractionRule_KeywordCount]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_BillboardExtractionRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_BillboardExtractionRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NotUpdatePage]') AND type in (N'U'))
DROP TABLE [dbo].[NotUpdatePage]
GO

CREATE TABLE [dbo].[NotUpdatePage](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[FilePath] [nvarchar](200) NOT NULL,
	[IsActive] [bit] NOT NULL CONSTRAINT [DF_NotUpdatePage_IsActive]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_NotUpdatePage_CreatedOn]  DEFAULT (getdate()),
 CONSTRAINT [PK_NotUpdatePage] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[InternalSiteSearch]') AND type in (N'U'))
DROP TABLE [dbo].[InternalSiteSearch]
GO

CREATE TABLE [dbo].[InternalSiteSearch](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[Url] [nvarchar](1000) NOT NULL,
	[ContentExpression] [nvarchar](2000) NOT NULL,
	[ChildExpression] [nvarchar](2000) NOT NULL,
	[Encoding] [nvarchar](50) NULL,
	[NoResultText] [nvarchar](60) NULL,
	[ContentTemplate] [nvarchar](2000) NULL,
	[ContentOutTemplate] [nvarchar](2000) NULL,
	[RelatedKeywordExpression] [nvarchar](2000) NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_InternalSiteSearch_IsActive]  DEFAULT ((1)),
	[IsDefault] [bit] NOT NULL,
	[Priority] [int] NOT NULL CONSTRAINT [DF_InternalSiteSearch_Priority]  DEFAULT ((10)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_InternalSiteSearch_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_InternalSiteSearch] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UrlEncodingRule]') AND type in (N'U'))
DROP TABLE [dbo].[UrlEncodingRule]
GO

CREATE TABLE [dbo].[UrlEncodingRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[TagName] [nvarchar](40) NOT NULL,
	[AttributeName] [nvarchar](200) NULL,
	[DefaultFileType] [nvarchar](40) NULL,
	[Priority] [int] NULL CONSTRAINT [DF_UrlEncodingRule_Priority]  DEFAULT ((1)),
	[KeepOriginalFileType] [bit] NOT NULL CONSTRAINT [DF_UrlEncodingRule_KeepOriginalFileType]  DEFAULT ((0)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_UrlEncodingRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_UrlEncodingRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_UrlEncodingRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NonStaticUrl]') AND type in (N'U'))
DROP TABLE [dbo].[NonStaticUrl]
GO

CREATE TABLE [dbo].[NonStaticUrl](
	[UrlId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](200) NOT NULL,
	[Url] [nvarchar](4000) NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_NonStaticUrl_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_NonStaticUrl_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_NonStaticUrl] PRIMARY KEY CLUSTERED 
(
	[UrlId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MultiSite]') AND type in (N'U'))
DROP TABLE [dbo].[MultiSite]
GO

CREATE TABLE [dbo].[MultiSite](
	[MultiSiteId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[SiteName] [nvarchar](200) NOT NULL,
	[RootDomain] [nvarchar](200) NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_MultiSite_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_MultiSite_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_MultiSite] PRIMARY KEY CLUSTERED 
(
	[MultiSiteId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DomainSetting]') AND type in (N'U'))
DROP TABLE [dbo].[DomainSetting]
GO

CREATE TABLE [dbo].[DomainSetting](
	[DomainId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[DomainName] [nvarchar](200) NULL,
	[Domain] [nvarchar](200) NOT NULL,
	[Charset] [nvarchar](20) NULL CONSTRAINT [DF_Table_1_Priority]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_Domain_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Domain_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Domain] PRIMARY KEY CLUSTERED 
(
	[DomainId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ContentExtractionRule]') AND type in (N'U'))
DROP TABLE [dbo].[ContentExtractionRule]
GO

CREATE TABLE [dbo].[ContentExtractionRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[Url] [nvarchar](1000) NOT NULL,
	[ContentExpression] [nvarchar](2000) NOT NULL,
	[ChildExpression] [nvarchar](2000) NOT NULL,
	[Encoding] [nvarchar](50) NULL,
	[NoResultText] [nvarchar](60) NULL,
	[ContentTemplate] [nvarchar](2000) NULL,
	[ContentOutTemplate] [nvarchar](2000) NULL,
	[IsConvertToLocalUrl] [bit] NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_ContentExtractionRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_ContentExtractionRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ContentExtractionRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleOriginalRule]') AND type in (N'U'))
DROP TABLE [dbo].[TitleOriginalRule]
GO

CREATE TABLE [dbo].[TitleOriginalRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](60) NOT NULL,
	[RuleType] [int] NOT NULL,
	[Delimiter] [nvarchar](60) NULL,
	[Count] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](2000) NULL,
	[ExactMatch] [bit] NOT NULL,
	[Priority] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[IsDefault] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleOriginalRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleOriginal]') AND type in (N'U'))
DROP TABLE [dbo].[TitleOriginal]
GO

CREATE TABLE [dbo].[TitleOriginal](
	[OriginalId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[Vocabulary] [nvarchar](1000) NOT NULL,
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_TitleOriginal_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitleOriginal_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleOriginal] PRIMARY KEY CLUSTERED 
(
	[OriginalId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleCategory]') AND type in (N'U'))
DROP TABLE [dbo].[TitleCategory]
GO

CREATE TABLE [dbo].[TitleCategory](
	[CategoryId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryName] [nvarchar](100) NOT NULL,
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_TitleCategory_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitleCategory_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleCategory] PRIMARY KEY CLUSTERED 
(
	[CategoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PageTitle]') AND type in (N'U'))
DROP TABLE [dbo].[PageTitle]
GO

CREATE TABLE [dbo].[PageTitle](
	[PageId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[PageIdentity] [nvarchar](36) NOT NULL,
	[Title] [nvarchar](2000) NOT NULL,
	[OldTitle] [nvarchar](2000) NOT NULL,
	[TitleMainPart] [nvarchar](2000) NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_PageTitle_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_PageTitle] PRIMARY KEY CLUSTERED 
(
	[PageId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( 1,0,N'960*90',N'//script[text()[contains(.,''width = 960'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''960*90'')]]|//script[text()[contains(.,''width=960'') and contains(.,''height=90'')]]|//iframe[@width="960" and @height="90"]|//script[text()[contains(.,''960*90'')]]|//script[text()[contains(.,''960×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636906" width="960" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 12:59:30',N'2013-4-11 13:25:38')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( 1,0,N'960*60',N'//script[text()[contains(.,''width = 960'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''960*60'')]]|//script[text()[contains(.,''width=960'') and contains(.,''height=60'')]]|//iframe[@width="960" and @height="60"]|//script[text()[contains(.,''960*60'')]]|//script[text()[contains(.,''960×60'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636907" width="960" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:23:42',N'2013-4-11 13:27:42')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'950*90',N'//script[text()[contains(.,''width = 950'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''950*90'')]]|//script[text()[contains(.,''width=950'') and contains(.,''height=90'')]]|//iframe[@width="950" and @height="90"]|//script[text()[contains(.,''950*90'')]]|//script[text()[contains(.,''950×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636908" width="950" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:29:09')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'760*90',N'//script[text()[contains(.,''width = 760'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''760*90'')]]|//script[text()[contains(.,''width=760'') and contains(.,''height=90'')]]|//iframe[@width="760" and @height="90"]|//script[text()[contains(.,''760*90'')]]|//script[text()[contains(.,''760×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636909" width="760" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:29:58')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'728*90',N'//script[text()[contains(.,''width = 728'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''728*90'')]]|//script[text()[contains(.,''width=728'') and contains(.,''height=90'')]]|//iframe[@width="728" and @height="90"]|//script[text()[contains(.,''728*90'')]]|//script[text()[contains(.,''728×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636910" width="728" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:30:35')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'728*15',N'//script[text()[contains(.,''width = 728'') and contains(.,''height = 15'')]]|//script[text()[contains(.,''728*15'')]]|//script[text()[contains(.,''width=728'') and contains(.,''height=15'')]]|//iframe[@width="728" and @height="15"]|//script[text()[contains(.,''728*15'')]]|//script[text()[contains(.,''728×15'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636911" width="728" height="15" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:31:10')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'640*60',N'//script[text()[contains(.,''width = 640'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''640*60'')]]|//script[text()[contains(.,''width=640'') and contains(.,''height=60'')]]|//iframe[@width="640" and @height="60"]|//script[text()[contains(.,''640*60'')]]|//script[text()[contains(.,''640×60'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636912" width="640" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:31:54')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'580*90',N'//script[text()[contains(.,''width = 580'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''580*90'')]]|//script[text()[contains(.,''width=580'') and contains(.,''height=90'')]]|//iframe[@width="580" and @height="90"]|//script[text()[contains(.,''580*90'')]]|//script[text()[contains(.,''580×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636913" width="580" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:33:20')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'500*200',N'//script[text()[contains(.,''width = 500'') and contains(.,''height = 200'')]]|//script[text()[contains(.,''500*200'')]]|//script[text()[contains(.,''width=500'') and contains(.,''height=200'')]]|//iframe[@width="500" and @height="200"]|//script[text()[contains(.,''500*200'')]]|//script[text()[contains(.,''500×200'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636914" width="500" height="200" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:33:55')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'480*160',N'//script[text()[contains(.,''width = 480'') and contains(.,''height = 160'')]]|//script[text()[contains(.,''480*160'')]]|//script[text()[contains(.,''width=480'') and contains(.,''height=160'')]]|//iframe[@width="480" and @height="160"]|//script[text()[contains(.,''480*160'')]]|//script[text()[contains(.,''480×160'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636915" width="480" height="160" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:34:34')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'468*60',N'//script[text()[contains(.,''width = 468'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''468*60'')]]|//script[text()[contains(.,''width=468'') and contains(.,''height=60'')]]|//iframe[@width="468" and @height="60"]|//script[text()[contains(.,''468*60'')]]|//script[text()[contains(.,''468×60'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636916" width="468" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:35:12')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'468*15',N'//script[text()[contains(.,''width = 468'') and contains(.,''height = 15'')]]|//script[text()[contains(.,''468*15'')]]|//script[text()[contains(.,''width=468'') and contains(.,''height=15'')]]|//iframe[@width="468" and @height="15"]|//script[text()[contains(.,''468*15'')]]|//script[text()[contains(.,''468×15'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636917" width="468" height="15" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:35:51')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'460*60',N'//script[text()[contains(.,''width = 460'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''460*60'')]]|//script[text()[contains(.,''width=460'') and contains(.,''height=60'')]]|//iframe[@width="460" and @height="60"]|//script[text()[contains(.,''460*60'')]]|//script[text()[contains(.,''460×60'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636918" width="460" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:36:30')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'360*300',N'//script[text()[contains(.,''width = 360'') and contains(.,''height = 300'')]]|//script[text()[contains(.,''360*300'')]]|//script[text()[contains(.,''width=360'') and contains(.,''height=300'')]]|//iframe[@width="360" and @height="300"]|//script[text()[contains(.,''360*300'')]]|//script[text()[contains(.,''360×300'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636919" width="360" height="300" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:37:31')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'336*280',N'//script[text()[contains(.,''width = 336'') and contains(.,''height = 280'')]]|//script[text()[contains(.,''336*280'')]]|//script[text()[contains(.,''width=336'') and contains(.,''height=280'')]]|//iframe[@width="336" and @height="280"]|//script[text()[contains(.,''336*280'')]]|//script[text()[contains(.,''336×280'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636920" width="336" height="280" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:38:07')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'320*50',N'//script[text()[contains(.,''width = 320'') and contains(.,''height = 50'')]]|//script[text()[contains(.,''320*50'')]]|//script[text()[contains(.,''width=320'') and contains(.,''height=50'')]]|//iframe[@width="320" and @height="50"]|//script[text()[contains(.,''320*50'')]]|//script[text()[contains(.,''320×50'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636921" width="320" height="50" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:38:37')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'300*600',N'//script[text()[contains(.,''width = 300'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''300*600'')]]|//script[text()[contains(.,''width=300'') and contains(.,''height=600'')]]|//iframe[@width="300" and @height="600"]|//script[text()[contains(.,''300*600'')]]|//script[text()[contains(.,''300×600'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636922" width="300" height="600" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:39:26')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'300*250',N'//script[text()[contains(.,''width = 300'') and contains(.,''height = 250'')]]|//script[text()[contains(.,''300*250'')]]|//script[text()[contains(.,''width=300'') and contains(.,''height=250'')]]|//iframe[@width="300" and @height="250"]|//script[text()[contains(.,''300*250'')]]|//script[text()[contains(.,''300×250'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636923" width="300" height="250" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:40:01')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'250*250',N'//script[text()[contains(.,''width = 250'') and contains(.,''height = 250'')]]|//script[text()[contains(.,''250*250'')]]|//script[text()[contains(.,''width=250'') and contains(.,''height=250'')]]|//iframe[@width="250" and @height="250"]|//script[text()[contains(.,''250*250'')]]|//script[text()[contains(.,''250×250'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636924" width="250" height="250" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:40:26')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'234*60',N'//script[text()[contains(.,''width = 234'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''234*60'')]]|//script[text()[contains(.,''width=234'') and contains(.,''height=60'')]]|//iframe[@width="234" and @height="60"]|//script[text()[contains(.,''234*60'')]]|//script[text()[contains(.,''234×60'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636925" width="234" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:40:57')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'200*200',N'//script[text()[contains(.,''width = 200'') and contains(.,''height = 200'')]]|//script[text()[contains(.,''200*200'')]]|//script[text()[contains(.,''width=200'') and contains(.,''height=200'')]]|//iframe[@width="200" and @height="200"]|//script[text()[contains(.,''200*200'')]]|//script[text()[contains(.,''200×200'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636926" width="200" height="200" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:41:27')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'200*90',N'//script[text()[contains(.,''width = 200'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''200*90'')]]|//script[text()[contains(.,''width=200'') and contains(.,''height=90'')]]|//iframe[@width="200" and @height="90"]|//script[text()[contains(.,''200*90'')]]|//script[text()[contains(.,''200×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636927" width="200" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:41:55')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'180*150',N'//script[text()[contains(.,''width = 180'') and contains(.,''height = 150'')]]|//script[text()[contains(.,''180*150'')]]|//script[text()[contains(.,''width=180'') and contains(.,''height=150'')]]|//iframe[@width="180" and @height="150"]|//script[text()[contains(.,''180*150'')]]|//script[text()[contains(.,''180×150'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636928" width="180" height="150" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:42:28')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'180*90',N'//script[text()[contains(.,''width = 180'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''180*90'')]]|//script[text()[contains(.,''width=180'') and contains(.,''height=90'')]]|//iframe[@width="180" and @height="90"]|//script[text()[contains(.,''180*90'')]]|//script[text()[contains(.,''180×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636929" width="180" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:42:55')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'160*600',N'//script[text()[contains(.,''width = 160'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''160*600'')]]|//script[text()[contains(.,''width=160'') and contains(.,''height=600'')]]|//iframe[@width="160" and @height="600"]|//script[text()[contains(.,''160*600'')]]|//script[text()[contains(.,''160×600'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636930" width="160" height="600" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:43:34')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'160*90',N'//script[text()[contains(.,''width = 160'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''160*90'')]]|//script[text()[contains(.,''width=160'') and contains(.,''height=90'')]]|//iframe[@width="160" and @height="90"]|//script[text()[contains(.,''160*90'')]]|//script[text()[contains(.,''160×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636931" width="160" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:44:03')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'125*125',N'//script[text()[contains(.,''width = 125'') and contains(.,''height = 125'')]]|//script[text()[contains(.,''125*125'')]]|//script[text()[contains(.,''width=125'') and contains(.,''height=125'')]]|//iframe[@width="125" and @height="125"]|//script[text()[contains(.,''125*125'')]]|//script[text()[contains(.,''125×125'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636932" width="125" height="125" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:44:37')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'120*600',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''120*600'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=600'')]]|//iframe[@width="120" and @height="600"]|//script[text()[contains(.,''120*600'')]]|//script[text()[contains(.,''120×600'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636933" width="120" height="600" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:45:03')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'120*240',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 240'')]]|//script[text()[contains(.,''120*240'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=240'')]]|//iframe[@width="120" and @height="240"]|//script[text()[contains(.,''120*240'')]]|//script[text()[contains(.,''120×240'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636934" width="120" height="240" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:45:29')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'120*90',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''120*90'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=90'')]]|//iframe[@width="120" and @height="90"]|//script[text()[contains(.,''120*90'')]]|//script[text()[contains(.,''120×90'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636935" width="120" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:45:59')
GO

!!!!!!

------------------------------------
--建立存储过程
------------------------------------

/******************************************************************
* 表名：Billboard
* 时间：2012/12/20 20:56:46
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([BillboardId])+1 FROM [Billboard]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_Exists
@BillboardId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [Billboard] WHERE BillboardId=@BillboardId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_ADD
@BillboardId int output,
@SiteId int,
@Name nvarchar(60),
@Url nvarchar(1000),
@DataType int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [Billboard](
	[SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@DataType,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @BillboardId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_Update
@BillboardId int,
@SiteId int,
@Name nvarchar(60),
@Url nvarchar(1000),
@DataType int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [Billboard] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[DataType] = @DataType,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE BillboardId=@BillboardId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_Delete
@BillboardId int
 AS 
	DELETE [Billboard]
	 WHERE BillboardId=@BillboardId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_GetModel
@BillboardId int
 AS 
	SELECT 
	BillboardId,SiteId,Name,Url,DataType,IsEnable,CreatedOn,UpdatedOn
	 FROM [Billboard]
	 WHERE BillboardId=@BillboardId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_GetList
 AS 
	SELECT 
	BillboardId,SiteId,Name,Url,DataType,IsEnable,CreatedOn,UpdatedOn
	 FROM [Billboard]

GO


/******************************************************************
* 表名：BillboardExtractionRule
* 时间：2012/12/20 20:56:48
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [BillboardExtractionRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [BillboardExtractionRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_ADD
@RuleId int output,
@BillboardId int,
@RuleName nvarchar(60),
@ExtractionRule nvarchar(255),
@KeywordCount int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [BillboardExtractionRule](
	[BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@BillboardId,@RuleName,@ExtractionRule,@KeywordCount,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_Update
@RuleId int,
@BillboardId int,
@RuleName nvarchar(60),
@ExtractionRule nvarchar(255),
@KeywordCount int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [BillboardExtractionRule] SET 
	[BillboardId] = @BillboardId,[RuleName] = @RuleName,[ExtractionRule] = @ExtractionRule,[KeywordCount] = @KeywordCount,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_Delete
@RuleId int
 AS 
	DELETE [BillboardExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,BillboardId,RuleName,ExtractionRule,KeywordCount,IsEnable,CreatedOn,UpdatedOn
	 FROM [BillboardExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_GetList
 AS 
	SELECT 
	RuleId,BillboardId,RuleName,ExtractionRule,KeywordCount,IsEnable,CreatedOn,UpdatedOn
	 FROM [BillboardExtractionRule]

GO


/******************************************************************
* 表名：CacheServer
* 时间：2012/12/20 20:56:49
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([ServerId])+1 FROM [CacheServer]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_Exists
@ServerId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [CacheServer] WHERE ServerId=@ServerId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_ADD
@ServerId int output,
@SiteId int,
@ServerName nvarchar(300),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [CacheServer](
	[SiteId],[ServerName],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@ServerName,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @ServerId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_Update
@ServerId int,
@SiteId int,
@ServerName nvarchar(300),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [CacheServer] SET 
	[SiteId] = @SiteId,[ServerName] = @ServerName,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE ServerId=@ServerId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_Delete
@ServerId int
 AS 
	DELETE [CacheServer]
	 WHERE ServerId=@ServerId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_GetModel
@ServerId int
 AS 
	SELECT 
	ServerId,SiteId,ServerName,IsEnable,CreatedOn,UpdatedOn
	 FROM [CacheServer]
	 WHERE ServerId=@ServerId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_GetList
 AS 
	SELECT 
	ServerId,SiteId,ServerName,IsEnable,CreatedOn,UpdatedOn
	 FROM [CacheServer]

GO


/******************************************************************
* 表名：DeleteRule
* 时间：2012/12/20 20:56:50
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [DeleteRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [DeleteRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(20),
@StartWord nvarchar(200),
@EndWord nvarchar(200),
@IncludeStartWord bit,
@IncludeEndWord bit,
@CaseSensitive bit,
@DeleteType int,
@RuleType int,
@Priority int,
@MatchUrl bit,
@Url nvarchar(1000),
@ExactMatch bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [DeleteRule](
	[SiteId],[Name],[StartWord],[EndWord],[IncludeStartWord],[IncludeEndWord],[CaseSensitive],[DeleteType],[RuleType],[Priority],[MatchUrl],[Url],[ExactMatch],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@StartWord,@EndWord,@IncludeStartWord,@IncludeEndWord,@CaseSensitive,@DeleteType,@RuleType,@Priority,@MatchUrl,@Url,@ExactMatch,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(20),
@StartWord nvarchar(200),
@EndWord nvarchar(200),
@IncludeStartWord bit,
@IncludeEndWord bit,
@CaseSensitive bit,
@DeleteType int,
@RuleType int,
@Priority int,
@MatchUrl bit,
@Url nvarchar(1000),
@ExactMatch bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [DeleteRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[StartWord] = @StartWord,[EndWord] = @EndWord,[IncludeStartWord] = @IncludeStartWord,[IncludeEndWord] = @IncludeEndWord,[CaseSensitive] = @CaseSensitive,[DeleteType] = @DeleteType,[RuleType] = @RuleType,[Priority] = @Priority,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_Delete
@RuleId int
 AS 
	DELETE [DeleteRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,StartWord,EndWord,IncludeStartWord,IncludeEndWord,CaseSensitive,DeleteType,RuleType,Priority,MatchUrl,Url,ExactMatch,IsEnable,CreatedOn,UpdatedOn
	 FROM [DeleteRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,StartWord,EndWord,IncludeStartWord,IncludeEndWord,CaseSensitive,DeleteType,RuleType,Priority,MatchUrl,Url,ExactMatch,IsEnable,CreatedOn,UpdatedOn
	 FROM [DeleteRule]

GO


/******************************************************************
* 表名：InternalSiteSearch
* 时间：2012/12/30 19:24:03
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [InternalSiteSearch]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [InternalSiteSearch] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_ADD
@Id int output,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@RelatedKeywordExpression nvarchar(2000),
@IsEnable bit,
@IsDefault bit,
@Priority int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [InternalSiteSearch](
	[SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[NoResultText],[ContentTemplate],[ContentOutTemplate],[RelatedKeywordExpression],[IsEnable],[IsDefault],[Priority],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@ContentExpression,@ChildExpression,@Encoding,@NoResultText,@ContentTemplate,@ContentOutTemplate,@RelatedKeywordExpression,@IsEnable,@IsDefault,@Priority,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_Update
@Id int,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@RelatedKeywordExpression nvarchar(2000),
@IsEnable bit,
@IsDefault bit,
@Priority int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [InternalSiteSearch] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[ContentExpression] = @ContentExpression,[ChildExpression] = @ChildExpression,[Encoding] = @Encoding,[NoResultText] = @NoResultText,[ContentTemplate] = @ContentTemplate,[ContentOutTemplate] = @ContentOutTemplate,[RelatedKeywordExpression] = @RelatedKeywordExpression,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[Priority] = @Priority,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_Delete
@Id int
 AS 
	DELETE [InternalSiteSearch]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,RelatedKeywordExpression,IsEnable,IsDefault,Priority,CreatedOn,UpdatedOn
	 FROM [InternalSiteSearch]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_GetList
 AS 
	SELECT 
	Id,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,RelatedKeywordExpression,IsEnable,IsDefault,Priority,CreatedOn,UpdatedOn
	 FROM [InternalSiteSearch]

GO


/******************************************************************
* 表名：NodeRule
* 时间：2012/12/20 20:56:53
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [NodeRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [NodeRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(100),
@Expression nvarchar(2000),
@AttributeName nvarchar(200),
@OperationValue nvarchar(MAX),
@OperationIndex int,
@OperationType int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [NodeRule](
	[SiteId],[Name],[Expression],[AttributeName],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Expression,@AttributeName,@OperationValue,@OperationIndex,@OperationType,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(100),
@Expression nvarchar(2000),
@AttributeName nvarchar(200),
@OperationValue nvarchar(MAX),
@OperationIndex int,
@OperationType int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [NodeRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Expression] = @Expression,[AttributeName] = @AttributeName,[OperationValue] = @OperationValue,[OperationIndex] = @OperationIndex,[OperationType] = @OperationType,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Delete
@RuleId int
 AS 
	DELETE [NodeRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,Expression,AttributeName,OperationValue,OperationIndex,OperationType,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [NodeRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,Expression,AttributeName,OperationValue,OperationIndex,OperationType,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [NodeRule]

GO

/******************************************************************
* 表名：NotUpdatePage
* 时间：2012/12/20 20:56:54
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [NotUpdatePage]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [NotUpdatePage] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_ADD
@Id int output,
@SiteId int,
@FilePath nvarchar(200),
@IsActive bit,
@CreatedOn datetime

 AS 
	INSERT INTO [NotUpdatePage](
	[SiteId],[FilePath],[IsActive],[CreatedOn]
	)VALUES(
	@SiteId,@FilePath,@IsActive,@CreatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_Update
@Id int,
@SiteId int,
@FilePath nvarchar(200),
@IsActive bit,
@CreatedOn datetime
 AS 
	UPDATE [NotUpdatePage] SET 
	[SiteId] = @SiteId,[FilePath] = @FilePath,[IsActive] = @IsActive,[CreatedOn] = @CreatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_Delete
@Id int
 AS 
	DELETE [NotUpdatePage]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,FilePath,IsActive,CreatedOn
	 FROM [NotUpdatePage]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_GetList
 AS 
	SELECT 
	Id,SiteId,FilePath,IsActive,CreatedOn
	 FROM [NotUpdatePage]

GO


/******************************************************************
* 表名：OriginalVocabulary
* 时间：2012/12/20 20:56:56
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([VocabularyId])+1 FROM [OriginalVocabulary]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_Exists
@VocabularyId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [OriginalVocabulary] WHERE VocabularyId=@VocabularyId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_ADD
@VocabularyId int output,
@SiteId int,
@Vocabulary nvarchar(1000),
@Synonyms nvarchar(100),
@CaseSensitive bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [OriginalVocabulary](
	[SiteId],[Vocabulary],[Synonyms],[CaseSensitive],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Vocabulary,@Synonyms,@CaseSensitive,@CreatedOn,@UpdatedOn
	)
	SET @VocabularyId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_Update
@VocabularyId int,
@SiteId int,
@Vocabulary nvarchar(1000),
@Synonyms nvarchar(100),
@CaseSensitive bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [OriginalVocabulary] SET 
	[SiteId] = @SiteId,[Vocabulary] = @Vocabulary,[Synonyms] = @Synonyms,[CaseSensitive] = @CaseSensitive,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE VocabularyId=@VocabularyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_Delete
@VocabularyId int
 AS 
	DELETE [OriginalVocabulary]
	 WHERE VocabularyId=@VocabularyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_GetModel
@VocabularyId int
 AS 
	SELECT 
	VocabularyId,SiteId,Vocabulary,Synonyms,CaseSensitive,CreatedOn,UpdatedOn
	 FROM [OriginalVocabulary]
	 WHERE VocabularyId=@VocabularyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_GetList
 AS 
	SELECT 
	VocabularyId,SiteId,Vocabulary,Synonyms,CaseSensitive,CreatedOn,UpdatedOn
	 FROM [OriginalVocabulary]

GO


/******************************************************************
* 表名：Proxy
* 时间：2012/12/20 20:56:57
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([ProxyId])+1 FROM [Proxy]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_Exists
@ProxyId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [Proxy] WHERE ProxyId=@ProxyId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_ADD
@ProxyId int output,
@SiteId int,
@Address nvarchar(2000),
@Domain nvarchar(400),
@UserName nvarchar(100),
@Password nvarchar(100),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [Proxy](
	[SiteId],[Address],[Domain],[UserName],[Password],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Address,@Domain,@UserName,@Password,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @ProxyId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_Update
@ProxyId int,
@SiteId int,
@Address nvarchar(2000),
@Domain nvarchar(400),
@UserName nvarchar(100),
@Password nvarchar(100),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [Proxy] SET 
	[SiteId] = @SiteId,[Address] = @Address,[Domain] = @Domain,[UserName] = @UserName,[Password] = @Password,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE ProxyId=@ProxyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_Delete
@ProxyId int
 AS 
	DELETE [Proxy]
	 WHERE ProxyId=@ProxyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_GetModel
@ProxyId int
 AS 
	SELECT 
	ProxyId,SiteId,Address,Domain,UserName,Password,IsEnable,CreatedOn,UpdatedOn
	 FROM [Proxy]
	 WHERE ProxyId=@ProxyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_GetList
 AS 
	SELECT 
	ProxyId,SiteId,Address,Domain,UserName,Password,IsEnable,CreatedOn,UpdatedOn
	 FROM [Proxy]

GO


/******************************************************************
* 表名：ReplaceRule
* 时间：2012/12/20 20:56:59
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [ReplaceRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ReplaceRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(20),
@OldValue nvarchar(MAX),
@NewValue nvarchar(MAX),
@CaseSensitive bit,
@IsRegex bit,
@RuleType int,
@Priority int,
@MatchUrl bit,
@Url nvarchar(1000),
@ExactMatch bit,
@IsDefault bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ReplaceRule](
	[SiteId],[Name],[OldValue],[NewValue],[CaseSensitive],[IsRegex],[RuleType],[Priority],[MatchUrl],[Url],[ExactMatch],[IsDefault],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@OldValue,@NewValue,@CaseSensitive,@IsRegex,@RuleType,@Priority,@MatchUrl,@Url,@ExactMatch,@IsDefault,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(20),
@OldValue nvarchar(MAX),
@NewValue nvarchar(MAX),
@CaseSensitive bit,
@IsRegex bit,
@RuleType int,
@Priority int,
@MatchUrl bit,
@Url nvarchar(1000),
@ExactMatch bit,
@IsDefault bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ReplaceRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[OldValue] = @OldValue,[NewValue] = @NewValue,[CaseSensitive] = @CaseSensitive,[IsRegex] = @IsRegex,[RuleType] = @RuleType,[Priority] = @Priority,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[IsDefault] = @IsDefault,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_Delete
@RuleId int
 AS 
	DELETE [ReplaceRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,OldValue,NewValue,CaseSensitive,IsRegex,RuleType,Priority,MatchUrl,Url,ExactMatch,IsDefault,IsEnable,CreatedOn,UpdatedOn
	 FROM [ReplaceRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,OldValue,NewValue,CaseSensitive,IsRegex,RuleType,Priority,MatchUrl,Url,ExactMatch,IsDefault,IsEnable,CreatedOn,UpdatedOn
	 FROM [ReplaceRule]

GO


/******************************************************************
* 表名：Site
* 时间：2012/12/30 19:20:12
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([SiteId])+1 FROM [Site]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_Exists
@SiteId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [Site] WHERE SiteId=@SiteId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_ADD
@SiteId int output,
@SiteName nvarchar(120),
@SiteProtoco nvarchar(50),
@SitePort int,
@SiteChildDomain nvarchar(60),
@SiteRootDomain nvarchar(60),
@Keyword nvarchar(120),
@Description nvarchar(255),
@ICPNumber nvarchar(60),
@TargetSiteProtoco nvarchar(50),
@TargetSitePort int,
@TargetSiteChildDomain nvarchar(60),
@TargetSiteRootDomain nvarchar(60),
@Email nvarchar(120),
@QQ nvarchar(60),
@ForumUserName nvarchar(60),
@CNZZCredentials nvarchar(200),
@SiteStatus bit,
@AuthorizedCode nvarchar(4000),
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [Site](
	[SiteName],[SiteProtoco],[SitePort],[SiteChildDomain],[SiteRootDomain],[Keyword],[Description],[ICPNumber],[TargetSiteProtoco],[TargetSitePort],[TargetSiteChildDomain],[TargetSiteRootDomain],[Email],[QQ],[ForumUserName],[CNZZCredentials],[SiteStatus],[AuthorizedCode],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteName,@SiteProtoco,@SitePort,@SiteChildDomain,@SiteRootDomain,@Keyword,@Description,@ICPNumber,@TargetSiteProtoco,@TargetSitePort,@TargetSiteChildDomain,@TargetSiteRootDomain,@Email,@QQ,@ForumUserName,@CNZZCredentials,@SiteStatus,@AuthorizedCode,@CreatedOn,@UpdatedOn
	)
	SET @SiteId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_Update
@SiteId int,
@SiteName nvarchar(120),
@SiteProtoco nvarchar(50),
@SitePort int,
@SiteChildDomain nvarchar(60),
@SiteRootDomain nvarchar(60),
@Keyword nvarchar(120),
@Description nvarchar(255),
@ICPNumber nvarchar(60),
@TargetSiteProtoco nvarchar(50),
@TargetSitePort int,
@TargetSiteChildDomain nvarchar(60),
@TargetSiteRootDomain nvarchar(60),
@Email nvarchar(120),
@QQ nvarchar(60),
@ForumUserName nvarchar(60),
@CNZZCredentials nvarchar(200),
@SiteStatus bit,
@AuthorizedCode nvarchar(4000),
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [Site] SET 
	[SiteName] = @SiteName,[SiteProtoco] = @SiteProtoco,[SitePort] = @SitePort,[SiteChildDomain] = @SiteChildDomain,[SiteRootDomain] = @SiteRootDomain,[Keyword] = @Keyword,[Description] = @Description,[ICPNumber] = @ICPNumber,[TargetSiteProtoco] = @TargetSiteProtoco,[TargetSitePort] = @TargetSitePort,[TargetSiteChildDomain] = @TargetSiteChildDomain,[TargetSiteRootDomain] = @TargetSiteRootDomain,[Email] = @Email,[QQ] = @QQ,[ForumUserName] = @ForumUserName,[CNZZCredentials] = @CNZZCredentials,[SiteStatus] = @SiteStatus,[AuthorizedCode] = @AuthorizedCode,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_Delete
@SiteId int
 AS 
	DELETE [Site]
	 WHERE SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_GetModel
@SiteId int
 AS 
	SELECT 
	SiteId,SiteName,SiteProtoco,SitePort,SiteChildDomain,SiteRootDomain,Keyword,Description,ICPNumber,TargetSiteProtoco,TargetSitePort,TargetSiteChildDomain,TargetSiteRootDomain,Email,QQ,ForumUserName,CNZZCredentials,SiteStatus,AuthorizedCode,CreatedOn,UpdatedOn
	 FROM [Site]
	 WHERE SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_GetList
 AS 
	SELECT 
	SiteId,SiteName,SiteProtoco,SitePort,SiteChildDomain,SiteRootDomain,Keyword,Description,ICPNumber,TargetSiteProtoco,TargetSitePort,TargetSiteChildDomain,TargetSiteRootDomain,Email,QQ,ForumUserName,CNZZCredentials,SiteStatus,AuthorizedCode,CreatedOn,UpdatedOn
	 FROM [Site]

GO


/******************************************************************
* 表名：SiteSetting
* 时间：2012/12/30 19:22:31
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([SettingId])+1 FROM [SiteSetting]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Exists
@SettingId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [SiteSetting] WHERE SettingId=@SettingId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_ADD
@SettingId int output,
@SiteId int,
@Name nvarchar(20),
@IsActive bit,
@HeadCode nvarchar(MAX),
@BodyCode nvarchar(MAX),
@CacheExpireTime int,
@Charset nvarchar(20),
@ForbiddenFileType nvarchar(255),
@CollectImage bit,
@FakeOriginalTitle bit,
@FakeOriginalContent bit,
@StaticExtension nvarchar(20),
@EnableBillboard bit,
@CustomInternalLinkKeyword nvarchar(255),
@InternalSearchTemplate nvarchar(50),
@SupportPandomain bit,
@UseProxy bit,
@SynchronizeIECookie bit,
@CookieString nvarchar(4000),
@EnableErrorLog bit,
@EnableStatisticalCode bit,
@ConvertToRedirectLink bit,
@WorkMode int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [SiteSetting](
	[SiteId],[Name],[IsActive],[HeadCode],[BodyCode],[CacheExpireTime],[Charset],[ForbiddenFileType],[CollectImage],[FakeOriginalTitle],[FakeOriginalContent],[StaticExtension],[EnableBillboard],[CustomInternalLinkKeyword],[InternalSearchTemplate],[SupportPandomain],[UseProxy],[SynchronizeIECookie],[CookieString],[EnableErrorLog],[EnableStatisticalCode],[ConvertToRedirectLink],[WorkMode],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@IsActive,@HeadCode,@BodyCode,@CacheExpireTime,@Charset,@ForbiddenFileType,@CollectImage,@FakeOriginalTitle,@FakeOriginalContent,@StaticExtension,@EnableBillboard,@CustomInternalLinkKeyword,@InternalSearchTemplate,@SupportPandomain,@UseProxy,@SynchronizeIECookie,@CookieString,@EnableErrorLog,@EnableStatisticalCode,@ConvertToRedirectLink,@WorkMode,@CreatedOn,@UpdatedOn
	)
	SET @SettingId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Update
@SettingId int,
@SiteId int,
@Name nvarchar(20),
@IsActive bit,
@HeadCode nvarchar(MAX),
@BodyCode nvarchar(MAX),
@CacheExpireTime int,
@Charset nvarchar(20),
@ForbiddenFileType nvarchar(255),
@CollectImage bit,
@FakeOriginalTitle bit,
@FakeOriginalContent bit,
@StaticExtension nvarchar(20),
@EnableBillboard bit,
@CustomInternalLinkKeyword nvarchar(255),
@InternalSearchTemplate nvarchar(50),
@SupportPandomain bit,
@UseProxy bit,
@SynchronizeIECookie bit,
@CookieString nvarchar(4000),
@EnableErrorLog bit,
@EnableStatisticalCode bit,
@ConvertToRedirectLink bit,
@WorkMode int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [SiteSetting] SET 
	[SiteId] = @SiteId,[Name] = @Name,[IsActive] = @IsActive,[HeadCode] = @HeadCode,[BodyCode] = @BodyCode,[CacheExpireTime] = @CacheExpireTime,[Charset] = @Charset,[ForbiddenFileType] = @ForbiddenFileType,[CollectImage] = @CollectImage,[FakeOriginalTitle] = @FakeOriginalTitle,[FakeOriginalContent] = @FakeOriginalContent,[StaticExtension] = @StaticExtension,[EnableBillboard] = @EnableBillboard,[CustomInternalLinkKeyword] = @CustomInternalLinkKeyword,[InternalSearchTemplate] = @InternalSearchTemplate,[SupportPandomain] = @SupportPandomain,[UseProxy] = @UseProxy,[SynchronizeIECookie] = @SynchronizeIECookie,[CookieString] = @CookieString,[EnableErrorLog] = @EnableErrorLog,[EnableStatisticalCode] = @EnableStatisticalCode,[ConvertToRedirectLink] = @ConvertToRedirectLink,[WorkMode] = @WorkMode,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Delete
@SettingId int
 AS 
	DELETE [SiteSetting]
	 WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetModel
@SettingId int
 AS 
	SELECT 
	SettingId,SiteId,Name,IsActive,HeadCode,BodyCode,CacheExpireTime,Charset,ForbiddenFileType,CollectImage,FakeOriginalTitle,FakeOriginalContent,StaticExtension,EnableBillboard,CustomInternalLinkKeyword,InternalSearchTemplate,SupportPandomain,UseProxy,SynchronizeIECookie,CookieString,EnableErrorLog,EnableStatisticalCode,ConvertToRedirectLink,WorkMode,CreatedOn,UpdatedOn
	 FROM [SiteSetting]
	 WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetList
 AS 
	SELECT 
	SettingId,SiteId,Name,IsActive,HeadCode,BodyCode,CacheExpireTime,Charset,ForbiddenFileType,CollectImage,FakeOriginalTitle,FakeOriginalContent,StaticExtension,EnableBillboard,CustomInternalLinkKeyword,InternalSearchTemplate,SupportPandomain,UseProxy,SynchronizeIECookie,CookieString,EnableErrorLog,EnableStatisticalCode,ConvertToRedirectLink,WorkMode,CreatedOn,UpdatedOn
	 FROM [SiteSetting]

GO

/******************************************************************
* 表名：SiteUser
* 时间：2012/12/20 20:57:03
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([UserId])+1 FROM [SiteUser]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_Exists
@UserId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [SiteUser] WHERE UserId=@UserId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_ADD
@UserId int output,
@UserName nvarchar(50),
@Password nchar(32),
@Name nvarchar(20),
@Email nvarchar(120),
@MobilePhone nvarchar(20),
@UserType int,
@LastLoginIP nvarchar(60),
@LastLoginOn datetime,
@IsActive bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [SiteUser](
	[UserName],[Password],[Name],[Email],[MobilePhone],[UserType],[LastLoginIP],[LastLoginOn],[IsActive],[CreatedOn],[UpdatedOn]
	)VALUES(
	@UserName,@Password,@Name,@Email,@MobilePhone,@UserType,@LastLoginIP,@LastLoginOn,@IsActive,@CreatedOn,@UpdatedOn
	)
	SET @UserId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_Update
@UserId int,
@UserName nvarchar(50),
@Password nchar(32),
@Name nvarchar(20),
@Email nvarchar(120),
@MobilePhone nvarchar(20),
@UserType int,
@LastLoginIP nvarchar(60),
@LastLoginOn datetime,
@IsActive bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [SiteUser] SET 
	[UserName] = @UserName,[Password] = @Password,[Name] = @Name,[Email] = @Email,[MobilePhone] = @MobilePhone,[UserType] = @UserType,[LastLoginIP] = @LastLoginIP,[LastLoginOn] = @LastLoginOn,[IsActive] = @IsActive,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE UserId=@UserId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_Delete
@UserId int
 AS 
	DELETE [SiteUser]
	 WHERE UserId=@UserId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_GetModel
@UserId int
 AS 
	SELECT 
	UserId,UserName,Password,Name,Email,MobilePhone,UserType,LastLoginIP,LastLoginOn,IsActive,CreatedOn,UpdatedOn
	 FROM [SiteUser]
	 WHERE UserId=@UserId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_GetList
 AS 
	SELECT 
	UserId,UserName,Password,Name,Email,MobilePhone,UserType,LastLoginIP,LastLoginOn,IsActive,CreatedOn,UpdatedOn
	 FROM [SiteUser]

GO


/******************************************************************
* 表名：sysdiagrams
* 时间：2012/12/20 20:57:04
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([diagram_id])+1 FROM [sysdiagrams]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_Exists
@diagram_id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [sysdiagrams] WHERE diagram_id=@diagram_id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_ADD
@name sysname,
@principal_id int,
@diagram_id int output,
@version int,
@definition varbinary(MAX)

 AS 
	INSERT INTO [sysdiagrams](
	[name],[principal_id],[version],[definition]
	)VALUES(
	@name,@principal_id,@version,@definition
	)
	SET @diagram_id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_Update
@name sysname,
@principal_id int,
@diagram_id int,
@version int,
@definition varbinary(MAX)
 AS 
	UPDATE [sysdiagrams] SET 
	[name] = @name,[principal_id] = @principal_id,[version] = @version,[definition] = @definition
	WHERE diagram_id=@diagram_id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_Delete
@diagram_id int
 AS 
	DELETE [sysdiagrams]
	 WHERE diagram_id=@diagram_id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_GetModel
@diagram_id int
 AS 
	SELECT 
	name,principal_id,diagram_id,version,definition
	 FROM [sysdiagrams]
	 WHERE diagram_id=@diagram_id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_GetList
 AS 
	SELECT 
	name,principal_id,diagram_id,version,definition
	 FROM [sysdiagrams]

GO


/******************************************************************
* 表名：TitleExpression
* 时间：2012/12/20 20:57:06
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([ExpressionId])+1 FROM [TitleExpression]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_Exists
@ExpressionId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleExpression] WHERE ExpressionId=@ExpressionId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_ADD
@ExpressionId int output,
@SiteId int,
@Value nvarchar(60),
@Priority int,
@IsEnable bit

 AS 
	INSERT INTO [TitleExpression](
	[SiteId],[Value],[Priority],[IsEnable]
	)VALUES(
	@SiteId,@Value,@Priority,@IsEnable
	)
	SET @ExpressionId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_Update
@ExpressionId int,
@SiteId int,
@Value nvarchar(60),
@Priority int,
@IsEnable bit
 AS 
	UPDATE [TitleExpression] SET 
	[SiteId] = @SiteId,[Value] = @Value,[Priority] = @Priority,[IsEnable] = @IsEnable
	WHERE ExpressionId=@ExpressionId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_Delete
@ExpressionId int
 AS 
	DELETE [TitleExpression]
	 WHERE ExpressionId=@ExpressionId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_GetModel
@ExpressionId int
 AS 
	SELECT 
	ExpressionId,SiteId,Value,Priority,IsEnable
	 FROM [TitleExpression]
	 WHERE ExpressionId=@ExpressionId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_GetList
 AS 
	SELECT 
	ExpressionId,SiteId,Value,Priority,IsEnable
	 FROM [TitleExpression]

GO


/******************************************************************
* 表名：TitlePrefix
* 时间：2012/12/20 20:57:07
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([TitleId])+1 FROM [TitlePrefix]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_Exists
@TitleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitlePrefix] WHERE TitleId=@TitleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_ADD
@TitleId int output,
@SiteId int,
@Value nvarchar(60),
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitlePrefix](
	[SiteId],[Value],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Value,@CreatedOn,@UpdatedOn
	)
	SET @TitleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_Update
@TitleId int,
@SiteId int,
@Value nvarchar(60),
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitlePrefix] SET 
	[SiteId] = @SiteId,[Value] = @Value,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE TitleId=@TitleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_Delete
@TitleId int
 AS 
	DELETE [TitlePrefix]
	 WHERE TitleId=@TitleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_GetModel
@TitleId int
 AS 
	SELECT 
	TitleId,SiteId,Value,CreatedOn,UpdatedOn
	 FROM [TitlePrefix]
	 WHERE TitleId=@TitleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_GetList
 AS 
	SELECT 
	TitleId,SiteId,Value,CreatedOn,UpdatedOn
	 FROM [TitlePrefix]

GO


/******************************************************************
* 表名：UserSite
* 时间：2012/12/20 20:57:08
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([UserId])+1 FROM [UserSite]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_Exists
@UserId int,
@SiteId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [UserSite] WHERE UserId=@UserId and SiteId=@SiteId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_ADD
@UserId int,
@SiteId int,
@CreatedOn datetime

 AS 
	INSERT INTO [UserSite](
	[UserId],[SiteId],[CreatedOn]
	)VALUES(
	@UserId,@SiteId,@CreatedOn
	)

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_Update
@UserId int,
@SiteId int,
@CreatedOn datetime
 AS 
	UPDATE [UserSite] SET 
	[CreatedOn] = @CreatedOn
	WHERE UserId=@UserId and SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_Delete
@UserId int,
@SiteId int
 AS 
	DELETE [UserSite]
	 WHERE UserId=@UserId and SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_GetModel
@UserId int,
@SiteId int
 AS 
	SELECT 
	UserId,SiteId,CreatedOn
	 FROM [UserSite]
	 WHERE UserId=@UserId and SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_GetList
 AS 
	SELECT 
	UserId,SiteId,CreatedOn
	 FROM [UserSite]

GO

/******************************************************************
* 表名：ContentExtractionRule
* 时间：2013/4/5 0:05:53
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [ContentExtractionRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ContentExtractionRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@IsConvertToLocalUrl bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ContentExtractionRule](
	[SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[NoResultText],[ContentTemplate],[ContentOutTemplate],[IsConvertToLocalUrl],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@ContentExpression,@ChildExpression,@Encoding,@NoResultText,@ContentTemplate,@ContentOutTemplate,@IsConvertToLocalUrl,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@IsConvertToLocalUrl bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ContentExtractionRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[ContentExpression] = @ContentExpression,[ChildExpression] = @ChildExpression,[Encoding] = @Encoding,[NoResultText] = @NoResultText,[ContentTemplate] = @ContentTemplate,[ContentOutTemplate] = @ContentOutTemplate,[IsConvertToLocalUrl] = @IsConvertToLocalUrl,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Delete
@RuleId int
 AS 
	DELETE [ContentExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,IsConvertToLocalUrl,IsEnable,CreatedOn,UpdatedOn
	 FROM [ContentExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,IsConvertToLocalUrl,IsEnable,CreatedOn,UpdatedOn
	 FROM [ContentExtractionRule]

GO

/******************************************************************
* 表名：DomainSetting
* 时间：2013/4/5 0:08:17
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([DomainId])+1 FROM [DomainSetting]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Exists
@DomainId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [DomainSetting] WHERE DomainId=@DomainId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_ADD
@DomainId int output,
@SiteId int,
@DomainName nvarchar(200),
@Domain nvarchar(200),
@Charset nvarchar(20),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [DomainSetting](
	[SiteId],[DomainName],[Domain],[Charset],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@DomainName,@Domain,@Charset,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @DomainId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Update
@DomainId int,
@SiteId int,
@DomainName nvarchar(200),
@Domain nvarchar(200),
@Charset nvarchar(20),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [DomainSetting] SET 
	[SiteId] = @SiteId,[DomainName] = @DomainName,[Domain] = @Domain,[Charset] = @Charset,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Delete
@DomainId int
 AS 
	DELETE [DomainSetting]
	 WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetModel
@DomainId int
 AS 
	SELECT 
	DomainId,SiteId,DomainName,Domain,Charset,IsEnable,CreatedOn,UpdatedOn
	 FROM [DomainSetting]
	 WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetList
 AS 
	SELECT 
	DomainId,SiteId,DomainName,Domain,Charset,IsEnable,CreatedOn,UpdatedOn
	 FROM [DomainSetting]

GO

/******************************************************************
* 表名：MultiSite
* 时间：2013/4/5 0:08:46
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([MultiSiteId])+1 FROM [MultiSite]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Exists
@MultiSiteId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [MultiSite] WHERE MultiSiteId=@MultiSiteId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_ADD
@MultiSiteId int output,
@SiteId int,
@SiteName nvarchar(200),
@RootDomain nvarchar(200),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [MultiSite](
	[SiteId],[SiteName],[RootDomain],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@SiteName,@RootDomain,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @MultiSiteId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Update
@MultiSiteId int,
@SiteId int,
@SiteName nvarchar(200),
@RootDomain nvarchar(200),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [MultiSite] SET 
	[SiteId] = @SiteId,[SiteName] = @SiteName,[RootDomain] = @RootDomain,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Delete
@MultiSiteId int
 AS 
	DELETE [MultiSite]
	 WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetModel
@MultiSiteId int
 AS 
	SELECT 
	MultiSiteId,SiteId,SiteName,RootDomain,IsEnable,CreatedOn,UpdatedOn
	 FROM [MultiSite]
	 WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetList
 AS 
	SELECT 
	MultiSiteId,SiteId,SiteName,RootDomain,IsEnable,CreatedOn,UpdatedOn
	 FROM [MultiSite]

GO

/******************************************************************
* 表名：NonStaticUrl
* 时间：2013/4/6 11:01:57
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([UrlId])+1 FROM [NonStaticUrl]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Exists
@UrlId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [NonStaticUrl] WHERE UrlId=@UrlId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_ADD
@UrlId int output,
@SiteId int,
@Name nvarchar(200),
@Url nvarchar(4000),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [NonStaticUrl](
	[SiteId],[Name],[Url],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @UrlId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Update
@UrlId int,
@SiteId int,
@Name nvarchar(200),
@Url nvarchar(4000),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [NonStaticUrl] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Delete
@UrlId int
 AS 
	DELETE [NonStaticUrl]
	 WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetModel
@UrlId int
 AS 
	SELECT 
	UrlId,SiteId,Name,Url,IsEnable,CreatedOn,UpdatedOn
	 FROM [NonStaticUrl]
	 WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetList
 AS 
	SELECT 
	UrlId,SiteId,Name,Url,IsEnable,CreatedOn,UpdatedOn
	 FROM [NonStaticUrl]

GO

/******************************************************************
* 表名：UrlEncodingRule
* 时间：2013/4/6 10:59:31
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [UrlEncodingRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [UrlEncodingRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_ADD
@RuleId int output,
@SiteId int,
@TagName nvarchar(40),
@AttributeName nvarchar(200),
@DefaultFileType nvarchar(20),
@Priority int,
@KeepOriginalFileType bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [UrlEncodingRule](
	[SiteId],[TagName],[AttributeName],[DefaultFileType],[Priority],[KeepOriginalFileType],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@TagName,@AttributeName,@DefaultFileType,@Priority,@KeepOriginalFileType,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Update
@RuleId int,
@SiteId int,
@TagName nvarchar(40),
@AttributeName nvarchar(200),
@DefaultFileType nvarchar(20),
@Priority int,
@KeepOriginalFileType bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [UrlEncodingRule] SET 
	[SiteId] = @SiteId,[TagName] = @TagName,[AttributeName] = @AttributeName,[DefaultFileType] = @DefaultFileType,[Priority] = @Priority,[KeepOriginalFileType] = @KeepOriginalFileType,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Delete
@RuleId int
 AS 
	DELETE [UrlEncodingRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,TagName,AttributeName,DefaultFileType,Priority,KeepOriginalFileType,IsEnable,CreatedOn,UpdatedOn
	 FROM [UrlEncodingRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,TagName,AttributeName,DefaultFileType,Priority,KeepOriginalFileType,IsEnable,CreatedOn,UpdatedOn
	 FROM [UrlEncodingRule]

GO

/******************************************************************
* 表名：TitleCategory
* 时间：2013/4/27 21:47:28
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([CategoryId])+1 FROM [TitleCategory]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Exists
@CategoryId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleCategory] WHERE CategoryId=@CategoryId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_ADD
@CategoryId int output,
@SiteId int,
@CategoryName nvarchar(100),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleCategory](
	[SiteId],[CategoryName],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryName,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @CategoryId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Update
@CategoryId int,
@SiteId int,
@CategoryName nvarchar(100),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleCategory] SET 
	[SiteId] = @SiteId,[CategoryName] = @CategoryName,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Delete
@CategoryId int
 AS 
	DELETE [TitleCategory]
	 WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetModel
@CategoryId int
 AS 
	SELECT 
	CategoryId,SiteId,CategoryName,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleCategory]
	 WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetList
 AS 
	SELECT 
	CategoryId,SiteId,CategoryName,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleCategory]

GO

/******************************************************************
* 表名：TitleOriginal
* 时间：2013/4/27 21:47:38
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([OriginalId])+1 FROM [TitleOriginal]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Exists
@OriginalId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleOriginal] WHERE OriginalId=@OriginalId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_ADD
@OriginalId int output,
@SiteId int,
@CategoryId int,
@Vocabulary nvarchar(1000),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleOriginal](
	[SiteId],[CategoryId],[Vocabulary],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryId,@Vocabulary,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @OriginalId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Update
@OriginalId int,
@SiteId int,
@CategoryId int,
@Vocabulary nvarchar(1000),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleOriginal] SET 
	[SiteId] = @SiteId,[CategoryId] = @CategoryId,[Vocabulary] = @Vocabulary,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Delete
@OriginalId int
 AS 
	DELETE [TitleOriginal]
	 WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetModel
@OriginalId int
 AS 
	SELECT 
	OriginalId,SiteId,CategoryId,Vocabulary,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginal]
	 WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetList
 AS 
	SELECT 
	OriginalId,SiteId,CategoryId,Vocabulary,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginal]

GO

/******************************************************************
* 表名：TitleOriginalRule
* 时间：2013/4/28 19:55:02
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [TitleOriginalRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleOriginalRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(60),
@RuleType int,
@Delimiter nvarchar(60),
@Count int,
@CategoryId int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleOriginalRule](
	[SiteId],[Name],[RuleType],[Delimiter],[Count],[CategoryId],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@RuleType,@Delimiter,@Count,@CategoryId,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(60),
@RuleType int,
@Delimiter nvarchar(60),
@Count int,
@CategoryId int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleOriginalRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[RuleType] = @RuleType,[Delimiter] = @Delimiter,[Count] = @Count,[CategoryId] = @CategoryId,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Delete
@RuleId int
 AS 
	DELETE [TitleOriginalRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,RuleType,Delimiter,Count,CategoryId,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginalRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,RuleType,Delimiter,Count,CategoryId,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginalRule]

GO

/******************************************************************
* 表名：PageTitle
* 时间：2013/4/28 19:54:48
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([PageId])+1 FROM [PageTitle]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Exists
@PageId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [PageTitle] WHERE PageId=@PageId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_ADD
@PageId int output,
@SiteId int,
@PageIdentity nvarchar(36),
@Title nvarchar(2000),
@OldTitle nvarchar(2000),
@TitleMainPart nvarchar(2000),
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [PageTitle](
	[SiteId],[PageIdentity],[Title],[OldTitle],[TitleMainPart],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@PageIdentity,@Title,@OldTitle,@TitleMainPart,@CreatedOn,@UpdatedOn
	)
	SET @PageId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Update
@PageId int,
@SiteId int,
@PageIdentity nvarchar(36),
@Title nvarchar(2000),
@OldTitle nvarchar(2000),
@TitleMainPart nvarchar(2000),
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [PageTitle] SET 
	[SiteId] = @SiteId,[PageIdentity] = @PageIdentity,[Title] = @Title,[OldTitle] = @OldTitle,[TitleMainPart] = @TitleMainPart,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Delete
@PageId int
 AS 
	DELETE [PageTitle]
	 WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetModel
@PageId int
 AS 
	SELECT 
	PageId,SiteId,PageIdentity,Title,OldTitle,TitleMainPart,CreatedOn,UpdatedOn
	 FROM [PageTitle]
	 WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetList
 AS 
	SELECT 
	PageId,SiteId,PageIdentity,Title,OldTitle,TitleMainPart,CreatedOn,UpdatedOn
	 FROM [PageTitle]

GO

!!!!!!

------------------------------------
--插入站点数据
------------------------------------

INSERT [Site] ([SiteName],[SiteProtoco],[SitePort],[SiteChildDomain],[SiteRootDomain],[Keyword],[Description],[ICPNumber],[TargetSiteProtoco],[TargetSitePort],[TargetSiteChildDomain],[TargetSiteRootDomain],[Email],[QQ],[ForumUserName],[SiteStatus],[AuthorizedCode],[CreatedOn],[UpdatedOn]) 
VALUES (N'{0}',N'{1}',{2},N'{3}',N'{4}',N'',N'',N'',N'{5}',{6},N'{7}',N'{8}',N'{9}',N'{10}',N'{11}',1,N'',getdate(),null)

SELECT @@IDENTITY

!!!!!!

------------------------------------
--插入其他数据
------------------------------------

DECLARE @SiteId int

SELECT @SiteId = [*SiteId*]

if not exists (select * from [SiteUser] where [UserName] = '[*UserName*]')
BEGIN 
INSERT [SiteUser] ([UserName],[Password],[Name],[UserType],[IsActive],[CreatedOn]) VALUES (N'[*UserName*]',N'[*Password*]',N'',0,1,getdate())
END

INSERT [SiteSetting] ([SiteId],[Name],[IsActive],[CacheExpireTime],[Charset],[ForbiddenFileType],[CollectImage],[FakeOriginalTitle],[FakeOriginalContent],[StaticExtension],[EnableBillboard],[InternalSearchTemplate],[SupportPandomain],[UseProxy],[SynchronizeIECookie],[EnableErrorLog], [WorkMode],[CreatedOn],[UpdatedOn]) 
VALUES (@SiteId ,N'',1,1,N'UTF-8',N'zip|mp3|rm',1,1,0,N'htm',1,N'default/search.html',1,1,1,1,2,getdate(),null)

INSERT [InternalSiteSearch] ([SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[ContentTemplate],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (@SiteId,N'soso',N'http://www.soso.com/q?w={0}&site={1}&ch=website',N'//*[@id="result"]',N'url;/ol',N'gbk',N'<ol>[*ContentValue(url)*]</ol>',1,1,getdate(),null)
INSERT [InternalSiteSearch] ([SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[ContentTemplate],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (@SiteId,N'视频',N'http://video.soso.com/search/?ch=v.res.search&pid=v.search&ac=1&w={0}',N'//*[@id="result_wrap"]',N'result;/div[@id="result"]',N'gbk',N'[*ContentValue(result)*]',1,0,getdate(),null)
INSERT [InternalSiteSearch] ([SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[ContentTemplate],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn],[ContentOutTemplate],[RelatedKeywordExpression],[Priority]) VALUES (@SiteId,N'淘宝',N'http://s8.taobao.com/search?q={0}&cat=0&pid=mm_12689842_0_0&mode=23&commend=1%2C2',N'//ul[@data-item-count]/li',N'summary;/h3||url;/h3/a;href||title;/h3/a;title||price;/ul/li[@class=''price'']/em||photo;/div[@class=''photo '']/a/span/img;data-ks-lazyload||sell;/ul/li[@class=''price'']/span||shipment;/ul/li[@class=''shipment'']||carryFee;/li/span[@class=''fee'']||seller;ul/li[@class=''seller'']',N'gbk',N'<li>
        <div class="figure">
            <div class="pic">
                <a href="[*ContentValue(url)*]" target="_blank" class="s_history_e_product_pic">
                    <img alt="[*ContentValue(title)*]" src="[*ContentValue(photo)*]">
                </a><i class=""></i>
            </div>
            <div class="cont">
                <h2 class="title">
                    <i class=""></i>[*ContentValue(summary)*]</h2>
                <p class="price">
                    <span class="present-price">￥<strong>[*ContentValue(price)*]</strong></span><!--<span title="原价：899" class="rebate">3.3折</span>-->
                </p>
                <p class="info">
                    <span class="total">[*ContentValue(sell)*]</span><span class="devide">|</span>[*ContentValue(carryFee)*]
                </p>
                <p class="mall-name">
                    [*ContentValue(seller)*]<!-- <a target="_blank" class="icon-card" title="一站通：支持360帐号登录"
                                            bk="e-logo" href="/yizhantong.html">一站通</a>-->
                </p>
            </div>
        </div>
    </li>',1,0,GETDATE(),null,N'<ul class="product-list clearfix">[*AllContent*]</ul>',N'//*[@id="J_RelatedSearch"]/dd/a',10)

DECLARE @BillboardId int

INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'实时热点排行榜',N'http://top.baidu.com/rss_xml.php?p=top10',0,1,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'七日关注排行榜',N'http://top.baidu.com/rss_xml.php?p=weekhotspot',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日热门搜索排行榜',N'http://top.baidu.com/rss_xml.php?p=top_keyword',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'世说新词排行榜',N'http://top.baidu.com/rss_xml.php?p=shishuoxinci',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'最近事件排行榜',N'http://top.baidu.com/rss_xml.php?p=shijian',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'上周事件排行榜',N'http://top.baidu.com/rss_xml.php?p=shijian_lastweek',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'上月事件排行榜',N'http://top.baidu.com/rss_xml.php?p=shijian_lastmonth',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日电影排行榜',N'http://top.baidu.com/rss_xml.php?p=movie',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日电视剧排行榜',N'http://top.baidu.com/rss_xml.php?p=tv',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日综艺排行榜',N'http://top.baidu.com/rss_xml.php?p=dianshi',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日小说排行榜',N'http://top.baidu.com/rss_xml.php?p=book',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日体育热点排行榜',N'http://top.baidu.com/rss_xml.php?p=sport',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日动漫排行榜',N'http://top.baidu.com/rss_xml.php?p=katong',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日畅销书排行榜',N'http://top.baidu.com/rss_xml.php?p=shu',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日视频网站排行榜',N'http://top.baidu.com/rss_xml.php?p=video',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日热点人物排行榜',N'http://top.baidu.com/rss_xml.php?p=hotman',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日美女排行榜',N'http://top.baidu.com/rss_xml.php?p=girls',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日帅哥排行榜',N'http://top.baidu.com/rss_xml.php?p=boys',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日女演员排行榜',N'http://top.baidu.com/rss_xml.php?p=FStar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日男演员排行榜',N'http://top.baidu.com/rss_xml.php?p=MStar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日女歌手排行榜',N'http://top.baidu.com/rss_xml.php?p=ygeshou',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日男歌手排行榜',N'http://top.baidu.com/rss_xml.php?p=ngeshou',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日体坛人物排行榜',N'http://top.baidu.com/rss_xml.php?p=titan',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日互联网人物排行榜',N'http://top.baidu.com/rss_xml.php?p=internet',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日名家人物排行榜',N'http://top.baidu.com/rss_xml.php?p=mingjia',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日财经人物排行榜',N'http://top.baidu.com/rss_xml.php?p=caijing',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日富豪排行榜',N'http://top.baidu.com/rss_xml.php?p=rich',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日政坛人物排行榜',N'http://top.baidu.com/rss_xml.php?p=zhengtan',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日历史人物排行榜',N'http://top.baidu.com/rss_xml.php?p=lishiren',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日人物关系排行榜',N'http://top.baidu.com/rss_xml.php?p=relation',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日风景名胜排行榜',N'http://top.baidu.com/rss_xml.php?p=fengjingmingsheng',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日旅游目的地排行榜',N'http://top.baidu.com/rss_xml.php?p=lycity',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日数码产品排行榜',N'http://top.baidu.com/rss_xml.php?p=shuma',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日软件排行榜',N'http://top.baidu.com/rss_xml.php?p=soft',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日团购网站排行榜',N'http://top.baidu.com/rss_xml.php?p=groupon',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日奢侈品品牌排行榜',N'http://top.baidu.com/rss_xml.php?p=shechi',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日化妆品品牌排行榜',N'http://top.baidu.com/rss_xml.php?p=hzp',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日运动服饰品牌排行榜',N'http://top.baidu.com/rss_xml.php?p=sportdress',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日宠物排行榜',N'http://top.baidu.com/rss_xml.php?p=pet',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日美食排行榜',N'http://top.baidu.com/rss_xml.php?p=food',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日高校排行榜',N'http://top.baidu.com/rss_xml.php?p=school',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日慈善组织排行榜',N'http://top.baidu.com/rss_xml.php?p=cishan',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日房产企业排行榜',N'http://top.baidu.com/rss_xml.php?p=fangchanqy',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'奇艺电影排行榜',N'http://top.baidu.com/rss_xml.php?p=qiyidianying',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'奇艺电视剧排行榜',N'http://top.baidu.com/rss_xml.php?p=qiyidianshiju',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'奇艺综艺排行榜',N'http://top.baidu.com/rss_xml.php?p=qiyizongyi',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'奇艺动漫排行榜',N'http://top.baidu.com/rss_xml.php?p=qiyidongman',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日汽车品牌排行榜',N'http://top.baidu.com/rss_xml.php?p=automobile',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日SUV排行榜',N'http://top.baidu.com/rss_xml.php?p=suv',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日微型车排行榜',N'http://top.baidu.com/rss_xml.php?p=minicar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日小型车排行榜',N'http://top.baidu.com/rss_xml.php?p=smallcar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日紧凑型车排行榜',N'http://top.baidu.com/rss_xml.php?p=jincoucar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日中级车排行榜',N'http://top.baidu.com/rss_xml.php?p=zhongjicar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日中高级车排行榜',N'http://top.baidu.com/rss_xml.php?p=midcar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日豪华车排行榜',N'http://top.baidu.com/rss_xml.php?p=luxurycar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日跑车排行榜',N'http://top.baidu.com/rss_xml.php?p=racingcar',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日MPV排行榜',N'http://top.baidu.com/rss_xml.php?p=mpv',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日网游排行榜',N'http://top.baidu.com/rss_xml.php?p=mmogame',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日网页游戏排行榜',N'http://top.baidu.com/rss_xml.php?p=web_game',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日休闲游戏排行榜',N'http://top.baidu.com/rss_xml.php?p=leisure_game',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日魔幻RPG排行榜',N'http://top.baidu.com/rss_xml.php?p=magic_rpg',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日武侠RPG排行榜',N'http://top.baidu.com/rss_xml.php?p=martial_arts_rpg',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日神话RPG排行榜',N'http://top.baidu.com/rss_xml.php?p=myth_rpg',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日历史RPG排行榜',N'http://top.baidu.com/rss_xml.php?p=history_rpg',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日科幻RPG排行榜',N'http://top.baidu.com/rss_xml.php?p=sf_game',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日网游运营商排行榜',N'http://top.baidu.com/rss_xml.php?p=operator',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日网页游戏平台排行榜',N'http://top.baidu.com/rss_xml.php?p=wangyeyungame',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'百度游戏联运排行榜',N'http://top.baidu.com/rss_xml.php?p=baidugame',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日PC品牌排行榜',N'http://top.baidu.com/rss_xml.php?p=pc_brand',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日笔记本品牌排行榜',N'http://top.baidu.com/rss_xml.php?p=notebook_brand',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日台式机品牌排行榜',N'http://top.baidu.com/rss_xml.php?p=desktop_brand',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日笔记本产品排行榜榜',N'http://top.baidu.com/rss_xml.php?p=notebook_product',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日台式机产品排行榜',N'http://top.baidu.com/rss_xml.php?p=desktop_product',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日留学机构排行榜',N'http://top.baidu.com/rss_xml.php?p=liuxuejg',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日基础教育排行榜',N'http://top.baidu.com/rss_xml.php?p=jichujiaoyu',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日IT培训排行榜',N'http://top.baidu.com/rss_xml.php?p=zhiyepeixun',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日英语培训排行榜',N'http://top.baidu.com/rss_xml.php?p=yingyupeixun',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日语言培训排行榜',N'http://top.baidu.com/rss_xml.php?p=yuyanpeixun',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日热搜股票排行榜',N'http://top.baidu.com/rss_xml.php?p=hotstocks',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日创业板股票排行榜',N'http://top.baidu.com/rss_xml.php?p=cybstocks',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日中小板股票排行榜',N'http://top.baidu.com/rss_xml.php?p=zxbstocks',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日行业板块排行榜',N'http://top.baidu.com/rss_xml.php?p=hangyeban',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日中资银行排行榜',N'http://top.baidu.com/rss_xml.php?p=chinese_bank',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日外资银行排行榜',N'http://top.baidu.com/rss_xml.php?p=foreign_bank',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日基金公司排行榜',N'http://top.baidu.com/rss_xml.php?p=fund_company',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日开放式基金排行榜',N'http://top.baidu.com/rss_xml.php?p=open_ended_fund',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日封闭式基金排行榜',N'http://top.baidu.com/rss_xml.php?p=closed_ended_fund',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日手机品牌排行榜',N'http://top.baidu.com/rss_xml.php?p=shoujipinpai',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日手机产品排行榜',N'http://top.baidu.com/rss_xml.php?p=shoujichanpin',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日滑盖手机排行榜',N'http://top.baidu.com/rss_xml.php?p=huagaishouji',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日翻盖手机排行榜',N'http://top.baidu.com/rss_xml.php?p=fangaishouji',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES ( @SiteId,N'今日直板手机排行榜',N'http://top.baidu.com/rss_xml.php?p=zhibanshouji',0,0,getdate())
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)

