﻿/*
UI处理
参数:
    file:        SWFUpload文件对象
    targetid:    父容器标识
*/
function FileProgress(file, targetid)
{
    //定义文件处理标识
    this.ProgressId = file.id;
    
    //获取当前容器对象
    this.fileProgressElement = document.getElementById(file.id);

    if (!this.fileProgressElement)
    {
        //container
        this.fileProgressElement = document.createElement("div");
        this.fileProgressElement.id = file.id;
        this.fileProgressElement.className = swfu.settings.custom_settings.container_css;

        //ico
        this.stateButton = document.createElement("div");
        this.stateButton.className = swfu.settings.custom_settings.icoWaiting_css;
        this.fileProgressElement.appendChild(this.stateButton);

        //filename
        this.filenameSpan = document.createElement("div");
        this.filenameSpan.appendChild(document.createTextNode(file.name));
        this.fileProgressElement.appendChild(this.filenameSpan);

        //statebar div
        this.stateDiv = document.createElement("div");
        this.stateDiv.className = swfu.settings.custom_settings.state_div_css;
        this.stateDiv.style.height = "6px";
        this.stateBar = document.createElement("p");
        this.stateBar.className = swfu.settings.custom_settings.state_bar_css;
        this.stateBar.innerHTML = "&nbsp;";
        this.stateBar.style.width = "0%";
        this.stateDiv.appendChild(this.stateBar);
        this.fileProgressElement.appendChild(this.stateDiv);

        //span percent
        this.percentSpan = document.createElement("div");
        this.percentSpan.innerHTML = "(等待上传中...)";
        this.fileProgressElement.appendChild(this.percentSpan);
        
        //cancel href
        this.hrefSpan = document.createElement("div");        
        this.hrefControl = document.createElement("a");
        this.hrefControl.innerHTML = "停止上传";
        this.hrefControl.onclick = function()
        {
            swfu.cancelUpload(file.id);
        }
        this.hrefSpan.appendChild(this.hrefControl);
        this.fileProgressElement.appendChild(this.hrefSpan);

        //普通文本
        this.spanText = document.createElement("div");
        this.spanText.appendChild(document.createTextNode("，文件大小"));
        this.fileProgressElement.appendChild(this.spanText);

        //文件大小
        this.fileUploadCount = document.createElement("div");
        this.fileUploadCount.innerHTML = "0bytes";
        this.fileProgressElement.appendChild(this.fileUploadCount);

        //insert container
        document.getElementById(targetid).appendChild(this.fileProgressElement);
    }
    else
    {
        this.reset();
    }
}

//恢复默认设置
FileProgress.prototype.reset = function()
{
    this.stateButton = this.fileProgressElement.childNodes[0];
    this.fileSpan = this.fileProgressElement.childNodes[1];
    this.stateDiv = this.fileProgressElement.childNodes[2];
    this.stateBar = this.stateDiv.childNodes[0];
    this.percentSpan = this.fileProgressElement.childNodes[3];
    this.hrefSpan = this.fileProgressElement.childNodes[4];
    this.hrefControl = this.hrefSpan.childNodes[0];
    this.spanText = this.fileProgressElement.childNodes[5];
    this.fileUploadCount = this.fileProgressElement.childNodes[6];
}

/*
设置状态按钮状态
state:        当前状态,1:初始化完成,2:正在等待,3:正在上传
settings:    swfupload.settings对象
*/
FileProgress.prototype.setUploadState = function(state,settings)
{
    switch(state)
    {
        case 1:
            //初始化完成
            this.stateButton.className = settings.custom_settings.icoNormal_css;
            break;
        case 2:
            //正在等待
            this.stateButton.className = settings.custom_settings.icoWaiting_css;
            break;
        case 3:
            //正在上传
            this.stateButton.className = settings.custom_settings.icoUpload_css;
    }
}

/*
设置上传进度
percent:     已上传百分比
*/
FileProgress.prototype.setProgress = function(bytesLoaded, bytesTotal)
{
    var percent = Math.ceil(bytesLoaded * 100 / bytesTotal);
    this.stateBar.style.width = percent + "%";
    this.percentSpan.innerHTML = percent + "%";

    this.fileUploadCount.innerHTML = formatUnits(bytesTotal);
}

/*
上传完成
*/
FileProgress.prototype.setComplete = function (settings) {
    this.stateButton.className = settings.custom_settings.icoNormal_css;
    this.hrefSpan.style.display = "none";
}

/*
设置插入
*/
FileProgress.prototype.setInsert = function(data) {
    var datas = data.split('|');
    this.insControl.href = 'javascript:insertUpload(' + datas[0] + ', \'' + datas[1] + '\')';
}

/*
控制上传进度对象是否显示
*/
FileProgress.prototype.setShow = function(show)
{
    this.fileProgressElement.style.display = show ? "" : "none";
}



//计算文件大小的文字描述,传入参数单位为字节
function formatUnits(size) {
    if (isNaN(size) || size == null) {
        size = 0;
    }

    if (size <= 0) return size + "bytes";

    var t1 = (size / 1024).toFixed(2);
    if (t1 < 0) {
        return "0KB";
    }

    if (t1 > 0 && t1 < 1024) {
        return t1 + "KB";
    }

    var t2 = (t1 / 1024).toFixed(2);
    if (t2 < 1024)
        return t2 + "MB";

    return (t2 / 1024).toFixed(2) + "GB";
}