﻿//kuaishow.com 
//jackysuy 
var nullTip = '此项为必填项。'
var formCfg = {
    username: {
        required: true,
        tipId: 'username_tip',
        txt: {
            normal: '以英文字母开头的4-20个字母或数字，不能用中文，注册成功后不可修改。',
            notValid: '请您输入由英文字母开头的4-20字母和数字，不支持中文和特殊字符。',
            exist: '您输入的登录名已经存在，请重新填写。'
        },
        cls: {
            normal: 'normal',
            notValid: 'error'
        },
        check: function (v) {
            if (!(/^[a-z][a-z0-9]{3,19}$/i.test(v))) return 'notValid';
        }
    },
    email: {
        required: true,
        tipId: 'email_tip',
        txt: {
            normal: "请填写常用的电子邮箱，这是客户联系您的首选方式！",
            notValid: '您输入的电子邮箱格式不正确，请重新填写。如：abc@163.com',
            exist: '您输入的邮箱已经被使用，请重新填写其他邮箱。'
        },
        cls: {
            normal: 'normal',
            notValid: 'error'
        },
        check: function (v) {
            if (!(/^[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)*@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+){1,4}$/.test(v))) return 'notValid';
        }
    },
    password: {
        required: true,
        tipId: 'password_tip',
        txt: {
            normal: '6-20个字母或数字，不要连续输入某个字符',
            notValid: '请填写6-20个字母或数字。'
        },
        cls: {
            normal: 'normal',
            notValid: 'error'
        },
        check: function (v) {
            if (!(/^[a-z0-9]{6,20}$/i.test(v))) return 'notValid';
        }
    },
    confirmpassword: {
        required: true,
        tipId: 'confirmpassword_tip',
        txt: {
            normal: '请再输入一遍您上面填写的密码。',
            notValid: '您两次输入的密码不一致，请重新填写。'
        },
        cls: {
            normal: 'normal',
            notValid: 'error'
        },
        check: function (v) {
            if (v != $('#password').val()) return 'notValid';
        }
    },
    verifycode: {
        required: true,
        tipId: 'verifycode_tip',
        txt: {
            normal: '请填写图示验证码。',
            notValid: '请填写正确的验证码。'
        },
        cls: {
            normal: 'normal',
            notValid: 'error'
        },
        check: function (v) {
            if (!(/^[a-z0-9]{4,5}$/i.test(v))) return 'notValid';
        }
    },
    agree: {
        required: true,
        tipId: 'agree_tip',
        txt: {
            normal: '请阅读并同意会员注册协议。',
            notValid: '请阅读并同意会员注册协议。'
        },
        cls: {
            normal: 'normal',
            notValid: 'error'
        },
        check: function (v) {
            if ($("#agree").attr('checked') == false) return 'notValid';
        }
    }
}

$(document).ready(function () {
    $.each(formCfg, function (key, val) {
        var obj = $("#" + key);
        var tip = $("#" + val.tipId);
        obj.bind({
            focus: function () {
                if (!tip.hasClass('correct')) {
                    tip.html(val.txt.normal);
                    tip.removeClass().addClass("normal");
                }
            },
            blur: function () {
                var v = $.trim(obj.val());
                var result = val.check(v);
                if (result) {
                    tip.html(val.txt[result]); //返回result的txt
                    tip.removeClass().addClass("error");
                }
                else {
                    //如果需要验证
                    if (val.txt.exist) {
                        $.get("/inc/userchk.ashx?value=" + v + "&type=" + key, function (data) {
                            //                            if (data == "False") {
                            //                                tip.html(val.txt.exist);
                            //                                tip.removeClass().addClass("error");
                            //                            }
                            if (data.length > 1) {
                                tip.html(data);
                                tip.removeClass().addClass("error");
                            }
                            else {
                                tip.html('&nbsp;');
                                tip.removeClass().addClass("correct");
                            }
                        });
                    }
                    else {
                        tip.html('&nbsp;');
                        tip.removeClass().addClass("correct");
                    }
                }
            }
        });
    });

    $("#postform").submit(function () {
        if ($("#postsubmit").attr("disabled") == true) {
            return false;
        }
        $("#postsubmit").attr("disabled", "disabled");
        var flag = true;
        $.each(formCfg, function (key, val) {
            var obj = $("#" + key);
            var tip = $("#" + val.tipId);
            if (val.required) {
                var v = $.trim(obj.val());
                var result = val.check(v);
                if (result) {
                    obj.focus();
                    $("#postsubmit").attr("disabled", "");
                    flag = false;
                    return false; //break;
                }
                else {
                    //                    if (val.txt.exist) {
                    //                        $.get("/inc/userchk.ashx?value=" + v + "&type=" + key, function (data) {
                    //                            if (data == "False") {
                    //                                tip.html(val.txt.exist);
                    //                                tip.removeClass().addClass("error");
                    //                                flag = false;
                    //                                return false; //break;  
                    //                            }
                    //                        });
                    //                    }
                    flag = true;
                }
            }
        });
        return flag;
    });

});

function chkpwd(obj) {
    var t = obj.value;
    var id = getResult(t);

    //定义对应的消息提示
    var msg = new Array(5);
    msg[0] = "密码少于6位。";
    msg[1] = "密码强度差。";
    msg[2] = "密码强度良好。";
    msg[3] = "密码强度高。";
    msg[4] = "密码多于20位。";

    var sty = new Array(5);
    sty[0] = -45;
    sty[1] = -30;
    sty[2] = -15;
    sty[3] = 0;
    sty[4] = -45;

    var col = new Array(5);
    col[0] = "gray";
    col[1] = "red";
    col[2] = "#ff6600";
    col[3] = "Green";
    col[4] = "gray";

    //设置显示效果
    var Bobj = $("#chkResult");
    Bobj.css({ "color": "" + col[id] + "", "background-position": "0 " + sty[id] + "px" });
    Bobj.html("检测提示：" + msg[id]);
}

//定义检测函数,返回0/1/2/3分别代表无效/差/一般/强
function getResult(s) {
    if (s.length < 6) {
        return 0;
    }
    if (s.length > 20) {
        return 4;
    }
    var ls = 0;
    if (s.match(/[a-z]/ig)) {
        ls++;
    }
    if (s.match(/[0-9]/ig)) {
        ls++;
    }
    if (s.match(/(.[^a-z0-9])/ig)) {
        ls++;
    }
    return ls
}