﻿// JScript 文件

function ExpandSubCategory(iCategoryID)
			{
				var li_father = document.getElementById("li_" + iCategoryID);
				if (li_father.getElementsByTagName("li").length > 0) //分类已下载
				{
					ChangeStatus(iCategoryID);
					displayDocList(iCategoryID);
					return;
				}
				
				li_father.className = "Opened";
				
				switchNote(iCategoryID, true);
				MkSun.Ashop_System.Control_Class_ClassControl.GetSubCategory(iCategoryID, GetSubCategory_callback);				
			}
			
			function GetSubCategory_callback(response)
			{
				var dt = response.value.Tables[0];
				if (dt.Rows.length > 0)
				{
					var iCategoryID = dt.Rows[0].FatherID;
				}
				var li_father = document.getElementById("li_" + iCategoryID);
				var ul = document.createElement("ul");
				for (var i = 0;i < dt.Rows.length;i++)
				{
					if (dt.Rows[i].IsChild == 1) //叶子节点
					{
						var li = document.createElement("li");
						li.className = "Child";
						li.id = "li_" + dt.Rows[i].CategoryID;
						
						var img = document.createElement("img");
						img.id = dt.Rows[i].CategoryID;
						img.className = "s";
						img.src = "css/s.gif";
						
						var a = document.createElement("a");
						a.href = "javascript:OpenDocument('" + dt.Rows[i].CategoryID + "');";
						a.innerHTML = dt.Rows[i].CategoryName;
					}
					else
					{
						var li = document.createElement("li");
						li.className = "Closed";
						li.id = "li_" + dt.Rows[i].CategoryID;
						
						var img = document.createElement("img");
						img.id = dt.Rows[i].CategoryID;
						img.className = "s";
						img.src = "css/s.gif";
						img.onclick = function () {
							ExpandSubCategory(this.id);
						};
						img.alt = "展开/折叠";
						
						var a = document.createElement("a");
						a.href = "javascript:ExpandSubCategory(" +
							dt.Rows[i].CategoryID + ");";
						a.innerHTML = dt.Rows[i].CategoryName;
					}
					li.appendChild(img);
					li.appendChild(a);
					ul.appendChild(li);	
				}
				li_father.appendChild(ul);
				
				displayDocList(iCategoryID);
				switchNote(iCategoryID, false);
			
			}
			
			function OpenDocument(iCategoryID)
			{
				var div_docContent = document.getElementById("docContent");
				var div_docList = document.getElementById("docList");
				
				div_docContent.style.display = "";
				div_docList.style.display = "none";
				
				MkSun.Ashop_System.Control_Class_ClassControl.GetDocInfo(iCategoryID, GetDocInfo_callback);
			}
			
			function GetDocInfo_callback(response)
			{
				var dr = response.value.Tables[0].Rows[0];
				if (dr)
				{				
					var div_title = document.getElementById("title");
					var div_author = document.getElementById("author");
					var div_writetime = document.getElementById("writetime");
					var iFrm = document.getElementById("doc");
					
					div_title.innerHTML = dr.title;
					div_author.innerHTML = dr.author;
					div_writetime.innerHTML = dr.writetime;
					iFrm.src = dr.url;
				}
			}
			
			function ChangeStatus(iCategoryID)
			{
				var li_father = document.getElementById("li_" + iCategoryID);
				if (li_father.className == "Closed")
				{
					li_father.className = "Opened";
				}
				else
				{
					li_father.className = "Closed";
				}				
			}
			
			function switchNote(iCategoryID, show)
			{
				var li_father = document.getElementById("li_" + iCategoryID);
				if (show)
				{
					var ul = document.createElement("ul");
					ul.id = "ul_note_" + iCategoryID;
					
					var note = document.createElement("li");
					note.className = "Child";
					
					var img = document.createElement("img");
					img.className = "s";
					img.src = "css/s.gif";
					
					var a = document.createElement("a");
					a.href = "javascript:void(0);";
					a.innerHTML = "请稍候...";
					
					note.appendChild(img);
					note.appendChild(a);
					ul.appendChild(note);
					li_father.appendChild(ul);
				}
				else
				{
					var ul = document.getElementById("ul_note_" + iCategoryID);
					if (ul)
					{
						li_father.removeChild(ul);
					}				
				}
			}
			
			function displayDocList(iCategoryID)
			{				
				var div_docContent = document.getElementById("docContent");
				var div_docList = document.getElementById("docList");
				
				div_docContent.style.display = "none";
				div_docList.style.display = "";
				div_docList.style.padding = 20;
				while (div_docList.childNodes.length > 0)
				{
					div_docList.removeChild(div_docList.childNodes[0]);
				}
				
				var dt = MkSun.Ashop_System.Control_Class_ClassControl.GetDocInfoInCategory(iCategoryID).value.Tables[0];
				if (dt)
				{
					for (var i = 0;i < dt.Rows.length;i++)
					{
						var a = document.createElement("a");
						a.href = "javascript:OpenDocument(" + dt.Rows[i].CategoryID + ");";
						a.innerHTML = "<font color=#1122aa size=2>" + dt.Rows[i].CategoryName + "</font>";
						
						var li = document.createElement("li");
						li.appendChild(a);
						
						var div = document.createElement("div");
						div.appendChild(li);
						
						div_docList.appendChild(div);
					}
				}
			}			
			
			// 加载根节点
			var tree = document.getElementById("CategoryTree");
			var root = document.createElement("li");
			root.id = "li_0";
			tree.appendChild(root);
			
			// 加载页面时显示第一级分类
			ExpandSubCategory(0);