/*
垂直二级导航切换
http://code.ciaoca.cn/
日期：2011-11-16

settings 参数说明
-----
title:一级分类标签
list:二级分类标签
events:按钮事件
type:切换效果类型(slide|toggle)
speed:切换速度
lastclose:点击当前栏目不关闭(true|false)
------------------------------ */
(function($){
	$.fn.navCutover=function(settings){
		if(this.length<1){return;};

		// 默认值
		settings=$.extend({
			title:"h3",
			list:"ul",
			events:"click",
			type:"slide",
			speed:600,
			lastclose:false
		},settings);

		var nav_obj=this;
		var nav_title=nav_obj.find(settings.title);
		var nav_list=nav_obj.find(settings.list);

		nav_obj.delegate(settings.title,settings.events,function(){
			var now_title=$(this);
			var not_title=now_title.siblings(settings.title);
			var now_list=now_title.next(settings.list);
			var not_list=now_list.siblings(settings.list);

			// 限制点击当前栏目不关闭
			if(settings.lastclose&&now_title.hasClass("selected")){return false;};

			not_title.removeClass("selected");
			now_title.toggleClass("selected");
			switch(settings.type){
				case "slide":
					not_list.slideUp(settings.speed);
					now_list.slideToggle(settings.speed);
					break;
				case "toggle":
					not_list.hide();
					now_list.toggle();
					break;
			};
		});
	};
})(jQuery);